/*
 * Decompiled with CFR 0.152.
 */
package cazador.furnaceoverhaul.blocks;

import cazador.furnaceoverhaul.FurnaceOverhaul;
import cazador.furnaceoverhaul.tile.TileEntityIronFurnace;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BlockIronFurnace
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    protected final TextFormatting infoColor;
    protected final int cookTime;
    protected final Supplier<TileEntity> teFunc;

    public BlockIronFurnace(String name, TextFormatting infoColor, int cookTime, Supplier<TileEntity> teFunc) {
        super(Material.field_151573_f);
        this.func_149663_c("furnaceoverhaul." + name);
        this.setRegistryName("furnaceoverhaul", name);
        this.func_149647_a(FurnaceOverhaul.FO_TAB);
        this.func_149711_c(2.0f);
        this.func_149752_b(9.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)));
        this.infoColor = infoColor;
        this.cookTime = cookTime;
        this.teFunc = teFunc;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 14 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(this.infoColor + I18n.func_135052_a((String)"info.furnaceoverhaul.cooktime", (Object[])new Object[]{this.cookTime}));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.teFunc.get();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BURNING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[(meta & 0xC) >> 2]).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)BURNING) != false ? 1 : 0) | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIronFurnace) {
            ItemStackHandler inv = ((TileEntityIronFurnace)te).getInventory();
            int i = 0;
            float f = 0.0f;
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inv.getStackInSlot(j);
                if (itemstack.func_190926_b()) continue;
                f += (float)itemstack.func_190916_E() / (float)Math.min(64, itemstack.func_77976_d());
                ++i;
            }
            return MathHelper.func_76141_d((float)((f /= 3.0f) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        FluidActionResult res;
        ItemStack stack;
        FluidStack fs;
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof TileEntityIronFurnace && ((TileEntityIronFurnace)te).isFluid() && (fs = FluidUtil.getFluidContained((ItemStack)(stack = player.func_184586_b(hand)))) != null && TileEntityIronFurnace.getFluidBurnTime(fs) > 0 && (res = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)FluidUtil.getFluidHandler((World)world, (BlockPos)pos, null), (int)1000, (EntityPlayer)player, (boolean)true)).isSuccess()) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, res.result);
            }
            return true;
        }
        if (!player.func_70093_af() && !world.field_72995_K) {
            player.openGui((Object)FurnaceOverhaul.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIronFurnace && world.func_180495_p(pos).func_177230_c() != state.func_177230_c()) {
            ItemStackHandler inv = ((TileEntityIronFurnace)te).getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
            }
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Vec3d offset = new Vec3d(facing.func_176730_m()).func_186678_a(0.52);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + offset.field_72450_a, d1, d2 + d4 + offset.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d0 + offset.field_72450_a, d1, d2 + d4 + offset.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

