/*
 * Decompiled with CFR 0.152.
 */
package cazador.furnaceoverhaul.handler;

import cazador.furnaceoverhaul.inventory.ContainerFurnace;
import cazador.furnaceoverhaul.tile.TileEntityIronFurnace;
import cazador.furnaceoverhaul.utils.FluidRenderUtil;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiFurnace
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("furnaceoverhaul", "textures/gui/container/guifurnace.png");
    private final InventoryPlayer playerInventory;
    private final TileEntityIronFurnace te;

    public GuiFurnace(InventoryPlayer player, TileEntityIronFurnace te) {
        super((Container)new ContainerFurnace(player, te));
        this.te = te;
        this.playerInventory = player;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.te.isBurning()) {
            int k = this.getBurnLeftScaled(13);
            this.func_73729_b(i + 56, j + 36 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        int l = this.getCookProgressScaled(24);
        this.func_73729_b(i + 79, j + 34, 176, 14, l + 1, 16);
        int k = this.getEnergyStoredScaled(16);
        this.func_73729_b(this.field_147003_i + 142, this.field_147009_r + 35, 176, 31, 3, 16 - k);
        this.field_73735_i += 1.0f;
        this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 14, 176, 47, 16, 64);
        this.field_73735_i -= 1.0f;
        int am = this.getFluidStoredScaled(63);
        if (am > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(63 - am), (float)0.0f);
            FluidRenderUtil.renderTiledFluid(this.field_147003_i + 151, this.field_147009_r + 11, 16, am, 0.0f, this.te.getTank().getFluid());
            GlStateManager.func_179121_F();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.te.func_145838_q().func_149732_F();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 7, this.field_147000_g - 92, 0x404040);
    }

    protected void func_191948_b(int x, int y) {
        super.func_191948_b(x, y);
        if (this.te.getTank().getFluid() != null && this.func_146978_c(151, 11 + (63 - this.getFluidStoredScaled(63)), 16, this.getFluidStoredScaled(63), x, y)) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.furnaceoverhaul.fluid", (Object[])new Object[]{this.te.getTank().getFluidAmount(), this.te.getTank().getFluid().getLocalizedName()}), x, y);
        } else if (this.func_146978_c(142, 35, 3, 16, x, y)) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.furnaceoverhaul.energy", (Object[])new Object[]{this.te.getEnergy()}), x, y);
        }
    }

    private int getEnergyStoredScaled(int pixels) {
        int cur = this.te.getEnergy();
        int max = 80000;
        return GuiFurnace.getPixels(cur, max, pixels);
    }

    private int getFluidStoredScaled(int pixels) {
        int cur = this.te.getTank().getFluidAmount();
        int max = 4000;
        return GuiFurnace.getPixels(cur, max, pixels);
    }

    private int getCookProgressScaled(int pixels) {
        int cur = this.te.getCurrentCookTime();
        int max = this.te.getCookTime();
        return GuiFurnace.getPixels(cur, max, pixels);
    }

    private int getBurnLeftScaled(int pixels) {
        if (this.te.isElectric() && this.te.getEnergy() >= this.te.getEnergyUse()) {
            return pixels;
        }
        return GuiFurnace.getPixels(this.te.getBurnTime(), Math.max(1, this.te.getFuelLength()), pixels);
    }

    public TileEntityIronFurnace getTE() {
        return this.te;
    }

    static int getPixels(float a, float b, int pixels) {
        return (int)Math.floor(a / b * (float)pixels);
    }
}

