/*
 * Decompiled with CFR 0.152.
 */
package cazador.furnaceoverhaul.tile;

import cazador.furnaceoverhaul.FurnaceOverhaul;
import cazador.furnaceoverhaul.blocks.BlockIronFurnace;
import cazador.furnaceoverhaul.inventory.SlotFurnaceFuel;
import cazador.furnaceoverhaul.inventory.SlotFurnaceInput;
import cazador.furnaceoverhaul.inventory.SlotUpgrade;
import cazador.furnaceoverhaul.upgrade.Upgrade;
import cazador.furnaceoverhaul.upgrade.Upgrades;
import cazador.furnaceoverhaul.utils.MutableEnergyStorage;
import cazador.furnaceoverhaul.utils.OreProcessingRegistry;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityIronFurnace
extends TileEntity
implements ITickable {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int[] SLOT_UPGRADE = new int[]{3, 4, 5};
    public static final int MAX_FE_TRANSFER = 1200;
    public static final int MAX_ENERGY_STORED = 80000;
    protected final ItemStackHandler inv = new ItemStackHandler(6){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return SlotFurnaceInput.isStackValid(stack);
            }
            if (slot == 1) {
                return SlotFurnaceFuel.isStackValid(stack);
            }
            return slot > 2 ? SlotUpgrade.isStackValid(stack) : true;
        }
    };
    private final RangedWrapper TOP = new RangedWrapper((IItemHandlerModifiable)this.inv, 0, 1);
    private final RangedWrapper SIDES = new RangedWrapper((IItemHandlerModifiable)this.inv, 1, 2);
    private final RangedWrapper BOTTOM = new RangedWrapper((IItemHandlerModifiable)this.inv, 2, 3);
    protected MutableEnergyStorage energy = new MutableEnergyStorage(80000, 1200, this.getEnergyUse());
    protected FluidTank tank = new FluidTank(4000){

        public boolean canFillFluidType(FluidStack fluid) {
            return super.canFillFluidType(fluid) && TileEntityIronFurnace.getFluidBurnTime(fluid) > 0;
        }
    };
    protected ItemStack recipeKey = ItemStack.field_190927_a;
    protected ItemStack recipeOutput = ItemStack.field_190927_a;
    protected ItemStack failedMatch = ItemStack.field_190927_a;
    protected int burnTime = 0;
    protected int currentCookTime = 0;
    protected int fuelLength = 0;
    @GameRegistry.ItemStackHolder(value="minecraft:sponge", meta=1)
    public static final ItemStack WET_SPONGE = ItemStack.field_190927_a;
    private boolean hasOreResult = false;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
        this.energy.setEnergy(tag.func_74762_e("energy"));
        this.burnTime = tag.func_74762_e("burn_time");
        this.fuelLength = tag.func_74762_e("fuel_length");
        this.currentCookTime = tag.func_74762_e("current_cook_time");
        this.tank.readFromNBT(tag.func_74775_l("tank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("inv", (NBTBase)this.inv.serializeNBT());
        compound.func_74768_a("energy", this.energy.getEnergyStored());
        compound.func_74768_a("burn_time", this.burnTime);
        compound.func_74768_a("fuel_length", this.fuelLength);
        compound.func_74768_a("current_cook_time", this.currentCookTime);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    public void readContainerSync(int[] fromNet, FluidStack fluid) {
        this.energy.setEnergy(fromNet[0]);
        this.burnTime = fromNet[1];
        this.fuelLength = fromNet[2];
        this.currentCookTime = fromNet[3];
        this.tank.setFluid(fluid);
    }

    public void writeContainerSync(ByteBuf buf) {
        buf.writeInt(this.energy.getEnergyStored());
        buf.writeInt(this.burnTime);
        buf.writeInt(this.fuelLength);
        buf.writeInt(this.currentCookTime);
        FluidStack fluid = this.tank.getFluid();
        if (fluid == null) {
            buf.writeInt(4);
            buf.writeCharSequence((CharSequence)"null", StandardCharsets.UTF_8);
        } else {
            buf.writeInt(fluid.getFluid().getName().length());
            buf.writeCharSequence((CharSequence)fluid.getFluid().getName(), StandardCharsets.UTF_8);
            buf.writeInt(fluid.amount);
        }
    }

    public final void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack fuel = ItemStack.field_190927_a;
        boolean canSmelt = this.canSmelt();
        if (!this.isBurning() && (this.isAltFuel() || !(fuel = this.inv.getStackInSlot(1)).func_190926_b()) && canSmelt) {
            this.burnFuel(fuel, false);
        }
        boolean wasBurning = this.isBurning();
        if (this.isBurning()) {
            --this.burnTime;
            if (canSmelt) {
                this.smelt();
            } else {
                this.currentCookTime = 0;
            }
        }
        if (!this.isBurning() && (this.isAltFuel() || !(fuel = this.inv.getStackInSlot(1)).func_190926_b()) && this.canSmelt()) {
            this.burnFuel(fuel, wasBurning);
        }
        if (wasBurning && !this.isBurning()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getDimState());
        }
    }

    public boolean isBurning() {
        return this.getBurnTime() > 0;
    }

    protected void smelt() {
        ++this.currentCookTime;
        if (this.currentCookTime >= this.getCookTime()) {
            this.currentCookTime = 0;
            this.smeltItem();
        }
    }

    protected void burnFuel(ItemStack fuel, boolean burnedThisTick) {
        if (this.isElectric() && this.energy.getEnergyStored() >= this.getEnergyUse()) {
            this.burnTime = this.energy.getEnergyStored() >= this.getEnergyUse() ? 1 : 0;
            this.fuelLength = this.burnTime;
            if (this.isBurning()) {
                this.energy.extractEnergy(this.getEnergyUse(), false);
            }
        } else if (this.isFluid() && this.tank.getFluid() != null) {
            this.fuelLength = this.burnTime = TileEntityIronFurnace.getFluidBurnTime(this.tank.getFluid());
            if (this.isBurning()) {
                --this.tank.getFluid().amount;
            }
        } else {
            this.fuelLength = this.burnTime = this.getItemBurnTime(fuel);
            if (this.isBurning()) {
                Item item = fuel.func_77973_b();
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.inv.setStackInSlot(1, item.getContainerItem(fuel));
                }
            }
        }
        if (this.isBurning() && !burnedThisTick) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getLitState());
        }
        this.func_70296_d();
    }

    protected boolean canSmelt() {
        ItemStack input = this.inv.getStackInSlot(0);
        ItemStack output = this.inv.getStackInSlot(2);
        if (input.func_190926_b() || input == this.failedMatch) {
            return false;
        }
        if (this.recipeKey.func_190926_b() || !OreDictionary.itemMatches((ItemStack)this.recipeKey, (ItemStack)input, (boolean)false)) {
            boolean matched = false;
            for (Map.Entry e : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)((ItemStack)e.getKey()), (ItemStack)input, (boolean)false)) continue;
                this.recipeKey = (ItemStack)e.getKey();
                this.recipeOutput = (ItemStack)e.getValue();
                matched = true;
                this.failedMatch = ItemStack.field_190927_a;
                break;
            }
            if (!matched && this.hasUpgrade(Upgrades.ORE_PROCESSING)) {
                ItemStack stack = OreProcessingRegistry.getSmeltingResult(input);
                if (stack.func_190926_b()) {
                    this.recipeKey = ItemStack.field_190927_a;
                    this.recipeOutput = ItemStack.field_190927_a;
                    this.failedMatch = input;
                    return false;
                }
                this.recipeKey = input;
                this.recipeOutput = stack;
                matched = true;
                this.failedMatch = ItemStack.field_190927_a;
            } else if (!matched) {
                this.recipeKey = ItemStack.field_190927_a;
                this.recipeOutput = ItemStack.field_190927_a;
                this.failedMatch = input;
                return false;
            }
        }
        ItemStack check = this.recipeOutput;
        if (!this.hasOreResult && this.hasUpgrade(Upgrades.PROCESSING)) {
            check = check.func_77946_l();
            check.func_190917_f(check.func_190916_E());
        }
        return !this.recipeOutput.func_190926_b() && (output.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)check, (ItemStack)output) && check.func_190916_E() + output.func_190916_E() <= output.func_77976_d());
    }

    public void smeltItem() {
        ItemStack curOutput;
        ItemStack input = this.inv.getStackInSlot(0);
        ItemStack recipeOutput = this.getResult();
        if (!this.hasOreResult && this.hasUpgrade(Upgrades.PROCESSING)) {
            recipeOutput.func_190917_f(recipeOutput.func_190916_E());
        }
        if ((curOutput = this.inv.getStackInSlot(2)).func_190926_b()) {
            this.inv.setStackInSlot(2, recipeOutput);
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)curOutput, (ItemStack)recipeOutput)) {
            curOutput.func_190917_f(recipeOutput.func_190916_E());
        }
        if (input.func_77969_a(WET_SPONGE) && this.inv.getStackInSlot(1).func_77973_b() == Items.field_151133_ar) {
            this.inv.setStackInSlot(1, new ItemStack(Items.field_151131_as));
        }
        input.func_190918_g(1);
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasUpgrade(Upgrade upg) {
        for (int slot : SLOT_UPGRADE) {
            if (!upg.matches(this.inv.getStackInSlot(slot))) continue;
            return true;
        }
        return false;
    }

    public int getItemBurnTime(ItemStack stack) {
        if (this.isAltFuel()) {
            return 0;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)stack) * (this.hasUpgrade(Upgrades.EFFICIENCY) ? 2 : 1);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY && this.isElectric() || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.isFluid()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.isElectric()) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Object h = facing == null ? this.inv : (facing == EnumFacing.DOWN ? this.BOTTOM : (facing == EnumFacing.UP ? this.TOP : this.SIDES));
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast(h);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.isFluid()) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IBlockState getDimState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockIronFurnace.BURNING, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState getLitState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockIronFurnace.BURNING, (Comparable)Boolean.valueOf(true));
    }

    public boolean isElectric() {
        return this.hasUpgrade(Upgrades.ELECTRIC_FUEL);
    }

    public boolean isFluid() {
        return this.hasUpgrade(Upgrades.LIQUID_FUEL);
    }

    public boolean isAltFuel() {
        return this.isElectric() || this.isFluid();
    }

    public ItemStackHandler getInventory() {
        return this.inv;
    }

    private ItemStack getResult() {
        if (this.hasUpgrade(Upgrades.ORE_PROCESSING)) {
            ItemStack out = OreProcessingRegistry.getSmeltingResult(this.inv.getStackInSlot(0)).func_77946_l();
            if (out.func_190926_b() && TileEntityIronFurnace.isOre(this.recipeKey)) {
                out = ((ItemStack)FurnaceRecipes.func_77602_a().func_77599_b().get(this.recipeKey)).func_77946_l();
                out.func_190917_f(out.func_190916_E());
            }
            if (!out.func_190926_b()) {
                this.hasOreResult = true;
                return out;
            }
        }
        this.hasOreResult = false;
        return ((ItemStack)FurnaceRecipes.func_77602_a().func_77599_b().get(this.recipeKey)).func_77946_l();
    }

    private static boolean isOre(ItemStack stack) {
        int[] ids;
        if (!stack.func_77981_g() && !stack.func_77984_f()) {
            stack.func_77964_b(0);
        }
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)i).contains("ore")) continue;
            return true;
        }
        return false;
    }

    public final int getCookTime() {
        return this.hasUpgrade(Upgrades.SPEED) ? this.getSpeedyCookTime() : this.getDefaultCookTime();
    }

    protected int getDefaultCookTime() {
        return 170;
    }

    protected int getSpeedyCookTime() {
        return 140;
    }

    public int getEnergyUse() {
        return 600;
    }

    public int getEnergy() {
        return this.energy.getEnergyStored();
    }

    public int getCurrentCookTime() {
        return this.currentCookTime;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getFuelLength() {
        return this.fuelLength;
    }

    public void clear() {
        for (int i = 0; i < 6; ++i) {
            this.inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public NBTTagCompound writeHwylaData(NBTTagCompound tag) {
        tag.func_74782_a("inv", (NBTBase)this.inv.serializeNBT());
        tag.func_74768_a("current_cook_time", this.currentCookTime);
        if (this.isFluid() && this.tank.getFluidAmount() > 0) {
            tag.func_74782_a("fluid", (NBTBase)this.tank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public static int getFluidBurnTime(FluidStack stack) {
        return stack == null ? 0 : FurnaceOverhaul.FLUID_FUELS.getInt((Object)stack.getFluid().getName());
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }
}

