/*
 * Decompiled with CFR 0.152.
 */
package cazador.furnaceoverhaul.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidRenderUtil {
    public static void renderTiledFluid(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        if (fluidStack == null) {
            return;
        }
        TextureAtlasSprite fluidSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill(fluidStack).toString());
        FluidRenderUtil.setColorRGBA(fluidStack.getFluid().getColor(fluidStack));
        FluidRenderUtil.renderTiledTextureAtlas(x, y, width, height, depth, fluidSprite, fluidStack.getFluid().isGaseous(fluidStack));
    }

    private static void setColorRGBA(int color) {
        float a = (float)FluidRenderUtil.alpha(color) / 255.0f;
        float r = (float)FluidRenderUtil.red(color) / 255.0f;
        float g = (float)FluidRenderUtil.green(color) / 255.0f;
        float b = (float)FluidRenderUtil.blue(color) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    private static void renderTiledTextureAtlas(int x, int y, int width, int height, float depth, TextureAtlasSprite sprite, boolean upsideDown) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        FluidRenderUtil.putTiledTextureQuads(renderer, x, y, width, height, depth, sprite, upsideDown);
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
    }

    private static void putTiledTextureQuads(BufferBuilder renderer, int x, int y, int width, int height, float depth, TextureAtlasSprite sprite, boolean upsideDown) {
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int renderHeight = Math.min(sprite.func_94216_b(), height);
            height -= renderHeight;
            float v2 = sprite.func_94207_b((double)(16.0f * (float)renderHeight / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int renderWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= renderWidth;
                float u2 = sprite.func_94214_a((double)(16.0f * (float)renderWidth / (float)sprite.func_94211_a()));
                if (upsideDown) {
                    renderer.func_181662_b((double)x2, (double)y, (double)depth).func_187315_a((double)u2, (double)v1).func_181675_d();
                    renderer.func_181662_b((double)x2, (double)(y + renderHeight), (double)depth).func_187315_a((double)u2, (double)v2).func_181675_d();
                    renderer.func_181662_b((double)(x2 + renderWidth), (double)(y + renderHeight), (double)depth).func_187315_a((double)u1, (double)v2).func_181675_d();
                    renderer.func_181662_b((double)(x2 + renderWidth), (double)y, (double)depth).func_187315_a((double)u1, (double)v1).func_181675_d();
                } else {
                    renderer.func_181662_b((double)x2, (double)y, (double)depth).func_187315_a((double)u1, (double)v1).func_181675_d();
                    renderer.func_181662_b((double)x2, (double)(y + renderHeight), (double)depth).func_187315_a((double)u1, (double)v2).func_181675_d();
                    renderer.func_181662_b((double)(x2 + renderWidth), (double)(y + renderHeight), (double)depth).func_187315_a((double)u2, (double)v2).func_181675_d();
                    renderer.func_181662_b((double)(x2 + renderWidth), (double)y, (double)depth).func_187315_a((double)u2, (double)v1).func_181675_d();
                }
                x2 += renderWidth;
            } while (width2 > 0);
            y += renderHeight;
        } while (height > 0);
    }

    private static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    private static int red(int c) {
        return c >> 16 & 0xFF;
    }

    private static int green(int c) {
        return c >> 8 & 0xFF;
    }

    private static int blue(int c) {
        return c & 0xFF;
    }
}

