/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.entity.PlayerGhostRenderer;
import de.maxhenkel.gravestone.events.BlockEvents;
import de.maxhenkel.gravestone.events.DeathEvents;
import de.maxhenkel.gravestone.gui.DeathItemsContainer;
import de.maxhenkel.gravestone.gui.DeathItemsScreen;
import de.maxhenkel.gravestone.items.DeathInfoItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.tileentity.GravestoneRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="gravestone")
@Mod(value="gravestone")
public class Main {
    public static final String MODID = "gravestone";
    public static final Logger LOGGER = LogManager.getLogger((String)"gravestone");
    public static GraveStoneBlock GRAVESTONE;
    public static Item GRAVESTONE_ITEM;
    public static TileEntityType<GraveStoneTileEntity> GRAVESTONE_TILEENTITY;
    public static DeathInfoItem DEATHINFO;
    public static EntityType<GhostPlayerEntity> GHOST;
    public static ContainerType DEATH_INFO_INVENTORY_CONTAINER;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::configEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    @SubscribeEvent
    public void configEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            Config.loadServer();
        } else if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            Config.loadClient();
        }
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer(GRAVESTONE_TILEENTITY, GravestoneRenderer::new);
        ScreenManager.IScreenFactory factory = (container, playerInventory, name) -> new DeathItemsScreen(playerInventory, (DeathItemsContainer)container, name);
        ScreenManager.func_216911_a((ContainerType)DEATH_INFO_INVENTORY_CONTAINER, (ScreenManager.IScreenFactory)factory);
        RenderingRegistry.registerEntityRenderingHandler(GHOST, manager -> new PlayerGhostRenderer(manager));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[1];
        GRAVESTONE = new GraveStoneBlock();
        blockArray[0] = GRAVESTONE;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[2];
        itemArray[0] = GRAVESTONE_ITEM = GRAVESTONE.toItem();
        DEATHINFO = new DeathInfoItem();
        itemArray[1] = DEATHINFO;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        GRAVESTONE_TILEENTITY = TileEntityType.Builder.func_223042_a(GraveStoneTileEntity::new, (Block[])new Block[]{GRAVESTONE}).func_206865_a(null);
        GRAVESTONE_TILEENTITY.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(GRAVESTONE_TILEENTITY);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        GHOST = EntityType.Builder.func_220322_a(GhostPlayerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_206830_a("gravestone:player_ghost");
        GHOST.setRegistryName(new ResourceLocation(MODID, "player_ghost"));
        event.getRegistry().register(GHOST);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        DEATH_INFO_INVENTORY_CONTAINER = new ContainerType(DeathItemsContainer::new);
        DEATH_INFO_INVENTORY_CONTAINER.setRegistryName(new ResourceLocation(MODID, "death_items"));
        event.getRegistry().register((IForgeRegistryEntry)DEATH_INFO_INVENTORY_CONTAINER);
    }
}

