/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.GraveProcessor;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.util.Tools;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DeathEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!Config.giveDeathNotes) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (Tools.keepInventory(event.getPlayer())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
            if (!DeathInfo.isDeathInfoItem(stack)) continue;
            event.getPlayer().field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity) && !Config.livingGraves) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        try {
            LivingEntity entity = (LivingEntity)event.getEntity();
            GraveProcessor graveProcessor = new GraveProcessor(entity);
            Collection drops = event.getDrops();
            if (graveProcessor.placeGraveStone(drops)) {
                drops.clear();
            } else if (entity instanceof ServerPlayerEntity) {
                String modname = new TranslationTextComponent("message.name", new Object[0]).func_150254_d();
                String message = new TranslationTextComponent("message.create_grave_failed", new Object[0]).func_150254_d();
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.func_145747_a((ITextComponent)new StringTextComponent("[" + modname + "] " + message));
            }
            if (Config.giveDeathNotes) {
                graveProcessor.givePlayerNote();
            }
        }
        catch (Exception e) {
            Main.LOGGER.warn("Failed to process death of '{}'", (Object)event.getEntity().func_200200_C_().func_150261_e());
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!Config.giveDeathNotes) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!Tools.keepInventory(player)) {
            return;
        }
        try {
            DeathInfo info = new DeathInfo(player.func_180425_c(), DimensionType.func_212678_a((DimensionType)player.field_71093_bK).toString(), new ArrayList<ItemStack>(), player.func_200200_C_().func_150261_e(), System.currentTimeMillis(), player.func_110124_au());
            ItemStack stack = new ItemStack((IItemProvider)Main.DEATHINFO);
            info.addToItemStack(stack);
            player.field_71071_by.func_70441_a(stack);
        }
        catch (Exception e) {
            Main.LOGGER.warn("Failed to give player '{}' death note", (Object)player.func_200200_C_().func_150261_e());
        }
    }
}

