/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.gui.PageList;
import de.maxhenkel.gravestone.util.Tools;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class DeathInfoScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("gravestone", "textures/gui/info.png");
    private static final int TEXTURE_X = 163;
    private static final int TEXTURE_Y = 165;
    private DeathInfo info;
    private Button buttonPrev;
    private Button buttonNext;
    private int page;
    private PageList pageList;

    public DeathInfoScreen(DeathInfo info) {
        super((ITextComponent)new TranslationTextComponent("gui.deathinfo.title", new Object[0]));
        this.info = info;
        this.page = 0;
        this.pageList = new PageList(info.getItems(), this);
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        int left = (this.width - 163) / 2;
        this.buttonPrev = (Button)this.addButton((Widget)new Button(left, 190, 75, 20, new TranslationTextComponent("button.prev", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                DeathInfoScreen.this.page--;
                if (DeathInfoScreen.this.page < 0) {
                    DeathInfoScreen.this.page = 0;
                }
                DeathInfoScreen.this.checkButtons();
            }
        }));
        this.buttonNext = (Button)this.addButton((Widget)new Button(left + 163 - 75, 190, 75, 20, new TranslationTextComponent("button.next", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                DeathInfoScreen.this.page++;
                if (DeathInfoScreen.this.page > DeathInfoScreen.this.pageList.getPages()) {
                    DeathInfoScreen.this.page = DeathInfoScreen.this.pageList.getPages();
                }
                DeathInfoScreen.this.checkButtons();
            }
        }));
        this.buttonPrev.active = false;
        if (this.pageList.getPages() <= 0) {
            this.buttonNext.active = false;
        }
    }

    protected void checkButtons() {
        this.buttonPrev.active = this.page > 0;
        this.buttonNext.active = this.page < this.pageList.getPages();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        int left = (this.width - 163) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.blit(left, 20, 0, 0, 163, 165);
        if (this.page == 0) {
            this.drawFirstPage(mouseX, mouseY);
        } else if (this.page > 0 && this.pageList.getPages() >= this.page - 1) {
            this.pageList.drawPage(this.page - 1);
        }
    }

    public void drawFirstPage(int mouseX, int mouseY) {
        String title = new TranslationTextComponent("gui.deathinfo.title", new Object[0]).func_150254_d();
        int titleWidth = this.font.func_78256_a(title);
        this.font.func_211126_b(TextFormatting.BLACK + "" + TextFormatting.UNDERLINE + title, (float)((this.width - titleWidth) / 2), 30.0f, 0);
        String textName = new TranslationTextComponent("gui.deathinfo.name", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textName, 50);
        String name = this.info.getName();
        this.drawRight(TextFormatting.DARK_GRAY + name, 50);
        String textDimension = new TranslationTextComponent("gui.deathinfo.dimension", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textDimension, 63);
        String dimension = Tools.translateDimension(this.info.getDimension());
        this.drawRight(TextFormatting.DARK_GRAY + dimension, 63);
        String textTime = new TranslationTextComponent("gui.deathinfo.time", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textTime, 76);
        String time = Tools.timeToString(this.info.getTime());
        this.drawRight(TextFormatting.DARK_GRAY + time, 76);
        String textLocation = new TranslationTextComponent("gui.deathinfo.location", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textLocation, 89);
        String locX = "X: " + this.info.getDeathLocation().func_177958_n();
        String locY = "Y: " + this.info.getDeathLocation().func_177956_o();
        String locZ = "Z: " + this.info.getDeathLocation().func_177952_p();
        this.drawRight(TextFormatting.DARK_GRAY + locX, 89);
        this.drawRight(TextFormatting.DARK_GRAY + locY, 102);
        this.drawRight(TextFormatting.DARK_GRAY + locZ, 115);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RemoteClientPlayerEntity player = new RemoteClientPlayerEntity(this.minecraft.field_71441_e, new GameProfile(this.info.getUuid(), this.info.getName()));
        InventoryScreen.func_228187_a_((int)(this.width / 2), (int)175, (int)30, (float)(this.width / 2 - mouseX), (float)(100 - mouseY), (LivingEntity)player);
    }

    public void drawItem(String string, int height) {
        int left = (this.width - 163) / 2;
        int offset = 40;
        int offsetLeft = left + offset;
        this.font.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawItemSize(String string, int height) {
        int left = (this.width - 163) / 2;
        int offset = 15;
        int offsetLeft = left + offset;
        this.font.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawLeft(String string, int height) {
        int left = (this.width - 163) / 2;
        int offset = 7;
        int offsetLeft = left + offset;
        this.font.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawRight(String string, int height) {
        int left = (this.width - 163) / 2;
        int offset = 14;
        int strWidth = this.font.func_78256_a(string);
        this.font.func_211126_b(string, (float)(left + 163 - strWidth - offset), (float)height, 0);
    }

    public FontRenderer getFontRenderer() {
        return this.font;
    }
}

