/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.util.PlayerSkins;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;

public class GravestoneRenderer
extends TileEntityRenderer<GraveStoneTileEntity> {
    public GravestoneRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(GraveStoneTileEntity target, float f1, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int i2) {
        String name = target.getPlayerName();
        if (name == null || name.isEmpty()) {
            return;
        }
        Direction direction = (Direction)target.func_195044_w().func_177229_b((IProperty)GraveStoneBlock.FACING);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + direction.func_185119_l()));
        FontRenderer renderer = this.field_228858_b_.func_147548_a();
        int textWidth = renderer.func_78256_a(name);
        double textScale = Math.min(0.8 / (double)textWidth, 0.02);
        matrixStack.func_227861_a_(0.0, 0.3, 0.37);
        matrixStack.func_227862_a_((float)textScale, (float)textScale, (float)textScale);
        float left = -renderer.func_78256_a(name) / 2;
        renderer.func_228079_a_(name, left, 0.0f, Config.graveTextColor, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, light);
        matrixStack.func_227865_b_();
        BlockState state = target.func_145831_w().func_180495_p(target.func_174877_v().func_177977_b());
        if (state == null) {
            return;
        }
        Block block = state.func_177230_c();
        if (block == null) {
            return;
        }
        boolean render = block.func_220081_d(state, (IBlockReader)target.func_145831_w(), target.func_174877_v().func_177977_b());
        if (target.renderHead() && target.getPlayerUUID() != null && !target.getPlayerUUID().isEmpty() && Config.renderSkull && render) {
            try {
                this.renderSkull(target.getPlayerUUID(), target.getPlayerName(), direction, matrixStack, buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void renderSkull(String uuid, String name, Direction rotation, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        HumanoidHeadModel model = new HumanoidHeadModel();
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (uuid != null) {
            try {
                resourcelocation = PlayerSkins.getSkin(UUID.fromString(uuid), name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotation.func_185119_l()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-26.0f));
        matrixStack.func_227861_a_(0.0, -0.14, 0.18);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-61.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        model.func_225598_a_(matrixStack, buffer.getBuffer(model.func_228282_a_(resourcelocation)), 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }
}

