/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.util;

import de.maxhenkel.gravestone.Config;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.registries.ForgeRegistries;

public class Tools {
    public static String translateDimension(String dim) {
        Map<String, String> dims = Config.dimensionNames;
        String name = dims.get(dim);
        if (name == null || name.isEmpty()) {
            return dim;
        }
        return name;
    }

    public static String translateItem(ItemStack stack) {
        return new TranslationTextComponent(stack.func_77977_a(), new Object[0]).func_150261_e();
    }

    public static boolean isArrayEmpty(Object[] obj) {
        for (Object o : obj) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static boolean keepInventory(PlayerEntity player) {
        try {
            return player.func_130014_f_().func_72912_H().func_82574_x().func_223586_b(GameRules.field_223600_c);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String timeToString(long time) {
        if (time == 0L) {
            return "";
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        SimpleDateFormat sdf = new SimpleDateFormat(Config.dateFormat);
        return sdf.format(c.getTime());
    }

    public static boolean isAirBlock(Block block) {
        return block.equals(Blocks.field_150350_a) || block.equals(Blocks.field_201941_jj) || block.equals(Blocks.field_201940_ji);
    }

    @Nullable
    public static Block getBlock(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0], split[1]));
                if (Tools.isAirBlock(b)) {
                    return null;
                }
                return b;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        if (shapes.length <= 0) {
            return VoxelShapes.func_197880_a();
        }
        VoxelShape combined = shapes[0];
        for (int i = 1; i < shapes.length; ++i) {
            combined = VoxelShapes.func_197872_a((VoxelShape)combined, (VoxelShape)shapes[i]);
        }
        return combined;
    }
}

