/*
 * Decompiled with CFR 0.152.
 */
package com.github.gregtaoo;

import com.github.gregtaoo.gregfood;
import java.util.Random;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3000;

class WoodenSteamerEntity
extends class_2586
implements BlockEntityClientSerializable,
class_3000 {
    public boolean enableUp = false;
    public boolean canLit = false;
    public boolean lit = false;
    public int floor = this.getFloors(this.field_11867);
    public final class_2371<class_1799> upItems = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    public int[] upTimes = new int[]{0, 0, 0, 0, 0, 0};
    public final class_2371<class_1799> downItems = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    public int[] downTimes = new int[]{0, 0, 0, 0, 0, 0};

    public WoodenSteamerEntity() {
        super(gregfood.Wooden_Steamer_Entity);
    }

    public void updateBlock() {
        this.enableUp = this.getEnableUp();
        this.floor = this.getFloors(this.field_11867);
        this.canLit = this.getLitCond(this.field_11867);
        this.setLit();
    }

    public void setLit() {
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(this.lit)));
        }
    }

    public boolean getEnableUp() {
        return this.method_11010().method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682;
    }

    public boolean hasFire(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10036) || blockState.method_27852(class_2246.field_22089);
    }

    public int getFloors(class_2338 pos) {
        int floors = 1;
        class_2338 locatePos = pos.method_10074();
        if (this.field_11863 != null) {
            class_2680 blockState = this.field_11863.method_8320(locatePos);
            while (blockState.method_27852(gregfood.Wooden_Steamer)) {
                class_2586 entity = this.field_11863.method_8321(locatePos);
                if (entity instanceof WoodenSteamerEntity && ((WoodenSteamerEntity)entity).enableUp) {
                    ++floors;
                    locatePos = locatePos.method_10074();
                    continue;
                }
                return floors;
            }
        }
        return floors;
    }

    public boolean getLitCond(class_2338 pos) {
        class_2338 locatePos = pos.method_10087(this.floor);
        if (this.field_11863 != null) {
            class_2680 cauldronState = this.field_11863.method_8320(locatePos);
            return cauldronState.method_27852(class_2246.field_10593) && (Integer)cauldronState.method_11654((class_2769)class_2741.field_12513) > 0 && this.hasFire(this.field_11863.method_8320(locatePos.method_10074()));
        }
        return false;
    }

    public boolean insertItem(class_2338 pos, class_1799 itemStack, class_1799 itemBeingCooked, int cookingTime) {
        this.updateBlock();
        for (int floors = this.floor; this.field_11863 != null && floors >= 0; --floors) {
            int i;
            WoodenSteamerEntity entity;
            class_2586 blockEntity = this.field_11863.method_8321(pos.method_10087(floors - 1));
            WoodenSteamerEntity woodenSteamerEntity = entity = blockEntity instanceof WoodenSteamerEntity ? (WoodenSteamerEntity)blockEntity : null;
            if (entity == null) continue;
            this.updateBlock();
            for (i = 0; i < 4; ++i) {
                if (!((class_1799)entity.downItems.get(i)).method_7960()) continue;
                entity.downItems.set(i, (Object)itemStack);
                entity.downItems.set(i + 4, (Object)itemBeingCooked);
                entity.downTimes[i] = cookingTime;
                this.updateBlock();
                return true;
            }
            if (!entity.enableUp) continue;
            for (i = 0; i < 4; ++i) {
                if (!((class_1799)entity.upItems.get(i)).method_7960()) continue;
                entity.upItems.set(i, (Object)itemStack);
                entity.upItems.set(i + 4, (Object)itemBeingCooked);
                entity.upTimes[i] = cookingTime;
                this.updateBlock();
                return true;
            }
        }
        return false;
    }

    public class_1799 pickItem(class_2338 pos, boolean isPick) {
        this.updateBlock();
        for (int floors = this.floor; this.field_11863 != null && floors >= 0; --floors) {
            int i;
            WoodenSteamerEntity entity;
            class_2586 blockEntity = this.field_11863.method_8321(pos.method_10087(this.floor - floors));
            WoodenSteamerEntity woodenSteamerEntity = entity = blockEntity instanceof WoodenSteamerEntity ? (WoodenSteamerEntity)blockEntity : null;
            if (entity == null) continue;
            if (entity.enableUp) {
                for (i = 3; i >= 0; --i) {
                    if (((class_1799)entity.upItems.get(i)).method_7960()) continue;
                    class_1799 itemStack = (class_1799)entity.upItems.get(i);
                    if (isPick) {
                        entity.upItems.set(i, (Object)class_1799.field_8037);
                        entity.upItems.set(i + 4, (Object)class_1799.field_8037);
                        entity.upTimes[i] = 0;
                    }
                    this.updateBlock();
                    return itemStack;
                }
            }
            for (i = 3; i >= 0; --i) {
                if (((class_1799)entity.downItems.get(i)).method_7960()) continue;
                class_1799 itemStack = (class_1799)entity.downItems.get(i);
                if (isPick) {
                    entity.downItems.set(i, (Object)class_1799.field_8037);
                    entity.downItems.set(i + 4, (Object)class_1799.field_8037);
                    entity.downTimes[i] = 0;
                }
                this.updateBlock();
                return itemStack;
            }
        }
        return class_1799.field_8037;
    }

    public void method_16896() {
        class_2586 blockEntity;
        class_1937 world = this.field_11863;
        class_2338 blockPos = this.method_11016();
        if (world != null && (blockEntity = world.method_8321(blockPos)) instanceof WoodenSteamerEntity) {
            WoodenSteamerEntity entity = (WoodenSteamerEntity)blockEntity;
            entity.updateBlock();
            if (entity.floor > 5) {
                return;
            }
            if (entity.canLit) {
                boolean isLit = false;
                for (int i = 0; i < 4; ++i) {
                    if (entity.upTimes[i] <= 0) {
                        entity.upItems.set(i, (Object)((class_1799)entity.upItems.get(i + 4)));
                    } else {
                        int n = i;
                        entity.upTimes[n] = entity.upTimes[n] - 1;
                        isLit = true;
                    }
                    if (entity.downTimes[i] <= 0) {
                        entity.downItems.set(i, (Object)((class_1799)entity.downItems.get(i + 4)));
                    } else {
                        int n = i;
                        entity.downTimes[n] = entity.downTimes[n] - 1;
                        isLit = true;
                    }
                    entity.lit = isLit;
                }
                Random random = new Random();
                if (entity.lit && random.nextInt(2400) == 1) {
                    class_2680 cauldronState = world.method_8320(blockPos.method_10087(entity.floor));
                    int level = (Integer)cauldronState.method_11654((class_2769)class_2741.field_12513);
                    world.method_8501(blockPos.method_10087(entity.floor), (class_2680)cauldronState.method_11657((class_2769)class_2741.field_12513, (Comparable)Integer.valueOf(Math.max(1, level - 1))));
                    if (level - 1 <= 0) {
                        world.method_8501(blockPos.method_10087(entity.floor), class_2246.field_10593.method_9564());
                    }
                }
                if (world.method_8608() && random.nextInt(100) == 1) {
                    class_2400 defaultParticleType = class_2398.field_17431;
                    world.method_17452((class_2394)defaultParticleType, true, (double)entity.field_11867.method_10263() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)entity.field_11867.method_10264() + random.nextDouble() + random.nextDouble(), (double)entity.field_11867.method_10260() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
                }
            } else {
                entity.lit = false;
            }
        }
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        this.enableUp = tag.method_10577("up");
        this.canLit = tag.method_10577("can");
        this.lit = tag.method_10577("lit");
        this.floor = tag.method_10550("floor");
        class_1262.method_5429((class_2487)tag, this.downItems);
        this.upTimes = tag.method_10561("uptime");
        class_1262.method_5429((class_2487)tag, this.upItems);
        this.downTimes = tag.method_10561("downtime");
        this.updateBlock();
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("up", this.enableUp);
        tag.method_10556("can", this.canLit);
        tag.method_10556("lit", this.lit);
        tag.method_10569("floor", this.floor);
        class_1262.method_5426((class_2487)tag, this.downItems);
        tag.method_10539("uptime", this.upTimes);
        class_1262.method_5426((class_2487)tag, this.upItems);
        tag.method_10539("downtime", this.downTimes);
        return tag;
    }

    public void fromClientTag(class_2487 tag) {
        super.method_11014(this.method_11010(), tag);
        class_1262.method_5429((class_2487)tag, this.downItems);
        class_1262.method_5429((class_2487)tag, this.upItems);
    }

    public class_2487 toClientTag(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.downItems);
        class_1262.method_5426((class_2487)tag, this.upItems);
        return tag;
    }
}

