/*
 * Decompiled with CFR 0.152.
 */
package headdowndisplay.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import headdowndisplay.HDD;
import headdowndisplay.config.HDDConfig;
import headdowndisplay.config.hotbar.entry.HideLevel;
import headdowndisplay.config.hotbar.entry.Triggers;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
abstract class InGameHudMixin {
    @Shadow
    @Final
    private final class_310 field_2035 = class_310.method_1551();
    @Shadow
    private int field_2029;
    @Unique
    private static final class_304[] hotbarKeys = class_310.method_1551().field_1690.field_1852;
    @Unique
    private static final int minY = 0;
    @Unique
    private static int selectedSlot = -1;
    @Unique
    private static class_1799 selectedItem;
    @Unique
    private static int direction;
    @Unique
    private static int ticksSinceTop;
    @Unique
    private static int maxY;
    @Unique
    private static float y;
    @Unique
    private static float previousY;
    @Unique
    private static float frameY;
    @Unique
    private static int pressTicks;

    InGameHudMixin() {
    }

    @Unique
    private static void translate(class_4587 matrices) {
        if (HDDConfig.instance.hotbar.lower) {
            matrices.method_22903();
            matrices.method_22904(0.0, (double)frameY, 0.0);
        }
    }

    @Unique
    private static void pop(class_4587 matrices) {
        if (HDDConfig.instance.hotbar.lower) {
            matrices.method_22909();
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo info) {
        maxY = switch (HDDConfig.instance.hotbar.hideLevel) {
            case HideLevel.ALL -> this.field_2029;
            case HideLevel.CUSTOM -> HDDConfig.instance.hotbar.maxY;
            default -> HDDConfig.instance.hotbar.hideLevel.maxY;
        };
        class_746 player = this.field_2035.field_1724;
        boolean reveal = false;
        if (player != null) {
            class_1799 mainHandStack;
            class_1661 inventory;
            Triggers triggers = HDDConfig.instance.hotbar.trigger;
            if (triggers.slot && (reveal = (inventory = player.method_31548()) != null && selectedSlot != inventory.field_7545)) {
                selectedSlot = inventory.field_7545;
            }
            if (!reveal && triggers.item && (reveal = selectedItem != (mainHandStack = player.method_6047()))) {
                selectedItem = mainHandStack;
            }
            if (!reveal && triggers.key) {
                for (class_304 key : hotbarKeys) {
                    if (!key.method_1434()) continue;
                    reveal = true;
                    break;
                }
            }
        }
        if (reveal) {
            direction = -1;
        }
        if (y == (float)maxY) {
            ticksSinceTop = HDDConfig.instance.hotbar.lowerDelay;
        } else if (y == 0.0f && direction == -1) {
            ticksSinceTop = 0;
            direction = 0;
        } else {
            ticksSinceTop = direction >= 0 ? ++ticksSinceTop : --ticksSinceTop;
        }
        if (HDD.toggleHotbarKey.method_1434()) {
            if (++pressTicks == 1) {
                if (y == 0.0f) {
                    direction = 1;
                    ticksSinceTop = Math.max(HDDConfig.instance.hotbar.lowerDelay, HDDConfig.instance.hotbar.fadeDelay);
                } else {
                    direction = -1;
                    ticksSinceTop = HDDConfig.instance.hotbar.fadeEnd;
                }
            }
        } else {
            pressTicks = 0;
        }
        if (ticksSinceTop < HDDConfig.instance.hotbar.lowerDelay && y > 0.0f) {
            direction = -1;
        } else if (HDDConfig.instance.hotbar.hideAutomatically && ticksSinceTop >= HDDConfig.instance.hotbar.lowerDelay && y < (float)maxY && direction >= 0) {
            direction = 1;
        }
        previousY = y;
        y = (float)Math.pow(y + (float)direction * HDDConfig.instance.hotbar.speed, 1.0f + (float)direction * HDDConfig.instance.hotbar.acceleration);
        if (y >= (float)maxY) {
            y = maxY;
        } else if (y < 0.0f || y != y) {
            y = 0.0f;
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void computeFramePosition(class_4587 matrices, float tickDelta, CallbackInfo info) {
        frameY = previousY + (y - previousY) * tickDelta;
    }

    @ModifyArg(method={"renderHotbar"}, index=3, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V"))
    protected float fadeHotbar(float alpha) {
        if (HDDConfig.instance.hotbar.fade && direction >= 0) {
            return class_3532.method_15363((float)((float)(HDDConfig.instance.hotbar.fadeEnd - ticksSinceTop) / (float)HDDConfig.instance.hotbar.fadeDuration), (float)0.0f, (float)1.0f);
        }
        return alpha;
    }

    @Inject(method={"renderHotbar"}, at={@At(value="HEAD")})
    protected void lowerHotbar(float tickDelta, class_4587 matrices, CallbackInfo info) {
        InGameHudMixin.translate(matrices);
    }

    @Inject(method={"renderHotbar"}, at={@At(value="FIELD", target="Lnet/minecraft/client/option/GameOptions;attackIndicator:Lnet/minecraft/client/option/AttackIndicator;")})
    protected void cleanUpHotbar(float tickDelta, class_4587 matrices, CallbackInfo info) {
        InGameHudMixin.pop(matrices);
    }

    @Inject(method={"renderHotbarItem"}, at={@At(value="HEAD")})
    private void lowerItem(int x, int y, float tickDelta, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        if (HDDConfig.instance.hotbar.lower) {
            class_4587 matrixes = RenderSystem.getModelViewStack();
            matrixes.method_22903();
            matrixes.method_22904(0.0, (double)frameY, 0.0);
        }
    }

    @Inject(method={"renderHotbarItem"}, at={@At(value="RETURN")})
    private void cleanUpItem(int x, int y, float tickDelta, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        if (HDDConfig.instance.hotbar.lower) {
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="HEAD")})
    private void lowerStatusBars(class_4587 matrices, CallbackInfo ci) {
        InGameHudMixin.translate(matrices);
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="RETURN")})
    private void cleanUpStatusBars(class_4587 matrices, CallbackInfo ci) {
        InGameHudMixin.pop(matrices);
    }

    @Inject(method={"renderMountHealth"}, at={@At(value="HEAD")})
    private void lowerMountHealth(class_4587 matrices, CallbackInfo info) {
        InGameHudMixin.translate(matrices);
    }

    @Inject(method={"renderMountHealth"}, at={@At(value="RETURN")})
    private void cleanUpMountHealth(class_4587 matrices, CallbackInfo info) {
        InGameHudMixin.pop(matrices);
    }

    @Inject(method={"renderMountJumpBar"}, at={@At(value="HEAD")})
    public void lowerMountJumpBar(class_4587 matrices, int x, CallbackInfo info) {
        InGameHudMixin.translate(matrices);
    }

    @Inject(method={"renderMountJumpBar"}, at={@At(value="RETURN")})
    public void cleanUpJumpBar(class_4587 matrices, int x, CallbackInfo info) {
        InGameHudMixin.pop(matrices);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="HEAD")})
    public void lowerExperienceBar(class_4587 matrices, int x, CallbackInfo info) {
        InGameHudMixin.translate(matrices);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="RETURN")})
    public void cleanUpExperienceBar(class_4587 matrices, int x, CallbackInfo info) {
        InGameHudMixin.pop(matrices);
    }

    @Inject(method={"renderHeldItemTooltip"}, at={@At(value="HEAD")})
    private void lowerTooltip(class_4587 matrices, CallbackInfo info) {
        InGameHudMixin.translate(matrices);
    }

    @Inject(method={"renderHeldItemTooltip"}, at={@At(value="RETURN")})
    private void cleanUpTooltip(class_4587 matrices, CallbackInfo info) {
        InGameHudMixin.pop(matrices);
    }
}

