/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;

public class ExperienceFunctions {
    public static boolean canConsumeXp(PlayerEntity ep, int xp) {
        if (ep.func_184812_l_()) {
            return true;
        }
        return xp <= 0 || ExperienceFunctions.getPlayerXP(ep) >= xp;
    }

    public static void consumeXp(PlayerEntity ep, int xp) {
        if (xp <= 0) {
            return;
        }
        int playerXP = ExperienceFunctions.getPlayerXP(ep);
        if (playerXP >= xp) {
            ExperienceFunctions.addPlayerXP(ep, -xp);
        }
        if (ep instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)ep).field_71135_a.func_147359_a((IPacket)new SEntityStatusPacket((Entity)ep, 9));
        }
    }

    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)ExperienceFunctions.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = ExperienceFunctions.getPlayerXP(player) + amount;
        player.field_71068_ca = ExperienceFunctions.getLevelForExperience(experience);
        int expForLevel = ExperienceFunctions.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExperienceFunctions.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceFunctions.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceFunctions.sum(level - 15, 37, 5);
        }
        return 1395 + ExperienceFunctions.sum(level - 30, 112, 9);
    }
}

