/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lepidodendron.world.structure;

import java.util.Random;
import net.mcreator.lepidodendron.ElementsLepidodendronMod;
import net.mcreator.lepidodendron.LepidodendronConfig;
import net.mcreator.lepidodendron.LepidodendronTreeHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;

@ElementsLepidodendronMod.ModElement.Tag
public class StructureGlossBush3
extends ElementsLepidodendronMod.ModElement {
    public StructureGlossBush3(ElementsLepidodendronMod instance) {
        super(instance, 46);
    }

    @Override
    public void generateWorld(Random random, int i2, int k2, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        boolean dimensionCriteria = false;
        boolean isNetherType = false;
        if (this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimGlossopteris)) {
            dimensionCriteria = true;
        }
        if (!LepidodendronConfig.genGlossopterisBush && !LepidodendronConfig.genAllPlants) {
            dimensionCriteria = false;
        }
        if (!dimensionCriteria) {
            return;
        }
        boolean biomeCriteria = false;
        Biome biome = world.func_180494_b(new BlockPos(i2, LepidodendronConfig.levelSea, k2));
        if (!StructureGlossBush3.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureGlossBush3.matchBiome(biome, LepidodendronConfig.genGlossopterisBlacklistBiomes)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                biomeCriteria = false;
            }
        }
        if (StructureGlossBush3.matchBiome(biome, LepidodendronConfig.genGlossopterisOverrideBiomes)) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        int GenChance = 17000;
        double GenMultiplier = LepidodendronConfig.multiplierGlossopteris;
        if (GenMultiplier < 0.0) {
            GenMultiplier = 0.0;
        }
        GenChance = Math.min(300000, (int)Math.round((double)GenChance * GenMultiplier));
        if (LepidodendronTreeHandler.matchBiome(biome, LepidodendronConfig.genTransformBiomes)) {
            GenChance = Math.min(GenChance * 10, 300000);
        }
        if (random.nextInt(1000000) + 1 <= GenChance) {
            int count = random.nextInt(1) + 1;
            for (int a = 0; a < count; ++a) {
                int height;
                int i = i2 + random.nextInt(16) + 8;
                int k = k2 + random.nextInt(16) + 8;
                if (isNetherType) {
                    boolean notpassed = true;
                    for (height = 255; height > 0; --height) {
                        if (notpassed && world.func_175623_d(new BlockPos(i, height, k))) {
                            notpassed = false;
                            continue;
                        }
                        if (notpassed || world.func_175623_d(new BlockPos(i, height, k))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (height > 0 && (world.func_175623_d(new BlockPos(i, height, k)) || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151582_l || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151569_G || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151585_k)) {
                        --height;
                    }
                }
                int j = height;
                boolean blockCriteria = false;
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151577_b) {
                    blockCriteria = true;
                }
                if (!blockCriteria) continue;
                int maxheight = LepidodendronConfig.maxheightGlossopteris;
                int minheight = LepidodendronConfig.minheightGlossopteris;
                if (maxheight < 0) {
                    maxheight = 0;
                }
                if (maxheight > 250) {
                    maxheight = 250;
                }
                if (minheight < 1) {
                    minheight = 1;
                }
                if (minheight > 250) {
                    minheight = 250;
                }
                if (j < minheight || j > maxheight && maxheight != 0) continue;
                biomeCriteria = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureGlossBush3.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureGlossBush3.matchBiome(biome, LepidodendronConfig.genGlossopterisBlacklistBiomes)) {
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        biomeCriteria = false;
                    }
                }
                if (StructureGlossBush3.matchBiome(biome, LepidodendronConfig.genGlossopterisOverrideBiomes)) {
                    biomeCriteria = true;
                }
                if (!biomeCriteria) continue;
                if (world.field_72995_K) {
                    return;
                }
                Template template = ((WorldServer)world).func_184163_y().func_186237_a(world.func_73046_m(), new ResourceLocation("lepidodendron", "glossbush3"));
                if (template == null) {
                    return;
                }
                Rotation rotation = Rotation.values()[random.nextInt(3)];
                Mirror mirror = Mirror.values()[random.nextInt(2)];
                BlockPos spawnTo = new BlockPos(i, j + 1, k);
                IBlockState iblockstate = world.func_180495_p(spawnTo);
                world.func_184138_a(spawnTo, iblockstate, iblockstate, 3);
                template.func_186260_a(world, spawnTo, new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false).func_186222_a(false));
            }
        }
    }

    public boolean shouldGenerateInDimension(int id, int[] dims) {
        int[] var2 = dims;
        int var3 = dims.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int dim = var2[var4];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBiome(Biome biome, String[] biomesList) {
        String[] var2 = biomesList;
        int var3 = biomesList.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String checkBiome = var2[var4];
            if (!checkBiome.contains(":") && checkBiome.equalsIgnoreCase(biome.getRegistryName().toString().substring(0, biome.getRegistryName().toString().indexOf(":")))) {
                return true;
            }
            if (!checkBiome.equalsIgnoreCase(biome.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }
}

