/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lepidodendron.world.structure;

import java.util.HashMap;
import java.util.Random;
import net.mcreator.lepidodendron.ElementsLepidodendronMod;
import net.mcreator.lepidodendron.LepidodendronConfig;
import net.mcreator.lepidodendron.LepidodendronTreeHandler;
import net.mcreator.lepidodendron.block.BlockBaragwanathia;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

@ElementsLepidodendronMod.ModElement.Tag
public class StructureSpawnBaragwanathia
extends ElementsLepidodendronMod.ModElement {
    public StructureSpawnBaragwanathia(ElementsLepidodendronMod instance) {
        super(instance, 49);
    }

    @Override
    public void generateWorld(Random random, int i2, int k2, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        boolean dimensionCriteria = false;
        boolean isNetherType = false;
        if (this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimBaragwanathia)) {
            dimensionCriteria = true;
        }
        if (!LepidodendronConfig.genBaragwanathia && !LepidodendronConfig.genAllPlants) {
            dimensionCriteria = false;
        }
        if (!dimensionCriteria) {
            return;
        }
        boolean biomeCriteria = false;
        Biome biome = world.func_180494_b(new BlockPos(i2, LepidodendronConfig.levelSea, k2));
        if (!StructureSpawnBaragwanathia.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnBaragwanathia.matchBiome(biome, LepidodendronConfig.genBaragwanathiaBlacklistBiomes)) {
            biomeCriteria = false;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                biomeCriteria = false;
            }
        }
        if (StructureSpawnBaragwanathia.matchBiome(biome, LepidodendronConfig.genBaragwanathiaOverrideBiomes)) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        int GenChance = 50000;
        double GenMultiplier = LepidodendronConfig.multiplierBaragwanathia;
        if (GenMultiplier < 0.0) {
            GenMultiplier = 0.0;
        }
        GenChance = Math.min(300000, (int)Math.round((double)GenChance * GenMultiplier));
        if (LepidodendronTreeHandler.matchBiome(biome, LepidodendronConfig.genTransformBiomes)) {
            GenChance = Math.min(GenChance * 10, 300000);
        }
        if (random.nextInt(1000000) + 1 <= GenChance) {
            int count = random.nextInt(1) + 20;
            for (int a = 0; a < count; ++a) {
                int height;
                int i = i2 + random.nextInt(16) + 8;
                int k = k2 + random.nextInt(16) + 8;
                if (isNetherType) {
                    boolean notpassed = true;
                    for (height = 255; height > 0; --height) {
                        if (notpassed && world.func_175623_d(new BlockPos(i, height, k))) {
                            notpassed = false;
                            continue;
                        }
                        if (notpassed || world.func_175623_d(new BlockPos(i, height, k))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (height > 0 && (world.func_175623_d(new BlockPos(i, height, k)) || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151582_l || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151569_G || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151585_k)) {
                        --height;
                    }
                }
                int j = height;
                boolean blockCriteria = false;
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151586_h && (world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151571_B || world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151576_e || world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151578_c)) {
                    blockCriteria = true;
                }
                if (!blockCriteria) continue;
                int maxheight = LepidodendronConfig.maxheightBaragwanathia;
                int minheight = LepidodendronConfig.minheightBaragwanathia;
                if (maxheight < 0) {
                    maxheight = 0;
                }
                if (maxheight > 250) {
                    maxheight = 250;
                }
                if (minheight < 1) {
                    minheight = 1;
                }
                if (minheight > 250) {
                    minheight = 250;
                }
                if (j < minheight || j > maxheight && maxheight != 0 || !this.canSurviveAt(world, new BlockPos(i, j + 1, k))) continue;
                biomeCriteria = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureSpawnBaragwanathia.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnBaragwanathia.matchBiome(biome, LepidodendronConfig.genBaragwanathiaBlacklistBiomes)) {
                    biomeCriteria = false;
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        biomeCriteria = false;
                    }
                }
                if (StructureSpawnBaragwanathia.matchBiome(biome, LepidodendronConfig.genBaragwanathiaOverrideBiomes)) {
                    biomeCriteria = true;
                }
                if (!biomeCriteria) continue;
                if (world.field_72995_K) {
                    return;
                }
                BlockPos spawnTo = new BlockPos(i, j + 1, k);
                int x = spawnTo.func_177958_n();
                int y = spawnTo.func_177956_o();
                int z = spawnTo.func_177952_p();
                HashMap<String, Integer> $_dependencies = new HashMap<String, Integer>();
                $_dependencies.put("x", i);
                $_dependencies.put("y", j + 1);
                $_dependencies.put("z", k);
                $_dependencies.put("world", (Integer)world);
                if (world.func_175678_i(spawnTo) || world.func_180495_p(spawnTo).func_185904_a() == Material.field_151597_y && world.func_175678_i(spawnTo.func_177984_a())) {
                    world.func_175698_g(spawnTo);
                    world.func_175698_g(spawnTo.func_177984_a());
                }
                world.func_180501_a(spawnTo, BlockBaragwanathia.block.func_176223_P(), 3);
            }
        }
    }

    public boolean shouldGenerateInDimension(int id, int[] dims) {
        int[] var2 = dims;
        int var3 = dims.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int dim = var2[var4];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBiome(Biome biome, String[] biomesList) {
        String[] var2 = biomesList;
        int var3 = biomesList.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String checkBiome = var2[var4];
            if (!checkBiome.contains(":") && checkBiome.equalsIgnoreCase(biome.getRegistryName().toString().substring(0, biome.getRegistryName().toString().indexOf(":")))) {
                return true;
            }
            if (!checkBiome.equalsIgnoreCase(biome.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean canSurviveAt(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        if (worldIn.func_180495_p(pos.func_177979_c(2)).func_185904_a() != Material.field_151578_c && worldIn.func_180495_p(pos.func_177979_c(2)).func_185904_a() != Material.field_151571_B && worldIn.func_180495_p(pos.func_177979_c(2)).func_185904_a() != Material.field_151576_e && worldIn.func_180495_p(pos.func_177979_c(2)).func_185904_a() != Material.field_151595_p) {
            return false;
        }
        return worldIn.func_175678_i(pos) || worldIn.func_180495_p(pos).func_185906_d() >= 7;
    }
}

