/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lepidodendron.world.structure;

import java.util.HashMap;
import java.util.Random;
import net.mcreator.lepidodendron.ElementsLepidodendronMod;
import net.mcreator.lepidodendron.LepidodendronConfig;
import net.mcreator.lepidodendron.LepidodendronTreeHandler;
import net.mcreator.lepidodendron.procedure.ProcedureWorldGenBothrodendron;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;

@ElementsLepidodendronMod.ModElement.Tag
public class StructureSpawnBothrodendon
extends ElementsLepidodendronMod.ModElement {
    public StructureSpawnBothrodendon(ElementsLepidodendronMod instance) {
        super(instance, 48);
    }

    @Override
    public void generateWorld(Random random, int i2, int k2, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        boolean dimensionCriteria = false;
        boolean isNetherType = false;
        if (this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimBothrodendron)) {
            dimensionCriteria = true;
        }
        if (!LepidodendronConfig.genBothrodendron && !LepidodendronConfig.genAllPlants) {
            dimensionCriteria = false;
        }
        if (!dimensionCriteria) {
            return;
        }
        boolean biomeCriteria = false;
        Biome biome = world.func_180494_b(new BlockPos(i2, LepidodendronConfig.levelSea, k2));
        if (!StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genBothrodendronBlacklistBiomes)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                biomeCriteria = false;
            }
        }
        if (StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genBothrodendronOverrideBiomes)) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        int GenChance = 40000;
        double GenMultiplier = LepidodendronConfig.multiplierBothrodendron;
        if (GenMultiplier < 0.0) {
            GenMultiplier = 0.0;
        }
        GenChance = Math.min(300000, (int)Math.round((double)GenChance * GenMultiplier));
        if (LepidodendronTreeHandler.matchBiome(biome, LepidodendronConfig.genTransformBiomes)) {
            GenChance = Math.min(GenChance * 10, 300000);
        }
        if (random.nextInt(1000000) + 1 <= GenChance) {
            int count = random.nextInt(1) + 1;
            for (int a = 0; a < count; ++a) {
                int height;
                int i = i2 + random.nextInt(16) + 8;
                int k = k2 + random.nextInt(16) + 8;
                if (isNetherType) {
                    boolean notpassed = true;
                    for (height = 255; height > 0; --height) {
                        if (notpassed && world.func_175623_d(new BlockPos(i, height, k))) {
                            notpassed = false;
                            continue;
                        }
                        if (notpassed || world.func_175623_d(new BlockPos(i, height, k))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (height > 0 && (world.func_175623_d(new BlockPos(i, height, k)) || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151582_l || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151569_G || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151585_k)) {
                        --height;
                    }
                }
                int j = height;
                boolean blockCriteria = false;
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151597_y) {
                    --j;
                }
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151577_b) {
                    blockCriteria = true;
                }
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151578_c) {
                    blockCriteria = true;
                }
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151586_h && (world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151578_c)) {
                    blockCriteria = true;
                    --j;
                }
                if (!blockCriteria) continue;
                int maxheight = LepidodendronConfig.maxheightBothrodendron;
                int minheight = LepidodendronConfig.minheightBothrodendron;
                if (maxheight < 0) {
                    maxheight = 0;
                }
                if (maxheight > 250) {
                    maxheight = 250;
                }
                if (minheight < 1) {
                    minheight = 1;
                }
                if (minheight > 250) {
                    minheight = 250;
                }
                if (j < minheight || j > maxheight && maxheight != 0) continue;
                biomeCriteria = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genBothrodendronBlacklistBiomes)) {
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        biomeCriteria = false;
                    }
                }
                if (StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genBothrodendronOverrideBiomes)) {
                    biomeCriteria = true;
                }
                if (!biomeCriteria) continue;
                boolean vines = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genSphenophyllalesBlacklistBiomes)) {
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                        vines = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                        vines = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        vines = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        vines = false;
                    }
                }
                if (StructureSpawnBothrodendon.matchBiome(biome, LepidodendronConfig.genSphenophyllalesOverrideBiomes)) {
                    vines = true;
                }
                if (!this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimSphenophyllales)) {
                    vines = false;
                }
                if (!LepidodendronConfig.genSphenophyllalesBothrodendron && !LepidodendronConfig.genAllPlants) {
                    vines = false;
                }
                if (world.field_72995_K) {
                    return;
                }
                Template template = ((WorldServer)world).func_184163_y().func_186237_a(world.func_73046_m(), new ResourceLocation("lepidodendron", "spawnvoid"));
                if (template == null) {
                    return;
                }
                if (world.func_175623_d(new BlockPos(i - 1, j, k)) || world.func_175623_d(new BlockPos(i + 1, j, k)) || world.func_175623_d(new BlockPos(i, j, k + 1)) || world.func_175623_d(new BlockPos(i, j, k - 1))) {
                    world.func_175698_g(new BlockPos(i, j, k));
                    --j;
                }
                BlockPos spawnTo = new BlockPos(i, j + 1, k);
                int x = spawnTo.func_177958_n();
                int y = spawnTo.func_177956_o();
                int z = spawnTo.func_177952_p();
                HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
                $_dependencies.put("x", i);
                $_dependencies.put("y", j + 1);
                $_dependencies.put("z", k);
                $_dependencies.put("world", world);
                $_dependencies.put("vines", vines);
                if (world.func_175678_i(spawnTo) || world.func_180495_p(spawnTo).func_185904_a() == Material.field_151597_y && world.func_175678_i(spawnTo.func_177984_a())) {
                    world.func_175698_g(spawnTo);
                    world.func_175698_g(spawnTo.func_177984_a());
                }
                ProcedureWorldGenBothrodendron.executeProcedure($_dependencies);
            }
        }
    }

    public boolean shouldGenerateInDimension(int id, int[] dims) {
        int[] var2 = dims;
        int var3 = dims.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int dim = var2[var4];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBiome(Biome biome, String[] biomesList) {
        String[] var2 = biomesList;
        int var3 = biomesList.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String checkBiome = var2[var4];
            if (!checkBiome.contains(":") && checkBiome.equalsIgnoreCase(biome.getRegistryName().toString().substring(0, biome.getRegistryName().toString().indexOf(":")))) {
                return true;
            }
            if (!checkBiome.equalsIgnoreCase(biome.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }
}

