/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lepidodendron.world.structure;

import java.util.HashMap;
import java.util.Random;
import net.mcreator.lepidodendron.ElementsLepidodendronMod;
import net.mcreator.lepidodendron.LepidodendronConfig;
import net.mcreator.lepidodendron.LepidodendronTreeHandler;
import net.mcreator.lepidodendron.procedure.ProcedureWorldGenCalamites;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

@ElementsLepidodendronMod.ModElement.Tag
public class StructureSpawnCalamites
extends ElementsLepidodendronMod.ModElement {
    public StructureSpawnCalamites(ElementsLepidodendronMod instance) {
        super(instance, 49);
    }

    @Override
    public void generateWorld(Random random, int i2, int k2, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        boolean dimensionCriteria = false;
        boolean isNetherType = false;
        if (this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimCalamites)) {
            dimensionCriteria = true;
        }
        if (!LepidodendronConfig.genCalamites && !LepidodendronConfig.genAllPlants) {
            dimensionCriteria = false;
        }
        if (!dimensionCriteria) {
            return;
        }
        boolean biomeCriteria = false;
        Biome biome = world.func_180494_b(new BlockPos(i2, LepidodendronConfig.levelSea, k2));
        if (!StructureSpawnCalamites.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnCalamites.matchBiome(biome, LepidodendronConfig.genCalamitesBlacklistBiomes)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                biomeCriteria = false;
            }
        }
        if (StructureSpawnCalamites.matchBiome(biome, LepidodendronConfig.genCalamitesOverrideBiomes)) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        int GenChance = 35000;
        double GenMultiplier = LepidodendronConfig.multiplierCalamites;
        if (GenMultiplier < 0.0) {
            GenMultiplier = 0.0;
        }
        GenChance = Math.min(300000, (int)Math.round((double)GenChance * GenMultiplier));
        if (LepidodendronTreeHandler.matchBiome(biome, LepidodendronConfig.genTransformBiomes)) {
            GenChance = Math.min(GenChance * 10, 300000);
        }
        if (random.nextInt(1000000) + 1 <= GenChance) {
            int count = random.nextInt(1) + 1;
            for (int a = 0; a < count; ++a) {
                int waterDist;
                int height;
                int i = i2 + random.nextInt(16) + 8;
                int k = k2 + random.nextInt(16) + 8;
                if (isNetherType) {
                    boolean notpassed = true;
                    for (height = 255; height > 0; --height) {
                        if (notpassed && world.func_175623_d(new BlockPos(i, height, k))) {
                            notpassed = false;
                            continue;
                        }
                        if (notpassed || world.func_175623_d(new BlockPos(i, height, k))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (height > 0 && (world.func_175623_d(new BlockPos(i, height, k)) || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151582_l || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151569_G || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151585_k)) {
                        --height;
                    }
                }
                int j = height;
                boolean blockCriteria = false;
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151597_y) {
                    --j;
                }
                if ((waterDist = LepidodendronConfig.spreadWaterCalamites) < 0) {
                    waterDist = 0;
                }
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151577_b || world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151578_c) {
                    boolean waterCriteria = false;
                    for (int xct = -waterDist; xct <= waterDist && !waterCriteria; ++xct) {
                        for (int yct = -3; yct <= 0 && !waterCriteria; ++yct) {
                            for (int zct = -waterDist; zct <= waterDist && !waterCriteria; ++zct) {
                                if (world.func_180495_p(new BlockPos(i + xct, j + yct, k + zct)).func_185904_a() != Material.field_151586_h) continue;
                                waterCriteria = true;
                            }
                        }
                    }
                    if (waterCriteria) {
                        blockCriteria = true;
                    }
                }
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151586_h && (world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() == Material.field_151578_c)) {
                    blockCriteria = true;
                    --j;
                }
                if (!blockCriteria) continue;
                int maxheight = LepidodendronConfig.maxheightCalamites;
                int minheight = LepidodendronConfig.minheightCalamites;
                if (maxheight < 0) {
                    maxheight = 0;
                }
                if (maxheight > 250) {
                    maxheight = 250;
                }
                if (minheight < 1) {
                    minheight = 1;
                }
                if (minheight > 250) {
                    minheight = 250;
                }
                if (j < minheight || j > maxheight && maxheight != 0) continue;
                biomeCriteria = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureSpawnCalamites.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnCalamites.matchBiome(biome, LepidodendronConfig.genCalamitesBlacklistBiomes)) {
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        biomeCriteria = false;
                    }
                }
                if (StructureSpawnCalamites.matchBiome(biome, LepidodendronConfig.genCalamitesOverrideBiomes)) {
                    biomeCriteria = true;
                }
                if (!biomeCriteria) continue;
                if (world.field_72995_K) {
                    return;
                }
                BlockPos spawnTo = new BlockPos(i, j + 1, k);
                int x = spawnTo.func_177958_n();
                int y = spawnTo.func_177956_o();
                int z = spawnTo.func_177952_p();
                boolean worldgen = true;
                HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
                $_dependencies.put("x", i);
                $_dependencies.put("y", j + 1);
                $_dependencies.put("z", k);
                $_dependencies.put("world", world);
                $_dependencies.put("worldgen", worldgen);
                $_dependencies.put("parentx", i);
                $_dependencies.put("parenty", j + 1);
                $_dependencies.put("parentz", k);
                if (world.func_175678_i(spawnTo) || world.func_180495_p(spawnTo).func_185904_a() == Material.field_151597_y && world.func_175678_i(spawnTo.func_177984_a())) {
                    world.func_175698_g(spawnTo);
                    world.func_175698_g(spawnTo.func_177984_a());
                }
                ProcedureWorldGenCalamites.executeProcedure($_dependencies);
            }
        }
    }

    public boolean shouldGenerateInDimension(int id, int[] dims) {
        int[] var2 = dims;
        int var3 = dims.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int dim = var2[var4];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBiome(Biome biome, String[] biomesList) {
        String[] var2 = biomesList;
        int var3 = biomesList.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String checkBiome = var2[var4];
            if (!checkBiome.contains(":") && checkBiome.equalsIgnoreCase(biome.getRegistryName().toString().substring(0, biome.getRegistryName().toString().indexOf(":")))) {
                return true;
            }
            if (!checkBiome.equalsIgnoreCase(biome.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }
}

