/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lepidodendron.world.structure;

import java.util.Random;
import net.mcreator.lepidodendron.ElementsLepidodendronMod;
import net.mcreator.lepidodendron.LepidodendronConfig;
import net.mcreator.lepidodendron.LepidodendronTreeHandler;
import net.mcreator.lepidodendron.block.BlockLepidopteris;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

@ElementsLepidodendronMod.ModElement.Tag
public class StructureSpawnLepidopteris
extends ElementsLepidodendronMod.ModElement {
    public StructureSpawnLepidopteris(ElementsLepidodendronMod instance) {
        super(instance, 48);
    }

    @Override
    public void generateWorld(Random random, int i2, int k2, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        boolean dimensionCriteria = false;
        boolean isNetherType = false;
        if (this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimLepidopteris)) {
            dimensionCriteria = true;
        }
        if (!LepidodendronConfig.genLepidopteris && !LepidodendronConfig.genAllPlants) {
            dimensionCriteria = false;
        }
        if (!dimensionCriteria) {
            return;
        }
        boolean biomeCriteria = false;
        Biome biome = world.func_180494_b(new BlockPos(i2, LepidodendronConfig.levelSea, k2));
        if (!StructureSpawnLepidopteris.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnLepidopteris.matchBiome(biome, LepidodendronConfig.genLepidopterisBlacklistBiomes)) {
            biomeCriteria = true;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                biomeCriteria = false;
            }
        }
        if (StructureSpawnLepidopteris.matchBiome(biome, LepidodendronConfig.genLepidopterisOverrideBiomes)) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        int GenChance = 35000;
        double GenMultiplier = LepidodendronConfig.multiplierLepidopteris;
        if (GenMultiplier < 0.0) {
            GenMultiplier = 0.0;
        }
        GenChance = Math.min(300000, (int)Math.round((double)GenChance * GenMultiplier));
        if (LepidodendronTreeHandler.matchBiome(biome, LepidodendronConfig.genTransformBiomes)) {
            GenChance = Math.min(GenChance * 3, 300000);
        }
        if (random.nextInt(1000000) + 1 <= GenChance) {
            int count = random.nextInt(1) + 12;
            for (int a = 0; a < count; ++a) {
                int height;
                int i = i2 + random.nextInt(16) + 8;
                int k = k2 + random.nextInt(16) + 8;
                if (isNetherType) {
                    boolean notpassed = true;
                    for (height = 255; height > 0; --height) {
                        if (notpassed && world.func_175623_d(new BlockPos(i, height, k))) {
                            notpassed = false;
                            continue;
                        }
                        if (notpassed || world.func_175623_d(new BlockPos(i, height, k))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (height > 0 && (world.func_175623_d(new BlockPos(i, height, k)) || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151582_l || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151569_G || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151585_k)) {
                        --height;
                    }
                }
                int j = height;
                boolean blockCriteria = false;
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151597_y) {
                    --j;
                }
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151577_b) {
                    blockCriteria = true;
                }
                if (world.func_180495_p(new BlockPos(i, j, k)).func_185904_a() == Material.field_151578_c) {
                    blockCriteria = true;
                }
                if (!blockCriteria) continue;
                int maxheight = LepidodendronConfig.maxheightLepidopteris;
                int minheight = LepidodendronConfig.minheightLepidopteris;
                if (maxheight < 0) {
                    maxheight = 0;
                }
                if (maxheight > 250) {
                    maxheight = 250;
                }
                if (minheight < 1) {
                    minheight = 1;
                }
                if (minheight > 250) {
                    minheight = 250;
                }
                if (j < minheight || j > maxheight && maxheight != 0) continue;
                biomeCriteria = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureSpawnLepidopteris.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnLepidopteris.matchBiome(biome, LepidodendronConfig.genLepidopterisBlacklistBiomes)) {
                    biomeCriteria = true;
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        biomeCriteria = false;
                    }
                }
                if (StructureSpawnLepidopteris.matchBiome(biome, LepidodendronConfig.genLepidopterisOverrideBiomes)) {
                    biomeCriteria = true;
                }
                if (!biomeCriteria) continue;
                if (world.field_72995_K) {
                    return;
                }
                BlockPos spawnTo = new BlockPos(i, j + 1, k);
                if (!world.func_175667_e(spawnTo) || !world.func_175697_a(spawnTo, 3)) continue;
                if (world.func_175678_i(spawnTo) || world.func_180495_p(spawnTo).func_185904_a() == Material.field_151597_y && world.func_175678_i(spawnTo.func_177984_a())) {
                    world.func_175698_g(spawnTo);
                    world.func_175698_g(spawnTo.func_177984_a());
                }
                world.func_180501_a(spawnTo, BlockLepidopteris.block.func_176223_P(), 3);
            }
        }
    }

    public boolean shouldGenerateInDimension(int id, int[] dims) {
        int[] var2 = dims;
        int var3 = dims.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int dim = var2[var4];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBiome(Biome biome, String[] biomesList) {
        String[] var2 = biomesList;
        int var3 = biomesList.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String checkBiome = var2[var4];
            if (!checkBiome.contains(":") && checkBiome.equalsIgnoreCase(biome.getRegistryName().toString().substring(0, biome.getRegistryName().toString().indexOf(":")))) {
                return true;
            }
            if (!checkBiome.equalsIgnoreCase(biome.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }
}

