/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lepidodendron.world.structure;

import java.util.HashMap;
import java.util.Random;
import net.mcreator.lepidodendron.ElementsLepidodendronMod;
import net.mcreator.lepidodendron.LepidodendronConfig;
import net.mcreator.lepidodendron.LepidodendronTreeHandler;
import net.mcreator.lepidodendron.block.BlockNelumbo;
import net.mcreator.lepidodendron.block.BlockNelumboLeaves;
import net.mcreator.lepidodendron.block.BlockNelumboStem;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

@ElementsLepidodendronMod.ModElement.Tag
public class StructureSpawnNelumbo
extends ElementsLepidodendronMod.ModElement {
    public StructureSpawnNelumbo(ElementsLepidodendronMod instance) {
        super(instance, 49);
    }

    @Override
    public void generateWorld(Random random, int i2, int k2, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        boolean dimensionCriteria = false;
        boolean isNetherType = false;
        if (this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimNelumbo)) {
            dimensionCriteria = true;
        }
        if (!LepidodendronConfig.genNelumbo && !LepidodendronConfig.genAllPlants) {
            dimensionCriteria = false;
        }
        if (!dimensionCriteria) {
            return;
        }
        boolean biomeCriteria = false;
        Biome biome = world.func_180494_b(new BlockPos(i2, LepidodendronConfig.levelSea, k2));
        if (!StructureSpawnNelumbo.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnNelumbo.matchBiome(biome, LepidodendronConfig.genNelumboBlacklistBiomes)) {
            biomeCriteria = true;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                biomeCriteria = false;
            }
        }
        if (StructureSpawnNelumbo.matchBiome(biome, LepidodendronConfig.genNelumboOverrideBiomes)) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        int GenChance = 22000;
        double GenMultiplier = LepidodendronConfig.multiplierNelumbo;
        if (GenMultiplier < 0.0) {
            GenMultiplier = 0.0;
        }
        GenChance = Math.min(300000, (int)Math.round((double)GenChance * GenMultiplier));
        if (LepidodendronTreeHandler.matchBiome(biome, LepidodendronConfig.genTransformBiomes)) {
            GenChance = Math.min(GenChance * 10, 300000);
        }
        if (random.nextInt(1000000) + 1 <= GenChance) {
            int count = random.nextInt(1) + 5;
            for (int a = 0; a < count; ++a) {
                int colWater;
                int height;
                int i = i2 + random.nextInt(16) + 8;
                int k = k2 + random.nextInt(16) + 8;
                if (isNetherType) {
                    boolean notpassed = true;
                    for (height = 255; height > 0; --height) {
                        if (notpassed && world.func_175623_d(new BlockPos(i, height, k))) {
                            notpassed = false;
                            continue;
                        }
                        if (notpassed || world.func_175623_d(new BlockPos(i, height, k))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (height > 0 && (world.func_175623_d(new BlockPos(i, height, k)) || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151582_l || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151569_G || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151585_k)) {
                        --height;
                    }
                }
                int j = height;
                boolean blockCriteria = false;
                if (this.isWaterBlock(world, new BlockPos(i, j, k)) && this.isWaterBlock(world, new BlockPos(i, j - 1, k)) && (world.func_180495_p(new BlockPos(i, j - 2, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 2, k)).func_185904_a() == Material.field_151571_B || world.func_180495_p(new BlockPos(i, j - 2, k)).func_185904_a() == Material.field_151578_c)) {
                    j -= 2;
                    blockCriteria = true;
                }
                if (this.isWaterBlock(world, new BlockPos(i, j, k)) && this.isWaterBlock(world, new BlockPos(i, j - 1, k)) && this.isWaterBlock(world, new BlockPos(i, j - 2, k)) && (world.func_180495_p(new BlockPos(i, j - 3, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 3, k)).func_185904_a() == Material.field_151571_B || world.func_180495_p(new BlockPos(i, j - 3, k)).func_185904_a() == Material.field_151578_c)) {
                    j -= 3;
                    blockCriteria = true;
                }
                if (this.isWaterBlock(world, new BlockPos(i, j, k)) && this.isWaterBlock(world, new BlockPos(i, j - 1, k)) && this.isWaterBlock(world, new BlockPos(i, j - 2, k)) && this.isWaterBlock(world, new BlockPos(i, j - 3, k)) && (world.func_180495_p(new BlockPos(i, j - 4, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 4, k)).func_185904_a() == Material.field_151571_B || world.func_180495_p(new BlockPos(i, j - 4, k)).func_185904_a() == Material.field_151578_c)) {
                    j -= 4;
                    blockCriteria = true;
                }
                if (this.isWaterBlock(world, new BlockPos(i, j, k)) && this.isWaterBlock(world, new BlockPos(i, j - 1, k)) && this.isWaterBlock(world, new BlockPos(i, j - 2, k)) && this.isWaterBlock(world, new BlockPos(i, j - 3, k)) && this.isWaterBlock(world, new BlockPos(i, j - 4, k)) && (world.func_180495_p(new BlockPos(i, j - 5, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 5, k)).func_185904_a() == Material.field_151571_B || world.func_180495_p(new BlockPos(i, j - 5, k)).func_185904_a() == Material.field_151578_c)) {
                    j -= 5;
                    blockCriteria = true;
                }
                if (this.isWaterBlock(world, new BlockPos(i, j, k)) && this.isWaterBlock(world, new BlockPos(i, j - 1, k)) && this.isWaterBlock(world, new BlockPos(i, j - 2, k)) && this.isWaterBlock(world, new BlockPos(i, j - 3, k)) && this.isWaterBlock(world, new BlockPos(i, j - 4, k)) && this.isWaterBlock(world, new BlockPos(i, j - 5, k)) && (world.func_180495_p(new BlockPos(i, j - 6, k)).func_185904_a() == Material.field_151595_p || world.func_180495_p(new BlockPos(i, j - 6, k)).func_185904_a() == Material.field_151571_B || world.func_180495_p(new BlockPos(i, j - 6, k)).func_185904_a() == Material.field_151578_c)) {
                    j -= 6;
                    blockCriteria = true;
                }
                if (!blockCriteria) continue;
                int maxheight = LepidodendronConfig.maxheightNelumbo;
                int minheight = LepidodendronConfig.minheightNelumbo;
                if (maxheight < 0) {
                    maxheight = 0;
                }
                if (maxheight > 250) {
                    maxheight = 250;
                }
                if (minheight < 1) {
                    minheight = 1;
                }
                if (minheight > 250) {
                    minheight = 250;
                }
                if (j < minheight || j > maxheight && maxheight != 0) continue;
                biomeCriteria = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureSpawnNelumbo.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnNelumbo.matchBiome(biome, LepidodendronConfig.genNelumboBlacklistBiomes)) {
                    biomeCriteria = true;
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        biomeCriteria = false;
                    }
                }
                if (StructureSpawnNelumbo.matchBiome(biome, LepidodendronConfig.genNelumboOverrideBiomes)) {
                    biomeCriteria = true;
                }
                if (!biomeCriteria) continue;
                if (world.field_72995_K) {
                    return;
                }
                BlockPos spawnTo = new BlockPos(i, j + 1, k);
                int x = spawnTo.func_177958_n();
                int y = spawnTo.func_177956_o();
                int z = spawnTo.func_177952_p();
                HashMap<String, Integer> $_dependencies = new HashMap<String, Integer>();
                $_dependencies.put("x", i);
                $_dependencies.put("y", j + 1);
                $_dependencies.put("z", k);
                $_dependencies.put("world", (Integer)world);
                world.func_180501_a(spawnTo, BlockNelumbo.block.func_176223_P(), 3);
                if (this.isWaterBlock(world, spawnTo.func_177978_c())) {
                    for (colWater = 1; colWater < 6 && this.isWaterBlock(world, spawnTo.func_177978_c().func_177981_b(colWater)); ++colWater) {
                        if (!this.isWaterBlock(world, spawnTo.func_177978_c().func_177981_b(colWater + 1))) continue;
                        world.func_180501_a(spawnTo.func_177978_c().func_177981_b(colWater), BlockNelumboStem.block.func_176223_P(), 3);
                    }
                    if (this.canLeavesPlaceAt(world, spawnTo.func_177978_c().func_177981_b(colWater))) {
                        world.func_180501_a(spawnTo.func_177978_c().func_177981_b(colWater), BlockNelumboLeaves.block.func_176223_P(), 3);
                    }
                }
                if (this.isWaterBlock(world, spawnTo.func_177968_d())) {
                    for (colWater = 1; colWater < 6 && this.isWaterBlock(world, spawnTo.func_177968_d().func_177981_b(colWater)); ++colWater) {
                        if (!this.isWaterBlock(world, spawnTo.func_177968_d().func_177981_b(colWater + 1))) continue;
                        world.func_180501_a(spawnTo.func_177968_d().func_177981_b(colWater), BlockNelumboStem.block.func_176223_P(), 3);
                    }
                    if (this.canLeavesPlaceAt(world, spawnTo.func_177968_d().func_177981_b(colWater))) {
                        world.func_180501_a(spawnTo.func_177968_d().func_177981_b(colWater), BlockNelumboLeaves.block.func_176223_P(), 3);
                    }
                }
                if (this.isWaterBlock(world, spawnTo.func_177974_f())) {
                    for (colWater = 1; colWater < 6 && this.isWaterBlock(world, spawnTo.func_177974_f().func_177981_b(colWater)); ++colWater) {
                        if (!this.isWaterBlock(world, spawnTo.func_177974_f().func_177981_b(colWater + 1))) continue;
                        world.func_180501_a(spawnTo.func_177974_f().func_177981_b(colWater), BlockNelumboStem.block.func_176223_P(), 3);
                    }
                    if (this.canLeavesPlaceAt(world, spawnTo.func_177974_f().func_177981_b(colWater))) {
                        world.func_180501_a(spawnTo.func_177974_f().func_177981_b(colWater), BlockNelumboLeaves.block.func_176223_P(), 3);
                    }
                }
                if (!this.isWaterBlock(world, spawnTo.func_177976_e())) continue;
                for (colWater = 1; colWater < 6 && this.isWaterBlock(world, spawnTo.func_177976_e().func_177981_b(colWater)); ++colWater) {
                    if (!this.isWaterBlock(world, spawnTo.func_177976_e().func_177981_b(colWater + 1))) continue;
                    world.func_180501_a(spawnTo.func_177976_e().func_177981_b(colWater), BlockNelumboStem.block.func_176223_P(), 3);
                }
                if (!this.canLeavesPlaceAt(world, spawnTo.func_177976_e().func_177981_b(colWater))) continue;
                world.func_180501_a(spawnTo.func_177976_e().func_177981_b(colWater), BlockNelumboLeaves.block.func_176223_P(), 3);
            }
        }
    }

    public boolean shouldGenerateInDimension(int id, int[] dims) {
        int[] var2 = dims;
        int var3 = dims.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int dim = var2[var4];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBiome(Biome biome, String[] biomesList) {
        String[] var2 = biomesList;
        int var3 = biomesList.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String checkBiome = var2[var4];
            if (!checkBiome.contains(":") && checkBiome.equalsIgnoreCase(biome.getRegistryName().toString().substring(0, biome.getRegistryName().toString().indexOf(":")))) {
                return true;
            }
            if (!checkBiome.equalsIgnoreCase(biome.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isWaterBlock(World world, BlockPos pos) {
        IBlockState iblockstate;
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h && (Integer)(iblockstate = world.func_180495_p(pos)).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    public boolean canLeavesPlaceAt(World worldIn, BlockPos pos) {
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
        if (!this.isWaterBlock(worldIn, pos.func_177977_b())) {
            return false;
        }
        if (!worldIn.func_175623_d(pos)) {
            return false;
        }
        if (worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c() == BlockNelumboStem.block) {
            return true;
        }
        return worldIn.func_180495_p(pos.func_177979_c(2).func_177974_f()).func_177230_c() == BlockNelumbo.block || worldIn.func_180495_p(pos.func_177979_c(2).func_177976_e()).func_177230_c() == BlockNelumbo.block || worldIn.func_180495_p(pos.func_177979_c(2).func_177978_c()).func_177230_c() == BlockNelumbo.block || worldIn.func_180495_p(pos.func_177979_c(2).func_177968_d()).func_177230_c() == BlockNelumbo.block;
    }
}

