/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lepidodendron.world.structure;

import java.util.Random;
import net.mcreator.lepidodendron.ElementsLepidodendronMod;
import net.mcreator.lepidodendron.LepidodendronConfig;
import net.mcreator.lepidodendron.LepidodendronTreeHandler;
import net.mcreator.lepidodendron.block.BlockPrototaxites;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

@ElementsLepidodendronMod.ModElement.Tag
public class StructureSpawnPrototaxites
extends ElementsLepidodendronMod.ModElement {
    public StructureSpawnPrototaxites(ElementsLepidodendronMod instance) {
        super(instance, 48);
    }

    @Override
    public void generateWorld(Random random, int i2, int k2, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        double GenMultiplier;
        boolean dimensionCriteria = false;
        boolean isNetherType = false;
        if (this.shouldGenerateInDimension(dimID, LepidodendronConfig.dimPrototaxites)) {
            dimensionCriteria = true;
        }
        if (!LepidodendronConfig.genPrototaxites && !LepidodendronConfig.genAllPlants) {
            dimensionCriteria = false;
        }
        if (!dimensionCriteria) {
            return;
        }
        boolean biomeCriteria = false;
        Biome biome = world.func_180494_b(new BlockPos(i2, LepidodendronConfig.levelSea, k2));
        if (!StructureSpawnPrototaxites.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnPrototaxites.matchBiome(biome, LepidodendronConfig.genPrototaxitesBlacklistBiomes)) {
            biomeCriteria = false;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                biomeCriteria = true;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                biomeCriteria = false;
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                biomeCriteria = false;
            }
        }
        if (StructureSpawnPrototaxites.matchBiome(biome, LepidodendronConfig.genPrototaxitesOverrideBiomes)) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        int GenChance = 15500;
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            GenChance = 80000;
        }
        if ((GenMultiplier = LepidodendronConfig.multiplierPrototaxites) < 0.0) {
            GenMultiplier = 0.0;
        }
        GenChance = Math.min(300000, (int)Math.round((double)GenChance * GenMultiplier));
        if (LepidodendronTreeHandler.matchBiome(biome, LepidodendronConfig.genTransformBiomes)) {
            GenChance = Math.min(GenChance * 5, 300000);
        }
        if (random.nextInt(1000000) + 1 <= GenChance) {
            int count = random.nextInt(1) + 2;
            for (int a = 0; a < count; ++a) {
                int j;
                int height;
                int i = i2 + random.nextInt(16) + 8;
                int k = k2 + random.nextInt(16) + 8;
                if (isNetherType) {
                    boolean notpassed = true;
                    for (height = 255; height > 0; --height) {
                        if (notpassed && world.func_175623_d(new BlockPos(i, height, k))) {
                            notpassed = false;
                            continue;
                        }
                        if (notpassed || world.func_175623_d(new BlockPos(i, height, k))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (height > 0 && (world.func_175623_d(new BlockPos(i, height, k)) || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151582_l || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151569_G || world.func_180495_p(new BlockPos(i, height, k)).func_185904_a() == Material.field_151585_k)) {
                        --height;
                    }
                }
                if (!this.canSurviveAt(world, new BlockPos(i, (j = height) + 1, k))) continue;
                int maxheight = LepidodendronConfig.maxheightPrototaxites;
                int minheight = LepidodendronConfig.minheightPrototaxites;
                if (maxheight < 0) {
                    maxheight = 0;
                }
                if (maxheight > 250) {
                    maxheight = 250;
                }
                if (minheight < 1) {
                    minheight = 1;
                }
                if (minheight > 250) {
                    minheight = 250;
                }
                if (j + 1 < minheight || j + 1 > maxheight && maxheight != 0) continue;
                biomeCriteria = false;
                biome = world.func_180494_b(new BlockPos(i, j + 1, k));
                if (!StructureSpawnPrototaxites.matchBiome(biome, LepidodendronConfig.genGlobalBlacklist) && !StructureSpawnPrototaxites.matchBiome(biome, LepidodendronConfig.genPrototaxitesBlacklistBiomes)) {
                    biomeCriteria = false;
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                        biomeCriteria = true;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                        biomeCriteria = false;
                    }
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                        biomeCriteria = false;
                    }
                }
                if (StructureSpawnPrototaxites.matchBiome(biome, LepidodendronConfig.genPrototaxitesOverrideBiomes)) {
                    biomeCriteria = true;
                }
                if (!biomeCriteria) continue;
                if (world.field_72995_K) {
                    return;
                }
                BlockPos spawnTo = new BlockPos(i, j + 1, k);
                int x = spawnTo.func_177958_n();
                int y = spawnTo.func_177956_o();
                int z = spawnTo.func_177952_p();
                if (!world.func_175667_e(spawnTo) || !world.func_175697_a(spawnTo, 3)) continue;
                if (world.func_175678_i(spawnTo) || world.func_180495_p(spawnTo).func_185904_a() == Material.field_151597_y && world.func_175678_i(spawnTo.func_177984_a())) {
                    world.func_175698_g(spawnTo);
                    world.func_175698_g(spawnTo.func_177984_a());
                }
                world.func_180501_a(spawnTo, BlockPrototaxites.block.func_176223_P(), 3);
            }
        }
    }

    public boolean shouldGenerateInDimension(int id, int[] dims) {
        int[] var2 = dims;
        int var3 = dims.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int dim = var2[var4];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBiome(Biome biome, String[] biomesList) {
        String[] var2 = biomesList;
        int var3 = biomesList.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String checkBiome = var2[var4];
            if (!checkBiome.contains(":") && checkBiome.equalsIgnoreCase(biome.getRegistryName().toString().substring(0, biome.getRegistryName().toString().indexOf(":")))) {
                return true;
            }
            if (!checkBiome.equalsIgnoreCase(biome.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean canSurviveAt(World worldIn, BlockPos pos) {
        int distV;
        int distH = LepidodendronConfig.waterPrototaxitesHorizontal;
        if (distH < 1) {
            distH = 1;
        }
        if (distH > 16) {
            distH = 16;
        }
        if ((distV = LepidodendronConfig.waterPrototaxitesVertical) < 1) {
            distV = 1;
        }
        if (distV > 6) {
            distV = 6;
        }
        boolean waterCriteria = false;
        for (int xct = -distH; xct <= distH && !waterCriteria; ++xct) {
            for (int yct = -distV; yct <= 1 && !waterCriteria; ++yct) {
                for (int zct = -distH; zct <= distH && !waterCriteria; ++zct) {
                    if (!(Math.pow(Math.abs(xct), 2.0) + Math.pow(Math.abs(zct), 2.0) <= Math.pow(distH, 2.0)) || worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + xct, pos.func_177956_o() + yct, pos.func_177952_p() + zct)).func_185904_a() != Material.field_151586_h) continue;
                    waterCriteria = true;
                }
            }
        }
        if (!waterCriteria) {
            return false;
        }
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151595_p || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150391_bh;
    }
}

