/*
 * Decompiled with CFR 0.152.
 */
package me.sargunvohra.mcmods.leveluphp.core;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.sargunvohra.mcmods.leveluphp.LuhpCriterionTriggers;
import me.sargunvohra.mcmods.leveluphp.LuhpSoundEvents;
import me.sargunvohra.mcmods.leveluphp.config.LevellingConfig;
import me.sargunvohra.mcmods.leveluphp.config.LevellingConfigManager;
import me.sargunvohra.mcmods.leveluphp.core.CapabilityRegistrationSubscriber;
import me.sargunvohra.mcmods.leveluphp.core.ExtensionsKt;
import me.sargunvohra.mcmods.leveluphp.core.HpLeveller;
import me.sargunvohra.mcmods.leveluphp.core.HpLevellerSyncMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0015J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0012\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0!\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020\u001aH\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001aH\u0002J\u0018\u0010,\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010.\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013\u00a8\u0006/"}, d2={"Lme/sargunvohra/mcmods/leveluphp/core/PlayerAttachedHpLeveller;", "Lme/sargunvohra/mcmods/leveluphp/core/HpLeveller;", "Lnet/minecraftforge/common/capabilities/ICapabilitySerializable;", "Lnet/minecraft/nbt/INBT;", "()V", "_level", "", "_xp", "config", "Lme/sargunvohra/mcmods/leveluphp/config/LevellingConfig;", "getConfig", "()Lme/sargunvohra/mcmods/leveluphp/config/LevellingConfig;", "justLevelledUp", "", "value", "level", "getLevel", "()I", "setLevel", "(I)V", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "xp", "getXp", "setXp", "applyToPlayer", "", "attachTo", "target", "constrainXpAndLevel", "deserializeNBT", "nbt", "getCapability", "Lnet/minecraftforge/common/util/LazyOptional;", "T", "requested", "Lnet/minecraftforge/common/capabilities/Capability;", "side", "Lnet/minecraft/util/Direction;", "handleDeath", "handleKillEnemy", "enemy", "Lnet/minecraft/entity/Entity;", "levelUpIfAble", "restoreTo", "serializeNBT", "updateState", "leveluphp-mc1.15.2-forge"})
public final class PlayerAttachedHpLeveller
implements HpLeveller,
ICapabilitySerializable<INBT> {
    private PlayerEntity player;
    private boolean justLevelledUp;
    private int _level;
    private int _xp;

    private final LevellingConfig getConfig() {
        return LevellingConfigManager.Companion.getConfig();
    }

    @Override
    public int getLevel() {
        return this._level;
    }

    @Override
    public void setLevel(int value) {
        this.justLevelledUp = this.justLevelledUp || !ExtensionsKt.isMaxedOut(this) && value > this.getLevel();
        this._level = value;
        this.updateState();
    }

    @Override
    public int getXp() {
        return this._xp;
    }

    @Override
    public void setXp(int value) {
        this._xp = value;
        this.updateState();
    }

    @Override
    public void restoreTo(int level, int xp) {
        this._level = level;
        this._xp = xp;
        this.updateState();
    }

    @Override
    public void handleKillEnemy(@NotNull Entity enemy) {
        int gain;
        Entity entity;
        Intrinsics.checkParameterIsNotNull((Object)enemy, (String)"enemy");
        ResourceLocation typeId = RegistryManager.ACTIVE.getRegistry(EntityType.class).getKey((IForgeRegistryEntry)enemy.func_200600_R());
        Integer n = this.getConfig().getOverrides().get(String.valueOf(typeId));
        int n2 = n != null ? n : ((entity = enemy) instanceof AnimalEntity ? this.getConfig().getPrimaryXpValues().getAnimal() : (gain = entity instanceof MobEntity ? this.getConfig().getPrimaryXpValues().getMob() : 0));
        if (gain != 0) {
            PlayerAttachedHpLeveller playerAttachedHpLeveller = this;
            playerAttachedHpLeveller.setXp(playerAttachedHpLeveller.getXp() + gain);
        }
    }

    @Override
    public void handleDeath() {
        if (this.getConfig().getResetOnDeath()) {
            this._level = 0;
            this._xp = 0;
        } else {
            this._level -= this.getConfig().getLevelPenaltyFunction().invoke(this.getLevel());
            this._xp -= this.getConfig().getXpPenaltyFunction().invoke(this.getLevel());
        }
        this.updateState();
    }

    @Override
    public void updateState() {
        this.constrainXpAndLevel();
        this.levelUpIfAble();
        this.applyToPlayer();
    }

    private final void constrainXpAndLevel() {
        this._level = RangesKt.coerceIn((int)this._level, (int)0, (int)this.getConfig().getMaximumLevel());
        this._xp = RangesKt.coerceAtLeast((int)this._xp, (int)0);
    }

    private final void levelUpIfAble() {
        while (this._xp >= ExtensionsKt.getCurrentXpTarget(this) && !ExtensionsKt.isMaxedOut(this)) {
            this._xp -= ExtensionsKt.getCurrentXpTarget(this);
            int n = this._level;
            this._level = n + 1;
            this.justLevelledUp = true;
        }
        if (this._level == this.getConfig().getMaximumLevel()) {
            this._xp = 0;
        }
    }

    private final void applyToPlayer() {
        PlayerEntity playerEntity = this.player;
        if (!(playerEntity instanceof ServerPlayerEntity)) {
            playerEntity = null;
        }
        ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
        if (serverPlayerEntity == null) {
            return;
        }
        ServerPlayerEntity player = serverPlayerEntity;
        if (player.field_71135_a != null) {
            HpLevellerSyncMessage.Companion.create(this).send(player);
        }
        AttributeModifier modifier = new AttributeModifier(UUID.fromString("ff859d30-ec60-418f-a5be-6f3de76a514a"), "Level Up HP modifier", (double)(this.getConfig().getHpOffset() + this.getLevel() * this.getConfig().getHpPerLevel()), AttributeModifier.Operation.ADDITION);
        modifier.func_111168_a(false);
        IAttributeInstance maxHealthAttr = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        maxHealthAttr.func_111124_b(modifier);
        maxHealthAttr.func_111121_a(modifier);
        if (this.justLevelledUp) {
            this.justLevelledUp = false;
            LuhpCriterionTriggers.INSTANCE.getLEVEL_UP().test(player);
            player.func_146105_b((ITextComponent)new StringTextComponent("\u00a7c\u00a7lHP up!"), true);
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), LuhpSoundEvents.INSTANCE.getLEVEL_UP(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (this.getConfig().getHealOnLevelUp()) {
                player.func_70606_j(player.func_110138_aP());
            }
        }
        if (player.func_110143_aJ() > player.func_110138_aP()) {
            player.func_70606_j(player.func_110138_aP());
        }
    }

    @NotNull
    public final PlayerAttachedHpLeveller attachTo(@NotNull PlayerEntity target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        PlayerAttachedHpLeveller playerAttachedHpLeveller = this;
        boolean bl = false;
        boolean bl2 = false;
        PlayerAttachedHpLeveller $this$apply = playerAttachedHpLeveller;
        boolean bl3 = false;
        $this$apply.player = target;
        return playerAttachedHpLeveller;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> requested, @Nullable Direction side) {
        LazyOptional lazyOptional;
        Intrinsics.checkParameterIsNotNull(requested, (String)"requested");
        if (this.player != null) {
            LazyOptional lazyOptional2 = CapabilityRegistrationSubscriber.INSTANCE.getHP_LEVELLER_CAPABILITY().orEmpty(requested, LazyOptional.of((NonNullSupplier)new NonNullSupplier<T>(this){
                final /* synthetic */ PlayerAttachedHpLeveller this$0;

                @NotNull
                public final PlayerAttachedHpLeveller get() {
                    return this.this$0;
                }
                {
                    this.this$0 = playerAttachedHpLeveller;
                }
            })).cast();
            lazyOptional = lazyOptional2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lazyOptional2, (String)"HP_LEVELLER_CAPABILITY.o\u2026ional.of { this }).cast()");
        } else {
            LazyOptional lazyOptional3 = LazyOptional.empty();
            lazyOptional = lazyOptional3;
            Intrinsics.checkExpressionValueIsNotNull((Object)lazyOptional3, (String)"LazyOptional.empty()");
        }
        return lazyOptional;
    }

    public void deserializeNBT(@Nullable INBT nbt) {
        LevellingConfigManager.Companion.ensureDataLoaded();
        CapabilityRegistrationSubscriber.INSTANCE.getHP_LEVELLER_CAPABILITY().readNBT((Object)this, null, nbt);
    }

    @Nullable
    public INBT serializeNBT() {
        LevellingConfigManager.Companion.ensureDataLoaded();
        return CapabilityRegistrationSubscriber.INSTANCE.getHP_LEVELLER_CAPABILITY().writeNBT((Object)this, null);
    }
}

