/*
 * Decompiled with CFR 0.152.
 */
package com.cookiehook.liquidenchanting;

import com.cookiehook.liquidenchanting.events.LiquidEnchantingEvent;
import com.cookiehook.liquidenchanting.util.Config;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.potion.Potion;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.Logger;

@Mod(modid="liquidenchanting", name="Liquid Enchanting", version="1.12.2_v6", acceptedMinecraftVersions="[1.12.2]")
public class Main {
    @Mod.Instance
    public static Main instance;
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        File configDir = new File(event.getModConfigurationDirectory() + "/" + "liquidenchanting");
        configDir.mkdir();
        Config.init(new File(configDir.getPath(), "liquidenchanting.cfg"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new LiquidEnchantingEvent());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RegistryNamespaced REGISTRY = GameData.getWrapper(Potion.class);
        ArrayList potions = Lists.newArrayList((Iterator)REGISTRY.iterator());
        logger.warn("Registry names for all potions");
        for (Potion potion : potions) {
            logger.info((Object)potion.getRegistryName());
        }
    }
}

