/*
 * Decompiled with CFR 0.152.
 */
package com.cookiehook.liquidenchanting.crafting;

import com.cookiehook.liquidenchanting.util.Config;
import com.cookiehook.liquidenchanting.util.LiquidEnchantmentHelper;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class PotionRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = recipe.getRecipeWidth();
        primer.height = recipe.getRecipeHeight();
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = recipe.func_192400_c();
        return new PotionImbewRecipe(new ResourceLocation("liquidenchanting", "potion_imbew_crafting"), recipe.func_77571_b(), primer);
    }

    public static class PotionImbewRecipe
    extends ShapedOreRecipe {
        public PotionImbewRecipe(ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer) {
            super(group, result, primer);
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inventory) {
            ItemStack outputItemStack = inventory.func_70301_a(4).func_77946_l();
            NBTTagCompound outputTag = outputItemStack.func_77978_p();
            NBTTagCompound potionTag = inventory.func_70301_a(0).func_77978_p().func_74737_b();
            potionTag.func_74757_a("liquid_enchanted", true);
            potionTag.func_82580_o("display");
            if (outputTag != null) {
                outputTag.func_179237_a(potionTag);
            } else {
                outputTag = potionTag;
                outputItemStack.func_77982_d(outputTag);
            }
            if (LiquidEnchantmentHelper.getPotionTypeFromNBT(potionTag).size() == 0) {
                outputTag.func_82580_o("Potion");
                outputTag.func_82580_o("liquid_enchanted");
                if (outputTag.func_74767_n("CustomPotionEffects")) {
                    outputTag.func_82580_o("CustomPotionEffects");
                    outputTag.func_82580_o("CustomPotionColor");
                    outputTag.func_82580_o("danger");
                }
            }
            if (outputTag.func_186856_d() == 0) {
                outputItemStack.func_77982_d(null);
            }
            return outputItemStack;
        }

        protected boolean checkMatch(InventoryCrafting inventory, int startX, int startY, boolean mirror) {
            NBTTagCompound initialPotion = inventory.func_70463_b(0, 0).func_77978_p();
            ItemStack centreItem = inventory.func_70463_b(1, 1);
            if (initialPotion == null) {
                return false;
            }
            List<PotionEffect> potionEffects = LiquidEnchantmentHelper.getPotionTypeFromNBT(initialPotion);
            for (PotionEffect potionEffect : potionEffects) {
                if (!(centreItem.func_77973_b() instanceof ItemArmor) || !potionEffect.func_188419_a().func_76403_b() || Config.instantEffectEnabled) continue;
                return false;
            }
            if (EnchantmentHelper.func_185291_a((int)30, (ItemStack)centreItem, (boolean)true).size() == 0) {
                return false;
            }
            if (centreItem.func_77976_d() != 1 || centreItem.func_190916_E() != 1) {
                return false;
            }
            for (int x = 0; x < inventory.func_174922_i(); ++x) {
                for (int y = 0; y < inventory.func_174923_h(); ++y) {
                    if (x == 1 && y == 1) continue;
                    int subX = x - startX;
                    int subY = y - startY;
                    Ingredient target = Ingredient.field_193370_a;
                    if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                        target = mirror ? (Ingredient)this.input.get(this.width - subX - 1 + subY * this.width) : (Ingredient)this.input.get(subX + subY * this.width);
                    }
                    if (!target.apply(inventory.func_70463_b(x, y))) {
                        return false;
                    }
                    NBTTagCompound currentPotion = inventory.func_70463_b(x, y).func_77978_p();
                    if (currentPotion != null && currentPotion.equals((Object)initialPotion)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

