/*
 * Decompiled with CFR 0.152.
 */
package com.cookiehook.liquidenchanting.events;

import com.cookiehook.liquidenchanting.util.Config;
import com.cookiehook.liquidenchanting.util.LiquidEnchantmentHelper;
import com.cookiehook.liquidenchanting.util.RomanNumber;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LiquidEnchantingEvent {
    private ItemStack bow;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderLivingEvent(RenderLivingEvent.Pre event) {
        EntityLivingBase player = event.getEntity();
        if (event.getEntity() instanceof EntityPlayer) {
            Iterator armor = player.func_184193_aE().iterator();
            ArrayList armorStack = Lists.newArrayList(armor);
            for (ItemStack itemstack : armorStack) {
                List<PotionEffect> potionEffects = LiquidEnchantmentHelper.getPotionTypeFromNBT(itemstack.func_77978_p());
                for (PotionEffect potionEffect : potionEffects) {
                    if (!potionEffect.func_76453_d().equals("effect.invisibility")) continue;
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void ArrowLooseEvent(ArrowLooseEvent event) {
        this.bow = event.getBow();
    }

    @SubscribeEvent
    public void EntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity arrow = event.getEntity();
        if (arrow instanceof EntityArrow && this.bow != null && this.bow.func_77978_p() != null) {
            NBTTagCompound tag = arrow.getEntityData();
            tag.func_179237_a(this.bow.func_77978_p());
            this.bow = null;
        }
    }

    @SubscribeEvent
    public void LivingHurtEvent(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity target = event.getEntity();
        List<PotionEffect> potionEffects = null;
        if (source instanceof EntityDamageSourceIndirect) {
            Entity projectile = source.func_76364_f();
            if (!(projectile instanceof EntityArrow)) {
                return;
            }
            NBTTagCompound potions = projectile.getEntityData();
            if (potions.func_186856_d() != 0) {
                potionEffects = LiquidEnchantmentHelper.getPotionTypeFromNBT(potions);
            }
        } else if (source instanceof EntityDamageSource) {
            Entity attacker = source.func_76346_g();
            if (!(attacker instanceof EntityPlayer)) {
                return;
            }
            ItemStack weapon = ((EntityPlayer)attacker).func_184614_ca();
            Item weaponItem = weapon.func_77973_b();
            if (weaponItem instanceof ItemArmor || weaponItem instanceof ItemBow || weaponItem instanceof ItemShield || weaponItem instanceof ItemElytra) {
                return;
            }
            if (weapon.func_77978_p() != null && weapon.func_77978_p().func_74767_n("liquid_enchanted")) {
                potionEffects = LiquidEnchantmentHelper.getPotionTypeFromNBT(weapon.func_77978_p());
            }
        }
        if (potionEffects != null) {
            for (PotionEffect potionEffect : potionEffects) {
                Potion potion = potionEffect.func_188419_a();
                int duration = potion.func_76403_b() ? 1 : Config.weaponEffectTime;
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(potion, duration, potionEffect.func_76458_c(), false, true));
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        Iterator armor = player.func_184193_aE().iterator();
        ArrayList armorStack = Lists.newArrayList(armor);
        for (ItemStack itemstack : armorStack) {
            List<PotionEffect> potionEffects = LiquidEnchantmentHelper.getPotionTypeFromNBT(itemstack.func_77978_p());
            for (PotionEffect potionEffect : potionEffects) {
                LiquidEnchantmentHelper.addPotionEffect((EntityLivingBase)player, potionEffect.func_188419_a(), potionEffect.func_76458_c());
            }
        }
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        ItemStack shield = null;
        if (mainHand.func_77973_b() instanceof ItemShield) {
            shield = mainHand;
        } else if (offHand.func_77973_b() instanceof ItemShield) {
            shield = offHand;
        }
        if (shield != null) {
            List<PotionEffect> potionEffects = LiquidEnchantmentHelper.getPotionTypeFromNBT(shield.func_77978_p());
            for (PotionEffect potionEffect : potionEffects) {
                LiquidEnchantmentHelper.addPotionEffect((EntityLivingBase)player, potionEffect.func_188419_a(), potionEffect.func_76458_c());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void toolTipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        List toolTip = event.getToolTip();
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74767_n("liquid_enchanted")) {
            List<PotionEffect> potionEffects = LiquidEnchantmentHelper.getPotionTypeFromNBT(itemStack.func_77978_p());
            for (PotionEffect potionEffect : potionEffects) {
                String level = "";
                TextFormatting textFormat = potionEffect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE;
                String potionName = potionEffect.func_188419_a().func_76393_a();
                if (potionEffect.func_76458_c() > 0) {
                    level = RomanNumber.toRoman(potionEffect.func_76458_c() + 1);
                }
                toolTip.add(1, textFormat + I18n.func_135052_a((String)potionName, (Object[])new Object[0]) + " " + level);
            }
        }
    }
}

