/*
 * Decompiled with CFR 0.152.
 */
package com.cookiehook.liquidenchanting.util;

import com.cookiehook.liquidenchanting.util.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;

public class LiquidEnchantmentHelper {
    public static List<PotionEffect> getPotionTypeFromNBT(NBTTagCompound nbtTagCompound) {
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        if (nbtTagCompound != null) {
            String potionName = nbtTagCompound.func_74779_i("Potion");
            if (!potionName.equals("") && PotionType.func_185168_a((String)potionName) != null) {
                potionEffects.addAll(PotionType.func_185168_a((String)potionName).func_185170_a());
            }
            if (Config.combinedCraftingEnabled) {
                NBTTagList customPotionList = nbtTagCompound.func_150295_c("CustomPotionEffects", 10);
                for (NBTBase tag : customPotionList) {
                    potionEffects.add(PotionEffect.func_82722_b((NBTTagCompound)((NBTTagCompound)tag)));
                }
            }
        }
        ArrayList<PotionEffect> effectsToRemove = new ArrayList<PotionEffect>();
        for (PotionEffect effect : potionEffects) {
            String effectName = effect.func_188419_a().getRegistryName().toString();
            if (!Arrays.asList(Config.disabledPotions).contains(effectName)) continue;
            effectsToRemove.add(effect);
        }
        potionEffects.removeAll(effectsToRemove);
        return potionEffects;
    }

    public static void addPotionEffect(EntityLivingBase entity, Potion potion, int amplifier) {
        int duration;
        PotionEffect activeEffect = entity.func_70660_b(potion);
        for (int i = duration = 10; i < 1000; ++i) {
            if (!potion.func_76397_a(i, amplifier)) continue;
            duration = i;
            break;
        }
        if (potion == MobEffects.field_76439_r) {
            entity.func_70690_d(new PotionEffect(potion, 210, amplifier, false, false));
        } else if (activeEffect == null || activeEffect.func_76459_b() < 10) {
            entity.func_70690_d(new PotionEffect(potion, duration, amplifier, false, false));
        }
    }
}

