/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.literalascension.common.item;

import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.literalascension.api.ICarvingBehaviour;
import com.jamieswhiteshirt.literalascension.api.ICarvingMaterial;
import com.jamieswhiteshirt.literalascension.features.Carving;
import com.jamieswhiteshirt.literalascension.features.carving.carvingtools.CarvingTool;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0017JH\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006-"}, d2={"Lcom/jamieswhiteshirt/literalascension/common/item/ItemCarvingTool;", "Lnet/minecraft/item/Item;", "feature", "Lcom/jamieswhiteshirt/literalascension/features/carving/carvingtools/CarvingTool;", "toolMaterial", "Lnet/minecraft/item/Item$ToolMaterial;", "(Lcom/jamieswhiteshirt/literalascension/features/carving/carvingtools/CarvingTool;Lnet/minecraft/item/Item$ToolMaterial;)V", "getFeature", "()Lcom/jamieswhiteshirt/literalascension/features/carving/carvingtools/CarvingTool;", "speed", "", "getToolMaterial", "()Lnet/minecraft/item/Item$ToolMaterial;", "getAttributeModifiers", "Lcom/google/common/collect/Multimap;", "", "Lnet/minecraft/entity/ai/attributes/AttributeModifier;", "slot", "Lnet/minecraft/inventory/EntityEquipmentSlot;", "stack", "Lnet/minecraft/item/ItemStack;", "getIsRepairable", "", "toRepair", "repair", "hitEntity", "target", "Lnet/minecraft/entity/EntityLivingBase;", "attacker", "isFull3D", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "hitY", "hitZ", "literalascension"})
public final class ItemCarvingTool
extends Item {
    private final float speed;
    @NotNull
    private final CarvingTool feature;
    @NotNull
    private final Item.ToolMaterial toolMaterial;

    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ICarvingMaterial carvingMaterial;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Carving carving = this.feature.getParent().getParent();
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        ICarvingBehaviour carvingBehaviour = carving.getCarvingBehaviour(iBlockState);
        if (carvingBehaviour != null && (carvingMaterial = carvingBehaviour.getCarvingMaterial()).getRequiredCarvingToolLevel() <= this.toolMaterial.func_77996_d() && carvingBehaviour.tryCarve(state, world, pos, facing, hitX, hitY, hitZ)) {
            if (!world.field_72995_K) {
                if (this.toolMaterial.func_77996_d() < carvingMaterial.getSuitableCarvingToolLevel()) {
                    stack.func_77972_a(carvingMaterial.getUnsuitableToolDamageMultiplier(), (EntityLivingBase)player);
                } else {
                    stack.func_77972_a(carvingMaterial.getSuitableToolDamageMultiplier(), (EntityLivingBase)player);
                }
            }
            this.feature.getParent().getParent().playCarveSound(world, pos, player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_77644_a(@NotNull ItemStack stack, @NotNull EntityLivingBase target, @NotNull EntityLivingBase attacker) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)attacker, (String)"attacker");
        stack.func_77972_a(1, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    public boolean func_82789_a(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        ItemStack requiredItem;
        Intrinsics.checkParameterIsNotNull((Object)toRepair, (String)"toRepair");
        Intrinsics.checkParameterIsNotNull((Object)repair, (String)"repair");
        ItemStack itemStack = requiredItem = this.toolMaterial.getRepairItemStack();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"requiredItem");
        if (!itemStack.func_190926_b()) {
            return OreDictionary.itemMatches((ItemStack)requiredItem, (ItemStack)repair, (boolean)false);
        }
        return super.func_82789_a(toRepair, repair);
    }

    @NotNull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@NotNull EntityEquipmentSlot slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)slot, (String)"slot");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            IAttribute iAttribute = SharedMonsterAttributes.field_111264_e;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAttribute, (String)"SharedMonsterAttributes.ATTACK_DAMAGE");
            multimap.put((Object)iAttribute.func_111108_a(), (Object)new AttributeModifier(ItemCarvingTool.access$getATTACK_DAMAGE_MODIFIER$p$s2289459(), "Weapon modifier", 0.0, 0));
            IAttribute iAttribute2 = SharedMonsterAttributes.field_188790_f;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAttribute2, (String)"SharedMonsterAttributes.ATTACK_SPEED");
            multimap.put((Object)iAttribute2.func_111108_a(), (Object)new AttributeModifier(ItemCarvingTool.access$getATTACK_SPEED_MODIFIER$p$s2289459(), "Weapon modifier", (double)this.speed - 4.0, 0));
        }
        Multimap multimap2 = multimap;
        Intrinsics.checkExpressionValueIsNotNull((Object)multimap2, (String)"multimap");
        return multimap2;
    }

    @NotNull
    public final CarvingTool getFeature() {
        return this.feature;
    }

    @NotNull
    public final Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    public ItemCarvingTool(@NotNull CarvingTool feature, @NotNull Item.ToolMaterial toolMaterial) {
        Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
        Intrinsics.checkParameterIsNotNull((Object)toolMaterial, (String)"toolMaterial");
        this.feature = feature;
        this.toolMaterial = toolMaterial;
        this.speed = this.toolMaterial.func_78000_c() + 1.0f;
        this.field_77777_bU = 1;
        this.func_77656_e(this.toolMaterial.func_77997_a());
    }

    public static final /* synthetic */ UUID access$getATTACK_DAMAGE_MODIFIER$p$s2289459() {
        return Item.field_111210_e;
    }

    public static final /* synthetic */ UUID access$getATTACK_SPEED_MODIFIER$p$s2289459() {
        return Item.field_185050_h;
    }
}

