/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fi.dy.masa.minihud.event.RenderEventHandler;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class Configs {
    public static boolean enableByDefault;
    public static boolean sortLinesByLength;
    public static boolean sortLinesReversed;
    public static boolean coordinateFormatCustomized;
    public static boolean requireSneak;
    public static boolean requireHoldingKey;
    public static boolean useFontShadow;
    public static boolean useScaledFont;
    public static boolean useTextBackground;
    public static boolean debugRendererPathfindingEnablePointWidth;
    private static double fontScale;
    public static double activeFontScale;
    public static int enabledInfoTypes;
    public static int fontColor;
    public static int regionOverlayColor;
    public static int textBackgroundColor;
    public static int textPosX;
    public static int textPosY;
    public static String coordinateFormat;
    public static String dateFormatMinecraft;
    public static String dateFormatReal;
    public static RenderEventHandler.HudAlignment hudAlignment;
    public static KeyModifier requiredKey;
    private static final Multimap<Integer, Long> HOTKEY_DEBUG_MAP;
    private static final Multimap<Integer, Long> HOTKEY_INFO_MAP;
    private static final Map<Long, Integer> LINE_ORDER_MAP;
    public static File configurationFile;
    public static Configuration config;
    public static final String CATEGORY_DEBUG_HOTKEYS = "VanillaDebugRendererHotkeys";
    public static final String CATEGORY_DEBUG_RENDERER = "VanillaDebugRendererOptions";
    public static final String CATEGORY_GENERIC = "Generic";
    public static final String CATEGORY_INFO_TOGGLE = "InfoTypes";
    public static final String CATEGORY_INFO_HOTKEYS = "InfoToggleHotkeys";
    public static final String CATEGORY_INFO_LINE_ORDER = "InfoLineOrder";
    public static final String CATEGORY_RENDERER_HOTKEYS = "RenderHotkeys";

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("minihud".equals(event.getModID())) {
            Configs.loadConfigs(config);
        }
    }

    public static void loadConfigsFromFile(File configFile) {
        configurationFile = configFile;
        config = new Configuration(configFile, null, true);
        config.load();
        Configs.loadConfigs(config);
    }

    public static void loadConfigs(Configuration conf) {
        Property prop = conf.get(CATEGORY_GENERIC, "coordinateFormat", "x: %.1f y: %.1f z: %.1f");
        prop.setComment("The format string for the coordinate line (needs to have three %f format strings!) Default: x: %.1f y: %.1f z: %.1f");
        coordinateFormat = prop.getString();
        prop = conf.get(CATEGORY_GENERIC, "coordinateFormatCustomized", true);
        prop.setComment("Use the customized coordinate format string");
        coordinateFormatCustomized = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "dateFormatReal", "yyyy-MM-dd HH:mm:ss");
        prop.setComment("The format string for real time, see the Java SimpleDateFormat class for the format patterns, if needed");
        dateFormatReal = prop.getString();
        prop = conf.get(CATEGORY_GENERIC, "dateFormatMinecraft", "MC time: (day {DAY}) {HOUR}:{MIN}:xx");
        prop.setComment("The format string for the Minecraft time.\nThe supported placeholders are: {DAY}, {HOUR}, {MIN}, {SEC}");
        dateFormatMinecraft = prop.getString();
        prop = conf.get(CATEGORY_GENERIC, "enableByDefault", true);
        prop.setComment("If true, the HUD will be enabled by default on game launch");
        enableByDefault = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "fontColor", "0xE0E0E0");
        prop.setComment("Font color (RGB, default: 0xE0E0E0 = 14737632)");
        fontColor = Configs.getColor(prop.getString(), 0xE0E0E0);
        prop = conf.get(CATEGORY_GENERIC, "fontScale", 1.0);
        prop.setComment("Font scale factor. Valid range: 0.0 - 10.0. Default: 1.0\nNote that the 'useScaledFont' option will override this option (with 0.5) if it's enabled!");
        fontScale = MathHelper.func_151237_a((double)prop.getDouble(), (double)0.0, (double)10.0);
        prop = conf.get(CATEGORY_GENERIC, "hudAlignment", "top_left");
        prop.setComment("The alignment of the HUD. Valid values: top_left, rop_right, bottom_left, bottom_right, center.");
        hudAlignment = RenderEventHandler.HudAlignment.fromString(prop.getString());
        prop = conf.get(CATEGORY_GENERIC, "regionOverlayColor", "0xFFFF8019");
        prop.setComment("Color for the region file overlay rendering (RGB, default: 0xFFFF8019)");
        regionOverlayColor = Configs.getColor(prop.getString(), -32743);
        prop = conf.get(CATEGORY_GENERIC, "requireSneak", false);
        prop.setComment("Require the player to be sneaking to render the HUD");
        requireSneak = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "requireHoldingKey", false);
        prop.setComment("Require holding a key to render the HUD. Valid keys are Alt, Ctrl and Shift.");
        requireHoldingKey = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "requiredKey", "none");
        prop.setComment("The key required to render the HUD, if 'requireHoldingKey' is enabled. Valid values are 'alt', 'ctrl' and 'shift'.");
        requiredKey = Configs.getKeyModifier(prop.getString());
        prop = conf.get(CATEGORY_GENERIC, "sortLinesByLength", false);
        prop.setComment("Sort the lines by their text's length");
        sortLinesByLength = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "sortLinesReversed", false);
        prop.setComment("Reverse the line sorting order");
        sortLinesReversed = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "textBackgroundColor", "0xA0505050");
        prop.setComment("Text background color (ARGB, default: 0xA0505050)");
        textBackgroundColor = Configs.getColor(prop.getString(), -1605349296);
        prop = conf.get(CATEGORY_GENERIC, "textPosX", 4);
        prop.setComment("Text X position (default: 4)");
        textPosX = prop.getInt();
        prop = conf.get(CATEGORY_GENERIC, "textPosY", 4);
        prop.setComment("Text Y position (default: 4)");
        textPosY = prop.getInt();
        prop = conf.get(CATEGORY_GENERIC, "useFontShadow", false);
        prop.setComment("Use font shadow");
        useFontShadow = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "useScaledFont", true);
        prop.setComment("Use 0.5x scale font size. Note that this overrides the 'fontScale' option!");
        useScaledFont = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "useTextBackground", true);
        prop.setComment("Use a solid background color behind the text");
        useTextBackground = prop.getBoolean();
        prop = conf.get(CATEGORY_DEBUG_RENDERER, "debugRendererPathfindingEnablePointWidth", true);
        prop.setComment("If true, then the vanilla pathfinding debug renderer will render the max distance boxes.");
        debugRendererPathfindingEnablePointWidth = prop.getBoolean();
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoBiome", false);
        prop.setComment("Show the the name of the current biome");
        Configs.setInfoType(262144, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoBiomeRegistryName", false);
        prop.setComment("Show the registry name of the current biome");
        Configs.setInfoType(524288, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoBlockPosition", false);
        prop.setComment("Show the player's current block position");
        Configs.setInfoType(64, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoBlockProperties", false);
        prop.setComment("Show the BlockState properties and values of the looked-at block");
        Configs.setInfoType(0x4000000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoBlockInChunk", false);
        prop.setComment("Show the player's current position within the chunk");
        Configs.setInfoType(128, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoChunkPosition", false);
        prop.setComment("Show the chunk position the player is currently in");
        Configs.setInfoType(0x8000000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoChunkSections", false);
        prop.setComment("Show the currently rendered number of Chunk sections (the C value from F3)");
        Configs.setInfoType(8192, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoChunkSectionsLine", false);
        prop.setComment("Show the entire line of the C value from the F3 screen");
        Configs.setInfoType(16384, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoChunkUpdates", false);
        prop.setComment("Show the current number of chunk updates per second");
        Configs.setInfoType(32768, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoCoordinates", true);
        prop.setComment("Show the player's current coordinates");
        Configs.setInfoType(16, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoDifficulty", false);
        prop.setComment("Show the local difficulty");
        Configs.setInfoType(131072, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoDimensionId", true);
        prop.setComment("Show the current dimension ID (might not be accurate in every case, depending on the server!)");
        Configs.setInfoType(32, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoEntities", false);
        prop.setComment("Show the visible/loaded entity count");
        Configs.setInfoType(0x100000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoEntityRegistryName", false);
        prop.setComment("Show the registry name of the entity the player is currently looking at");
        Configs.setInfoType(0x800000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoFacing", true);
        prop.setComment("Show the player's current facing");
        Configs.setInfoType(256, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoFPS", false);
        prop.setComment("Show the current FPS");
        Configs.setInfoType(1, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoLightLevel", false);
        prop.setComment("Show the current light level");
        Configs.setInfoType(512, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoLookingAtBlock", false);
        prop.setComment("Show which block the player is currently looking at");
        Configs.setInfoType(0x1000000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoLookingAtBlockInChunk", false);
        prop.setComment("Show which block within its containing chunk the player is currently looking at");
        Configs.setInfoType(0x2000000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoLookingAtEntity", false);
        prop.setComment("Show the entity name and health when looked at");
        Configs.setInfoType(0x400000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoParticleCount", false);
        prop.setComment("Show the currently renderer particle count (P from F3)");
        Configs.setInfoType(65536, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoRealTime", true);
        prop.setComment("Show the current real time formatted according to dateFormatReal");
        Configs.setInfoType(2, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoRegionFile", false);
        prop.setComment("Show the region file the player is currently in");
        Configs.setInfoType(0x10000000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoRotationPitch", false);
        prop.setComment("Show the player's current pitch rotation");
        Configs.setInfoType(2048, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoRotationYaw", false);
        prop.setComment("Show the player's current yaw rotation");
        Configs.setInfoType(1024, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoSlimeChunk", false);
        prop.setComment("Show whether the player is currently in a slime chunk.\nNOTE: This only works in single player without any user intervention!\nOn a server the player needs to be admin/OP and\nrun the /seed command manually EVERY TIME they join or change dimensions!");
        Configs.setInfoType(0x200000, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoSpeed", false);
        prop.setComment("Show the player's current moving speed");
        Configs.setInfoType(4096, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoWorldTime", false);
        prop.setComment("Show the current world time in ticks");
        Configs.setInfoType(4, prop.getBoolean());
        prop = conf.get(CATEGORY_INFO_TOGGLE, "infoWorldTimeFormatted", false);
        prop.setComment("Show the current world time formatted to days, hours, minutes");
        Configs.setInfoType(8, prop.getBoolean());
        ConfigCategory cat = conf.getCategory(CATEGORY_INFO_HOTKEYS);
        cat.setComment("Here you can assign hotkeys to toggle the different information types on/off.\nNOTE: Make sure you don't have the same value for more than one info type, or the latest one will override all the earlier ones.\nYou can give the key \"names\", like \"a\" or \"7\", or you can give the raw numeric LWJGL keycodes (only works for key codes > 11).\nTo toggle the info type while in-game, press and hold the Toggle key and then press the keys set here to toggle the info types on/off.");
        HOTKEY_INFO_MAP.clear();
        Configs.assignInfoHotkey(conf, "infoFPS", 1L, "");
        Configs.assignInfoHotkey(conf, "infoRealTime", 2L, "t");
        Configs.assignInfoHotkey(conf, "infoWorldTime", 4L, "");
        Configs.assignInfoHotkey(conf, "infoWorldTimeFormatted", 8L, "");
        Configs.assignInfoHotkey(conf, "infoCoordinates", 16L, "n");
        Configs.assignInfoHotkey(conf, "infoDimensionId", 32L, "d");
        Configs.assignInfoHotkey(conf, "infoBlockPosition", 64L, "o");
        Configs.assignInfoHotkey(conf, "infoBlockInChunk", 128L, "");
        Configs.assignInfoHotkey(conf, "infoFacing", 256L, "f");
        Configs.assignInfoHotkey(conf, "infoLightLevel", 512L, "l");
        Configs.assignInfoHotkey(conf, "infoRotationYaw", 1024L, "r");
        Configs.assignInfoHotkey(conf, "infoRotationPitch", 2048L, "r");
        Configs.assignInfoHotkey(conf, "infoSpeed", 4096L, "s");
        Configs.assignInfoHotkey(conf, "infoChunkSections", 8192L, "");
        Configs.assignInfoHotkey(conf, "infoChunkSectionsLine", 16384L, "");
        Configs.assignInfoHotkey(conf, "infoChunkUpdates", 32768L, "");
        Configs.assignInfoHotkey(conf, "infoParticleCount", 65536L, "");
        Configs.assignInfoHotkey(conf, "infoDifficulty", 131072L, "");
        Configs.assignInfoHotkey(conf, "infoBiome", 262144L, "b");
        Configs.assignInfoHotkey(conf, "infoBiomeRegistryName", 524288L, "b");
        Configs.assignInfoHotkey(conf, "infoEntities", 0x100000L, "");
        Configs.assignInfoHotkey(conf, "infoSlimeChunk", 0x200000L, "i");
        Configs.assignInfoHotkey(conf, "infoLookingAtEntity", 0x400000L, "l");
        Configs.assignInfoHotkey(conf, "infoEntityRegistryName", 0x800000L, "l");
        Configs.assignInfoHotkey(conf, "infoLookingAtBlock", 0x1000000L, "l");
        Configs.assignInfoHotkey(conf, "infoLookingAtBlockInChunk", 0x2000000L, "");
        Configs.assignInfoHotkey(conf, "infoBlockProperties", 0x4000000L, "p");
        Configs.assignInfoHotkey(conf, "infoChunkPosition", 0x8000000L, "c");
        Configs.assignInfoHotkey(conf, "infoRegionFile", 0x10000000L, "g");
        Configs.assignHotkey(HOTKEY_INFO_MAP, conf, CATEGORY_RENDERER_HOTKEYS, "renderRegionOverlay", "j", 0x10000000000L);
        cat = conf.getCategory(CATEGORY_DEBUG_HOTKEYS);
        cat.setComment("Hotkeys to toggle ON/OFF the vanilla debug renderers.\nTo use these, first press down F3 and then press the\nkeys defined here to toggle the feature ON/OFF.");
        HOTKEY_DEBUG_MAP.clear();
        Configs.assignDebugRendererHotkey(conf, "debugCollisionBoxEnabled", 1, "1");
        Configs.assignDebugRendererHotkey(conf, "debugHeightMapEnabled", 2, "2");
        Configs.assignDebugRendererHotkey(conf, "debugNeighborsUpdateEnabled", 4, "3");
        Configs.assignDebugRendererHotkey(conf, "debugPathfindingEnabled", 8, "4");
        Configs.assignDebugRendererHotkey(conf, "debugSolidFaceEnabled", 16, "5");
        Configs.assignDebugRendererHotkey(conf, "debugWaterEnabled", 32, "6");
        cat = conf.getCategory(CATEGORY_INFO_LINE_ORDER);
        cat.setComment("Here you can set the order of the info lines.\nThe number is the position in the list the line gets added to.\nThe indexing starts from 0.\nIf multiple types have the same index, then the last one that\nis actually added internally, will bump previous entries downwards.");
        LINE_ORDER_MAP.clear();
        Configs.setLinePosition(conf, "infoFPS", 1L);
        Configs.setLinePosition(conf, "infoRealTime", 2L);
        Configs.setLinePosition(conf, "infoWorldTime", 4L);
        Configs.setLinePosition(conf, "infoWorldTimeFormatted", 8L);
        Configs.setLinePosition(conf, "infoCoordinates", 16L);
        Configs.setLinePosition(conf, "infoDimensionId", 32L);
        Configs.setLinePosition(conf, "infoBlockPosition", 64L);
        Configs.setLinePosition(conf, "infoBlockInChunk", 128L);
        Configs.setLinePosition(conf, "infoChunkPosition", 0x8000000L);
        Configs.setLinePosition(conf, "infoRegionFile", 0x10000000L);
        Configs.setLinePosition(conf, "infoFacing", 256L);
        Configs.setLinePosition(conf, "infoLightLevel", 512L);
        Configs.setLinePosition(conf, "infoRotationYaw", 1024L);
        Configs.setLinePosition(conf, "infoRotationPitch", 2048L);
        Configs.setLinePosition(conf, "infoSpeed", 4096L);
        Configs.setLinePosition(conf, "infoChunkSections", 8192L);
        Configs.setLinePosition(conf, "infoChunkSectionsLine", 16384L);
        Configs.setLinePosition(conf, "infoChunkUpdates", 32768L);
        Configs.setLinePosition(conf, "infoParticleCount", 65536L);
        Configs.setLinePosition(conf, "infoDifficulty", 131072L);
        Configs.setLinePosition(conf, "infoBiome", 262144L);
        Configs.setLinePosition(conf, "infoBiomeRegistryName", 524288L);
        Configs.setLinePosition(conf, "infoEntities", 0x100000L);
        Configs.setLinePosition(conf, "infoSlimeChunk", 0x200000L);
        Configs.setLinePosition(conf, "infoLookingAtEntity", 0x400000L);
        Configs.setLinePosition(conf, "infoEntityRegistryName", 0x800000L);
        Configs.setLinePosition(conf, "infoLookingAtBlock", 0x1000000L);
        Configs.setLinePosition(conf, "infoLookingAtBlockInChunk", 0x2000000L);
        Configs.setLinePosition(conf, "infoBlockProperties", 0x4000000L);
        RenderEventHandler.getInstance().setEnabledMask(enabledInfoTypes);
        double d = activeFontScale = useScaledFont ? 0.5 : fontScale;
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    private static void setInfoType(int mask, boolean value) {
        enabledInfoTypes = value ? (enabledInfoTypes |= mask) : (enabledInfoTypes &= ~mask);
    }

    private static int getColor(String colorStr, int defaultColor) {
        Pattern pattern = Pattern.compile("(?:0x|#)([a-fA-F0-9]{1,8})");
        Matcher matcher = pattern.matcher(colorStr);
        if (matcher.matches()) {
            try {
                return (int)Long.parseLong(matcher.group(1), 16);
            }
            catch (NumberFormatException e) {
                return defaultColor;
            }
        }
        try {
            return Integer.parseInt(colorStr, 10);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    private static KeyModifier getKeyModifier(String value) {
        if (value == null) {
            return KeyModifier.NONE;
        }
        if (value.equalsIgnoreCase("shift")) {
            return KeyModifier.SHIFT;
        }
        if (value.equalsIgnoreCase("ctrl") || value.equalsIgnoreCase("control")) {
            return KeyModifier.CONTROL;
        }
        if (value.equalsIgnoreCase("alt")) {
            return KeyModifier.ALT;
        }
        return KeyModifier.NONE;
    }

    private static void assignInfoHotkey(Configuration conf, String configKey, long infoBitmask, String defaultKey) {
        Configs.assignHotkey(HOTKEY_INFO_MAP, conf, CATEGORY_INFO_HOTKEYS, configKey, defaultKey, infoBitmask);
    }

    private static void assignDebugRendererHotkey(Configuration conf, String configKey, int bitmask, String defaultKey) {
        Configs.assignHotkey(HOTKEY_DEBUG_MAP, conf, CATEGORY_DEBUG_HOTKEYS, configKey, defaultKey, bitmask);
    }

    private static void assignHotkey(Multimap<Integer, Long> map, Configuration conf, String configCategory, String configKey, String defaultKey, long bitmask) {
        int keyCode2;
        String keyName = conf.get(configCategory, configKey, defaultKey).getString();
        try {
            keyCode2 = Integer.parseInt(keyName);
            if (keyCode2 > 11) {
                map.put((Object)keyCode2, (Object)bitmask);
                return;
            }
        }
        catch (NumberFormatException keyCode2) {
            // empty catch block
        }
        keyCode2 = Keyboard.getKeyIndex((String)keyName.toUpperCase());
        if (keyCode2 != 0) {
            map.put((Object)keyCode2, (Object)bitmask);
        }
    }

    public static long getBitmaskForInfoKey(int keyCode) {
        return Configs.getBitmaskForKey(HOTKEY_INFO_MAP, keyCode);
    }

    public static long getBitmaskForDebugKey(int keyCode) {
        return Configs.getBitmaskForKey(HOTKEY_DEBUG_MAP, keyCode);
    }

    public static long getBitmaskForKey(Multimap<Integer, Long> map, int keyCode) {
        Collection masks = map.get((Object)keyCode);
        long fullMask = 0L;
        if (masks != null) {
            for (Long mask : masks) {
                fullMask |= mask.longValue();
            }
        }
        return fullMask;
    }

    private static void setLinePosition(Configuration conf, String configKey, long infoBitmask) {
        int value = conf.get(CATEGORY_INFO_LINE_ORDER, configKey, -1).getInt();
        LINE_ORDER_MAP.put(infoBitmask, value);
    }

    public static int getLinePositionFor(long infoType) {
        Integer value = LINE_ORDER_MAP.get(infoType);
        return value != null ? value : -1;
    }

    static {
        hudAlignment = RenderEventHandler.HudAlignment.TOP_LEFT;
        HOTKEY_DEBUG_MAP = HashMultimap.create();
        HOTKEY_INFO_MAP = HashMultimap.create();
        LINE_ORDER_MAP = new HashMap<Long, Integer>();
    }
}

