/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import com.google.common.collect.MapMaker;
import fi.dy.masa.minihud.MiniHud;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.event.RenderEventHandler;
import fi.dy.masa.minihud.proxy.ClientProxy;
import fi.dy.masa.minihud.util.DebugInfoUtils;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.DebugRendererNeighborsUpdate;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class InputEventHandler {
    public static final int MASK_DEBUG_COLLISION_BOXES = 1;
    public static final int MASK_DEBUG_HEIGHT_MAP = 2;
    public static final int MASK_DEBUG_NEIGHBOR_UPDATE = 4;
    public static final int MASK_DEBUG_PATHFINDING = 8;
    public static final int MASK_DEBUG_SOLID_FACES = 16;
    public static final int MASK_DEBUG_WATER = 32;
    private final Minecraft mc;
    private boolean toggledInfo;
    private Field field_Minecraft_actionKeyF3;
    private Field field_DebugRenderer_collisionBoxEnabled;
    private Field field_DebugRenderer_heightMapEnabled;
    private Field field_DebugRenderer_neighborsUpdateEnabled;
    private Field field_DebugRenderer_pathfindingEnabled;
    private Field field_DebugRenderer_solidFaceEnabled;
    private Field field_DebugRenderer_waterEnabled;
    private Field field_PathNavigate_maxDistanceToWaypoint;
    private boolean neighborUpdateEnabled;
    private boolean pathfindingEnabled;
    private int tickCounter;
    private final Map<Entity, Path> oldPaths = new MapMaker().weakKeys().weakValues().makeMap();

    public InputEventHandler() {
        this.mc = Minecraft.func_71410_x();
        try {
            this.field_Minecraft_actionKeyF3 = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"field_184129_aV", "actionKeyF3"});
            this.field_DebugRenderer_collisionBoxEnabled = ReflectionHelper.findField(DebugRenderer.class, (String[])new String[]{"field_191326_j", "collisionBoxEnabled"});
            this.field_DebugRenderer_heightMapEnabled = ReflectionHelper.findField(DebugRenderer.class, (String[])new String[]{"field_190082_h", "heightMapEnabled"});
            this.field_DebugRenderer_neighborsUpdateEnabled = ReflectionHelper.findField(DebugRenderer.class, (String[])new String[]{"field_191558_l", "neighborsUpdateEnabled"});
            this.field_DebugRenderer_pathfindingEnabled = ReflectionHelper.findField(DebugRenderer.class, (String[])new String[]{"field_190080_f", "pathfindingEnabled"});
            this.field_DebugRenderer_solidFaceEnabled = ReflectionHelper.findField(DebugRenderer.class, (String[])new String[]{"field_193853_n", "solidFaceEnabled"});
            this.field_DebugRenderer_waterEnabled = ReflectionHelper.findField(DebugRenderer.class, (String[])new String[]{"field_190081_g", "waterEnabled"});
            this.field_PathNavigate_maxDistanceToWaypoint = ReflectionHelper.findField(PathNavigate.class, (String[])new String[]{"field_188561_o", "maxDistanceToWaypoint"});
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            MiniHud.logger.warn("Failed to reflect DebugRenderer fields");
        }
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        int key = Keyboard.getEventKey();
        boolean state = Keyboard.getEventKeyState();
        long mask = Configs.getBitmaskForDebugKey(key);
        if (state && Keyboard.isKeyDown((int)61) && mask != 0L) {
            this.toggleDebugRenderers((int)mask);
            KeyBinding.func_74510_a((int)key, (boolean)false);
            this.setBoolean(this.field_Minecraft_actionKeyF3, this.mc, true);
            KeyBinding.func_74506_a();
            return;
        }
        int toggleKey = ClientProxy.keyToggleMode.func_151463_i();
        mask = Configs.getBitmaskForInfoKey(key);
        if (!state && key == toggleKey) {
            if (!this.toggledInfo) {
                RenderEventHandler.getInstance().toggleEnabled();
            }
            this.toggledInfo = false;
        } else if (state && mask != 0L && Keyboard.isKeyDown((int)toggleKey)) {
            RenderEventHandler.getInstance().xorEnabledMask(mask);
            this.toggledInfo = true;
            KeyBinding.func_74506_a();
        }
    }

    @SubscribeEvent
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        if (this.neighborUpdateEnabled && !event.getWorld().field_72995_K) {
            final long time = event.getWorld().func_82737_E();
            final BlockPos pos = event.getPos();
            this.mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ((DebugRendererNeighborsUpdate)Minecraft.func_71410_x().field_184132_p.field_191557_f).func_191553_a(time, pos);
                }
            });
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.pathfindingEnabled && event.phase == TickEvent.Phase.END && this.mc.field_71441_e != null && ++this.tickCounter >= 10) {
            WorldServer world;
            this.tickCounter = 0;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer worldServer = world = server != null ? server.func_71218_a(this.mc.field_71441_e.field_73011_w.getDimension()) : null;
            if (world != null) {
                for (Entity entity : world.field_72996_f) {
                    boolean isSamepath;
                    PathNavigate navigator = entity instanceof EntityLiving ? ((EntityLiving)entity).func_70661_as() : null;
                    if (navigator == null || !this.isAnyPlayerWithinRange((World)world, entity, 64.0)) continue;
                    Path path = navigator.func_75505_d();
                    Path old = this.oldPaths.get(entity);
                    if (path == null) continue;
                    boolean bl = isSamepath = old != null && old.func_75876_a(path);
                    if (old != null && isSamepath && old.func_75873_e() == path.func_75873_e()) continue;
                    int id = entity.func_145782_y();
                    float maxDistance = Configs.debugRendererPathfindingEnablePointWidth ? this.getPathPointWidth(navigator) : 0.0f;
                    DebugInfoUtils.sendPacketDebugPath(server, id, path, maxDistance);
                    if (!isSamepath) {
                        PacketBuffer buf = DebugInfoUtils.writePathTobuffer(path);
                        this.oldPaths.put(entity, Path.func_186311_b((PacketBuffer)buf));
                        continue;
                    }
                    if (old == null) continue;
                    old.func_75872_c(path.func_75873_e());
                }
            }
        }
    }

    private boolean isAnyPlayerWithinRange(World world, Entity entity, double range) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            double distSq = player.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(range < 0.0) && !(distSq < range * range)) continue;
            return true;
        }
        return false;
    }

    private float getPathPointWidth(PathNavigate navigator) {
        try {
            return this.field_PathNavigate_maxDistanceToWaypoint.getFloat(navigator);
        }
        catch (Exception e) {
            MiniHud.logger.warn("Failed to reflect PathNavigate#maxDistanceToWaypoint value", (Throwable)e);
            return 0.0f;
        }
    }

    private void toggleDebugRenderers(int mask) {
        block8: for (int i = 0; i < 6; ++i) {
            int bit = mask & 1 << i;
            switch (bit) {
                case 1: {
                    boolean status = this.toggleBoolean(this.field_DebugRenderer_collisionBoxEnabled, this.mc.field_184132_p);
                    this.printMessage("collisions", status ? "ON" : "OFF");
                    continue block8;
                }
                case 2: {
                    boolean status = this.toggleBoolean(this.field_DebugRenderer_heightMapEnabled, this.mc.field_184132_p);
                    this.printMessage("height_map", status ? "ON" : "OFF");
                    continue block8;
                }
                case 4: {
                    boolean status;
                    this.neighborUpdateEnabled = status = this.toggleBoolean(this.field_DebugRenderer_neighborsUpdateEnabled, this.mc.field_184132_p);
                    this.printMessage("neighbor_updates", status ? "ON" : "OFF");
                    continue block8;
                }
                case 8: {
                    boolean status;
                    this.pathfindingEnabled = status = this.toggleBoolean(this.field_DebugRenderer_pathfindingEnabled, this.mc.field_184132_p);
                    this.printMessage("pathfinding", status ? "ON" : "OFF");
                    continue block8;
                }
                case 16: {
                    boolean status = this.toggleBoolean(this.field_DebugRenderer_solidFaceEnabled, this.mc.field_184132_p);
                    this.printMessage("solid_faces", status ? "ON" : "OFF");
                    continue block8;
                }
                case 32: {
                    boolean status = this.toggleBoolean(this.field_DebugRenderer_waterEnabled, this.mc.field_184132_p);
                    this.printMessage("water", status ? "ON" : "OFF");
                    continue block8;
                }
            }
        }
    }

    private void printMessage(String key, Object ... args) {
        this.mc.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)new TextComponentTranslation("minihud.message.toggled_debug_mode." + key, args));
    }

    private void setBoolean(Field field, Object obj, boolean value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            MiniHud.logger.warn("InputEventHandler: Failed set a boolean via a reflected field");
        }
    }

    private boolean toggleBoolean(Field field, Object obj) {
        try {
            boolean newValue = !field.getBoolean(obj);
            field.set(obj, newValue);
            return newValue;
        }
        catch (Exception e) {
            MiniHud.logger.warn("InputEventHandler: Failed to toggle a boolean via a reflected field");
            return false;
        }
    }

    public static boolean isRequiredKeyActive(KeyModifier key) {
        if (key == KeyModifier.NONE) {
            return true;
        }
        if (key == KeyModifier.ALT) {
            return GuiScreen.func_175283_s();
        }
        if (key == KeyModifier.CONTROL) {
            return GuiScreen.func_146271_m();
        }
        if (key == KeyModifier.SHIFT) {
            return GuiScreen.func_146272_n();
        }
        return false;
    }
}

