/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import fi.dy.masa.minihud.config.Configs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class OverlayRenderer {
    public static void renderOverlays(long mask, Entity entity, float partialTicks) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        if ((mask & 0x10000000000L) != 0L) {
            int rx = MathHelper.func_76128_c((double)entity.field_70165_t) & 0xFFFFFE00;
            int rz = MathHelper.func_76128_c((double)entity.field_70161_v) & 0xFFFFFE00;
            BlockPos pos1 = new BlockPos(rx, 0, rz);
            BlockPos pos2 = new BlockPos(rx + 511, 256, rz + 511);
            Minecraft mc = Minecraft.func_71410_x();
            int rangeH = (mc.field_71474_y.field_151451_c + 1) * 16;
            int color = Configs.regionOverlayColor;
            float a = (float)(color >>> 24 & 0xFF) / 255.0f;
            float r = (float)(color >>> 16 & 0xFF) / 255.0f;
            float g = (float)(color >>> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GlStateManager.func_187441_d((float)1.6f);
            OverlayRenderer.renderVerticalWallsOfLinesWithinRange(pos1, pos2, rangeH, 256.0f, 16.0f, 16.0f, entity, r, g, b, a, partialTicks);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderVerticalWallsOfLinesWithinRange(BlockPos posStart, BlockPos posEnd, float rangeH, float rangeV, float lineIntervalH, float lineIntervalV, Entity entity, float r, float g, float b, float a, float partialTicks) {
        int xMin = Math.min(posStart.func_177958_n(), posEnd.func_177958_n());
        int zMin = Math.min(posStart.func_177952_p(), posEnd.func_177952_p());
        int xMax = Math.max(posStart.func_177958_n(), posEnd.func_177958_n()) + 1;
        int zMax = Math.max(posStart.func_177952_p(), posEnd.func_177952_p()) + 1;
        double posX = entity.field_70165_t;
        double posZ = entity.field_70161_v;
        double dx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double dy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double dz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        double yMin = 0.0;
        double yMax = 256.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        OverlayRenderer.renderVerticalWallsOfLinesIfWithinRange(buffer, EnumFacing.Axis.X, zMin, posZ, posX, yMin, yMax, rangeH, lineIntervalH, lineIntervalV, xMin, xMax, dx, dy, dz, r, g, b, a, partialTicks);
        OverlayRenderer.renderVerticalWallsOfLinesIfWithinRange(buffer, EnumFacing.Axis.X, zMax, posZ, posX, yMin, yMax, rangeH, lineIntervalH, lineIntervalV, xMin, xMax, dx, dy, dz, r, g, b, a, partialTicks);
        OverlayRenderer.renderVerticalWallsOfLinesIfWithinRange(buffer, EnumFacing.Axis.Z, xMin, posX, posZ, yMin, yMax, rangeH, lineIntervalH, lineIntervalV, zMin, zMax, dx, dy, dz, r, g, b, a, partialTicks);
        OverlayRenderer.renderVerticalWallsOfLinesIfWithinRange(buffer, EnumFacing.Axis.Z, xMax, posX, posZ, yMin, yMax, rangeH, lineIntervalH, lineIntervalV, zMin, zMax, dx, dy, dz, r, g, b, a, partialTicks);
    }

    private static void renderVerticalWallsOfLinesIfWithinRange(BufferBuilder buffer, EnumFacing.Axis axis, double edge, double posOnEdgeAxis, double posOnPerpAxis, double yMin, double yMax, float rangeH, float lineIntervalH, float lineIntervalV, int perpendicularMin, int perpendicularMax, double dx, double dy, double dz, float r, float g, float b, float a, float partialTicks) {
        if (Math.abs(posOnEdgeAxis - edge) <= (double)rangeH) {
            Tessellator tessellator = Tessellator.func_178181_a();
            double hMin = Math.max(Math.ceil((posOnPerpAxis - (double)rangeH) / (double)lineIntervalH) * (double)lineIntervalV, (double)perpendicularMin);
            double hMax = Math.min(Math.ceil((posOnPerpAxis + (double)rangeH) / (double)lineIntervalH) * (double)lineIntervalV, (double)perpendicularMax);
            float quadAlpha = a / 6.0f;
            switch (axis) {
                case X: {
                    buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    for (double y = yMin; y <= yMax; y += (double)lineIntervalV) {
                        buffer.func_181662_b(hMin - dx, y - dy, edge - dz).func_181666_a(r, g, b, a).func_181675_d();
                        buffer.func_181662_b(hMax - dx, y - dy, edge - dz).func_181666_a(r, g, b, a).func_181675_d();
                    }
                    for (double h = hMin; h <= hMax; h += (double)lineIntervalH) {
                        buffer.func_181662_b(h - dx, yMin - dy, edge - dz).func_181666_a(r, g, b, a).func_181675_d();
                        buffer.func_181662_b(h - dx, yMax - dy, edge - dz).func_181666_a(r, g, b, a).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    buffer.func_181662_b(hMin - dx, yMin - dy, edge - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    buffer.func_181662_b(hMin - dx, yMax - dy, edge - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    buffer.func_181662_b(hMax - dx, yMax - dy, edge - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    buffer.func_181662_b(hMax - dx, yMin - dy, edge - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    tessellator.func_78381_a();
                    break;
                }
                case Z: {
                    buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    for (double y = yMin; y <= yMax; y += (double)lineIntervalV) {
                        buffer.func_181662_b(edge - dx, y - dy, hMin - dz).func_181666_a(r, g, b, a).func_181675_d();
                        buffer.func_181662_b(edge - dx, y - dy, hMax - dz).func_181666_a(r, g, b, a).func_181675_d();
                    }
                    for (double h = hMin; h <= hMax; h += (double)lineIntervalH) {
                        buffer.func_181662_b(edge - dx, yMin - dy, h - dz).func_181666_a(r, g, b, a).func_181675_d();
                        buffer.func_181662_b(edge - dx, yMax - dy, h - dz).func_181666_a(r, g, b, a).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    buffer.func_181662_b(edge - dx, yMin - dy, hMin - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    buffer.func_181662_b(edge - dx, yMax - dy, hMin - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    buffer.func_181662_b(edge - dx, yMax - dy, hMax - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    buffer.func_181662_b(edge - dx, yMin - dy, hMax - dz).func_181666_a(r, g, b, quadAlpha).func_181675_d();
                    tessellator.func_78381_a();
                    break;
                }
            }
        }
    }
}

