/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import fi.dy.masa.minihud.MiniHud;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.event.InputEventHandler;
import fi.dy.masa.minihud.event.OverlayRenderer;
import fi.dy.masa.minihud.util.MethodHandleUtils;
import java.lang.invoke.MethodHandle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderEventHandler {
    public static final int MASK_FPS = 1;
    public static final int MASK_TIME_REAL = 2;
    public static final int MASK_TIME_TICKS = 4;
    public static final int MASK_TIME_MC = 8;
    public static final int MASK_COORDINATES = 16;
    public static final int MASK_DIMENSION = 32;
    public static final int MASK_BLOCK = 64;
    public static final int MASK_BLOCK_IN_CHUNK = 128;
    public static final int MASK_FACING = 256;
    public static final int MASK_LIGHT = 512;
    public static final int MASK_YAW = 1024;
    public static final int MASK_PITCH = 2048;
    public static final int MASK_SPEED = 4096;
    public static final int MASK_CHUNK_SECTIONS = 8192;
    public static final int MASK_CHUNK_SECTIONS_LINE = 16384;
    public static final int MASK_CHUNK_UPDATES = 32768;
    public static final int MASK_PARTICLE_COUNT = 65536;
    public static final int MASK_DIFFICULTY = 131072;
    public static final int MASK_BIOME = 262144;
    public static final int MASK_BIOME_REGISTRY_NAME = 524288;
    public static final int MASK_ENTITIES = 0x100000;
    public static final int MASK_SLIME_CHUNK = 0x200000;
    public static final int MASK_LOOKING_AT_ENTITY = 0x400000;
    public static final int MASK_LOOKING_AT_ENTITY_REGNAME = 0x800000;
    public static final int MASK_LOOKING_AT_BLOCK = 0x1000000;
    public static final int MASK_LOOKING_AT_BLOCK_CHUNK = 0x2000000;
    public static final int MASK_BLOCK_PROPERTIES = 0x4000000;
    public static final int MASK_CHUNK = 0x8000000;
    public static final int MASK_REGION_FILE = 0x10000000;
    public static final long MASK_REGION_OVERLAY = 0x10000000000L;
    private static RenderEventHandler instance;
    private final MethodHandle methodHandle_RenderGlobal_getRenderedChunks;
    private final Minecraft mc;
    private final Date date;
    private final Random rand = new Random();
    private boolean enabled;
    private long mask;
    private int fps;
    private int fpsCounter;
    private long fpsUpdateTime = Minecraft.func_71386_F();
    private long infoUpdateTime;
    private long serverSeed;
    private boolean serverSeedValid;
    private int addedTypes;
    private final List<StringHolder> lines = new ArrayList<StringHolder>();

    public RenderEventHandler() {
        this.mc = Minecraft.func_71410_x();
        this.date = new Date();
        this.methodHandle_RenderGlobal_getRenderedChunks = this.getMethodHandle_getRenderedChunks();
    }

    private MethodHandle getMethodHandle_getRenderedChunks() {
        try {
            return MethodHandleUtils.getMethodHandleVirtual(RenderGlobal.class, new String[]{"func_184382_g", "getRenderedChunks"}, new Class[0]);
        }
        catch (MethodHandleUtils.UnableToFindMethodHandleException e) {
            MiniHud.logger.error("Failed to get a MethodHandle for RenderGlobal#getRenderedChunks()", (Throwable)e);
            return null;
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        long currentTime;
        if (!this.enabled || event.getType() != RenderGameOverlayEvent.ElementType.ALL || this.mc.field_71474_y.field_74330_P || this.mc.field_71439_g == null || Configs.requireSneak && !this.mc.field_71439_g.func_70093_af() || Configs.requireHoldingKey && !InputEventHandler.isRequiredKeyActive(Configs.requiredKey)) {
            return;
        }
        if ((this.mask & 1L) != 0L) {
            this.updateFps();
        }
        if ((currentTime = System.currentTimeMillis()) - this.infoUpdateTime >= 50L) {
            this.updateLines(this.mask);
            this.infoUpdateTime = currentTime;
        }
        this.renderText(Configs.textPosX, Configs.textPosY, this.lines);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.enabled && (this.mask & 0xFFFFFFFF00000000L) != 0L && this.mc.field_71439_g != null) {
            OverlayRenderer.renderOverlays(this.mask, (Entity)this.mc.field_71439_g, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.serverSeedValid = false;
    }

    @SubscribeEvent
    public void onChatMessage(ClientChatReceivedEvent event) {
        ITextComponent message = event.getMessage();
        if (message instanceof TextComponentTranslation) {
            TextComponentTranslation text = (TextComponentTranslation)message;
            if ("commands.seed.success".equals(text.func_150268_i())) {
                try {
                    this.serverSeed = Long.parseLong(text.func_150271_j()[0].toString());
                    this.serverSeedValid = true;
                    MiniHud.logger.info("Received world seed from the vanilla /seed command: {}", (Object)this.serverSeed);
                }
                catch (Exception e) {
                    MiniHud.logger.warn("Failed to read the world seed from '{}'", text.func_150271_j()[0], (Object)e);
                }
            } else if ("jed.commands.seed.success".equals(text.func_150268_i())) {
                try {
                    this.serverSeed = Long.parseLong(text.func_150271_j()[1].toString());
                    this.serverSeedValid = true;
                    MiniHud.logger.info("Received world seed from the JED '/jed seed' command: {}", (Object)this.serverSeed);
                }
                catch (Exception e) {
                    MiniHud.logger.warn("Failed to read the world seed from '{}'", text.func_150271_j()[1], (Object)e);
                }
            }
        }
    }

    public static RenderEventHandler getInstance() {
        if (instance == null) {
            instance = new RenderEventHandler();
        }
        return instance;
    }

    public void setEnabledMask(int mask) {
        this.mask = mask;
    }

    public void xorEnabledMask(long mask) {
        this.mask ^= mask;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
    }

    private void updateFps() {
        ++this.fpsCounter;
        if (Minecraft.func_71386_F() >= this.fpsUpdateTime + 1000L) {
            this.fpsUpdateTime = Minecraft.func_71386_F();
            this.fps = this.fpsCounter;
            this.fpsCounter = 0;
        }
    }

    private void updateLines(long enabledMask) {
        this.lines.clear();
        this.addedTypes = 0;
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (int i = 0; i < 32; ++i) {
            long mask = 1 << i;
            if ((enabledMask & mask) == 0L) continue;
            positions.add(new LinePos(Configs.getLinePositionFor(mask), mask));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            this.addLine(pos.type);
        }
        if (Configs.sortLinesByLength) {
            Collections.sort(this.lines);
            if (Configs.sortLinesReversed) {
                Collections.reverse(this.lines);
            }
        }
    }

    private void addLine(String text) {
        this.lines.add(new StringHolder(text));
    }

    private void addLine(long type) {
        Entity entity = this.mc.func_175606_aa();
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v);
        switch ((int)type) {
            case 1: {
                this.addLine(String.format("%d fps", this.fps));
                break;
            }
            case 2: {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(Configs.dateFormatReal);
                    this.date.setTime(System.currentTimeMillis());
                    this.addLine(sdf.format(this.date));
                }
                catch (Exception e) {
                    this.addLine("Date formatting failed - Invalid date format string?");
                }
                break;
            }
            case 4: {
                long current = entity.func_130014_f_().func_72820_D();
                long total = entity.func_130014_f_().func_82737_E();
                this.addLine(String.format("World time: %5d - total: %d", current, total));
                break;
            }
            case 8: {
                try {
                    long timeDay = (int)entity.func_130014_f_().func_72820_D();
                    int day = (int)(timeDay / 24000L) + 1;
                    int hour = (int)(timeDay / 1000L + 6L) % 24;
                    int min = (int)((double)timeDay / 16.666666) % 60;
                    int sec = (int)((double)timeDay / 0.277777) % 60;
                    String str = Configs.dateFormatMinecraft;
                    str = str.replace("{DAY}", String.format("%d", day));
                    str = str.replace("{HOUR}", String.format("%02d", hour));
                    str = str.replace("{MIN}", String.format("%02d", min));
                    str = str.replace("{SEC}", String.format("%02d", sec));
                    this.addLine(str);
                }
                catch (Exception e) {
                    this.addLine("Date formatting failed - Invalid date format string?");
                }
                break;
            }
            case 16: 
            case 32: {
                if ((this.addedTypes & 0x30) != 0) break;
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if ((this.mask & 0x10L) != 0L) {
                    if (Configs.coordinateFormatCustomized) {
                        try {
                            str.append(String.format(Configs.coordinateFormat, entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v));
                        }
                        catch (Exception e) {
                            str.append("broken coordinate format string!");
                        }
                    } else {
                        str.append(String.format("XYZ: %.2f / %.4f / %.2f", entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v));
                    }
                    pre = " / ";
                }
                if ((this.mask & 0x20L) != 0L) {
                    str.append(String.format(String.format("%sdim: %d", pre, entity.func_130014_f_().field_73011_w.getDimension()), new Object[0]));
                }
                this.addLine(str.toString());
                this.addedTypes |= 0x30;
                break;
            }
            case 64: 
            case 0x8000000: 
            case 0x10000000: {
                if ((this.addedTypes & 0x18000040) != 0) break;
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if ((this.mask & 0x40L) != 0L) {
                    str.append(String.format("Block: %d, %d, %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    pre = " / ";
                }
                if ((this.mask & 0x8000000L) != 0L) {
                    str.append(pre).append(String.format("Sub-Chunk: %d, %d, %d", pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4));
                    pre = " / ";
                }
                if ((this.mask & 0x10000000L) != 0L) {
                    str.append(pre).append(String.format("Region: r.%d.%d", pos.func_177958_n() >> 9, pos.func_177952_p() >> 9));
                    pre = " / ";
                }
                this.addLine(str.toString());
                this.addedTypes |= 0x18000040;
                break;
            }
            case 128: {
                this.addLine(String.format("Block: %d, %d, %d in Sub-Chunk: %d, %d, %d", pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4));
                break;
            }
            case 256: {
                EnumFacing facing = entity.func_174811_aO();
                String str = "Invalid";
                switch (facing) {
                    case NORTH: {
                        str = "Negative Z";
                        break;
                    }
                    case SOUTH: {
                        str = "Positive Z";
                        break;
                    }
                    case WEST: {
                        str = "Negative X";
                        break;
                    }
                    case EAST: {
                        str = "Positive X";
                        break;
                    }
                }
                this.addLine(String.format("Facing: %s (%s)", facing, str));
                break;
            }
            case 512: {
                Chunk chunk;
                if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || !this.mc.field_71441_e.func_175667_e(pos) || (chunk = this.mc.field_71441_e.func_175726_f(pos)).func_76621_g()) break;
                this.addLine(String.format("Light: %d (block: %d, sky: %d)", chunk.func_177443_a(pos, 0), chunk.func_177413_a(EnumSkyBlock.BLOCK, pos), chunk.func_177413_a(EnumSkyBlock.SKY, pos)));
                break;
            }
            case 1024: 
            case 2048: 
            case 4096: {
                if ((this.addedTypes & 0x1C00) != 0) break;
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if ((this.mask & 0x400L) != 0L) {
                    str.append(String.format("%syaw: %.1f", pre, Float.valueOf(MathHelper.func_76142_g((float)entity.field_70177_z))));
                    pre = " / ";
                }
                if ((this.mask & 0x800L) != 0L) {
                    str.append(String.format("%spitch: %.1f", pre, Float.valueOf(MathHelper.func_76142_g((float)entity.field_70125_A))));
                    pre = " / ";
                }
                if ((this.mask & 0x1000L) != 0L) {
                    double dx = entity.field_70165_t - entity.field_70142_S;
                    double dy = entity.field_70163_u - entity.field_70137_T;
                    double dz = entity.field_70161_v - entity.field_70136_U;
                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    str.append(String.format("%sspeed: %.3f m/s", pre, dist * 20.0));
                    pre = " / ";
                }
                this.addLine(str.toString());
                this.addedTypes |= 0x1C00;
                break;
            }
            case 8192: {
                this.addLine(String.format("C: %d", this.getRenderedChunks()));
                break;
            }
            case 16384: {
                this.addLine(this.mc.field_71438_f.func_72735_c());
                break;
            }
            case 32768: {
                this.addLine(String.format("Chunk updates: %d", RenderChunk.field_178592_a));
                break;
            }
            case 65536: {
                this.addLine(String.format("P: %s", this.mc.field_71452_i.func_78869_b()));
                break;
            }
            case 131072: {
                EntityPlayerMP player;
                if (!this.mc.field_71441_e.func_175667_e(pos)) break;
                DifficultyInstance diff = this.mc.field_71441_e.func_175649_E(pos);
                if (this.mc.func_71387_A() && this.mc.func_71401_C() != null && (player = this.mc.func_71401_C().func_184103_al().func_177451_a(this.mc.field_71439_g.func_110124_au())) != null) {
                    diff = player.field_70170_p.func_175649_E(new BlockPos((Entity)player));
                }
                this.addLine(String.format("Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(diff.func_180168_b()), Float.valueOf(diff.func_180170_c()), this.mc.field_71441_e.func_72820_D() / 24000L));
                break;
            }
            case 262144: {
                Chunk chunk;
                if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || !this.mc.field_71441_e.func_175667_e(pos) || (chunk = this.mc.field_71441_e.func_175726_f(pos)).func_76621_g()) break;
                this.addLine("Biome: " + chunk.func_177411_a(pos, this.mc.field_71441_e.func_72959_q()).func_185359_l());
                break;
            }
            case 524288: {
                Chunk chunk;
                if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || !this.mc.field_71441_e.func_175667_e(pos) || (chunk = this.mc.field_71441_e.func_175726_f(pos)).func_76621_g()) break;
                this.addLine("Biome reg name: " + chunk.func_177411_a(pos, this.mc.field_71441_e.func_72959_q()).getRegistryName().toString());
                break;
            }
            case 0x100000: {
                String ent = this.mc.field_71438_f.func_72723_d();
                int p = ent.indexOf(",");
                if (p != -1) {
                    ent = ent.substring(0, p);
                }
                this.addLine(ent);
                break;
            }
            case 0x200000: {
                boolean valid = false;
                long seed = 0L;
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server != null && server.func_71264_H()) {
                    WorldServer world = DimensionManager.getWorld((int)entity.func_130014_f_().field_73011_w.getDimension());
                    seed = world != null ? world.func_72905_C() : 0L;
                    valid = world != null;
                } else if (this.serverSeedValid) {
                    seed = this.serverSeed;
                    valid = true;
                }
                String result = valid ? (this.canSlimeSpawnAt(entity.field_70165_t, entity.field_70161_v, seed) ? TextFormatting.GREEN.toString() + "YES" + TextFormatting.RESET.toString() + TextFormatting.WHITE.toString() : TextFormatting.RED.toString() + "NO" + TextFormatting.RESET.toString() + TextFormatting.WHITE.toString()) : "<world seed not known>";
                this.addLine("Slime chunk: " + result);
                break;
            }
            case 0x400000: {
                if (this.mc.field_71476_x == null || this.mc.field_71476_x.field_72313_a != RayTraceResult.Type.ENTITY || this.mc.field_71476_x.field_72308_g == null) break;
                Entity target = this.mc.field_71476_x.field_72308_g;
                if (target instanceof EntityLivingBase) {
                    EntityLivingBase living = (EntityLivingBase)target;
                    this.addLine(String.format("Entity: %s - HP: %.1f / %.1f", target.func_70005_c_(), Float.valueOf(living.func_110143_aJ()), Float.valueOf(living.func_110138_aP())));
                    break;
                }
                this.addLine(String.format("Entity: %s", target.func_70005_c_()));
                break;
            }
            case 0x800000: {
                ResourceLocation regName;
                if (this.mc.field_71476_x == null || this.mc.field_71476_x.field_72313_a != RayTraceResult.Type.ENTITY || this.mc.field_71476_x.field_72308_g == null || (regName = EntityList.func_191301_a((Entity)this.mc.field_71476_x.field_72308_g)) == null) break;
                this.addLine(String.format("Entity reg name: %s", regName.toString()));
                break;
            }
            case 0x1000000: 
            case 0x2000000: {
                if ((this.addedTypes & 0x3000000) != 0 || this.mc.field_71476_x == null || this.mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK || this.mc.field_71476_x.func_178782_a() == null) break;
                BlockPos lookPos = this.mc.field_71476_x.func_178782_a();
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if ((this.mask & 0x1000000L) != 0L) {
                    str.append(String.format("Looking at block: %d %d %d", lookPos.func_177958_n(), lookPos.func_177956_o(), lookPos.func_177952_p()));
                    pre = " // ";
                }
                if ((this.mask & 0x2000000L) != 0L) {
                    str.append(pre).append(String.format("Block: %d %d %d within chunk section: %d %d %d", lookPos.func_177958_n() & 0xF, lookPos.func_177956_o() & 0xF, lookPos.func_177952_p() & 0xF, lookPos.func_177958_n() >> 4, lookPos.func_177956_o() >> 4, lookPos.func_177952_p() >> 4));
                }
                this.addLine(str.toString());
                this.addedTypes |= 0x3000000;
                break;
            }
            case 0x4000000: {
                this.getBlockProperties();
            }
        }
    }

    private <T extends Comparable<T>> void getBlockProperties() {
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && this.mc.field_71476_x.func_178782_a() != null) {
            BlockPos posLooking = this.mc.field_71476_x.func_178782_a();
            IBlockState state = this.mc.field_71441_e.func_180495_p(posLooking);
            if (this.mc.field_71441_e.func_175624_G() != WorldType.field_180272_g) {
                state = state.func_185899_b((IBlockAccess)this.mc.field_71441_e, posLooking);
            }
            this.lines.add(new StringHolder(String.valueOf(Block.field_149771_c.func_177774_c((Object)state.func_177230_c()))));
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                IProperty property = (IProperty)entry.getKey();
                Comparable value = (Comparable)entry.getValue();
                String valueName = property.func_177702_a(value);
                if (Boolean.TRUE.equals(value)) {
                    valueName = TextFormatting.GREEN + valueName;
                } else if (Boolean.FALSE.equals(value)) {
                    valueName = TextFormatting.RED + valueName;
                } else if (Integer.class.equals((Object)property.func_177699_b())) {
                    valueName = TextFormatting.AQUA + valueName;
                }
                this.lines.add(new StringHolder(property.func_177701_a() + ": " + valueName));
            }
        }
    }

    private void renderText(int xOff, int yOff, List<StringHolder> lines) {
        double scale = Configs.activeFontScale;
        if (scale != 1.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        }
        FontRenderer fontRenderer = this.mc.field_71466_p;
        ScaledResolution res = new ScaledResolution(this.mc);
        int x = xOff;
        int y = yOff;
        switch (Configs.hudAlignment) {
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                y = (int)((double)(res.func_78328_b() + 4) / scale) - yOff - lines.size() * (fontRenderer.field_78288_b + 2);
                break;
            }
            case CENTER: {
                y = (int)((double)(res.func_78328_b() / 2 + 4) / scale) - yOff - lines.size() * (fontRenderer.field_78288_b + 2) / 2;
                break;
            }
        }
        for (StringHolder holder : lines) {
            String line = holder.str;
            switch (Configs.hudAlignment) {
                case BOTTOM_RIGHT: 
                case TOP_RIGHT: {
                    x = (int)((double)res.func_78326_a() / scale) - fontRenderer.func_78256_a(line) - xOff;
                    break;
                }
                case CENTER: {
                    x = (int)((double)(res.func_78326_a() / 2) / scale) - fontRenderer.func_78256_a(line) / 2 - xOff;
                    break;
                }
            }
            if (Configs.useTextBackground) {
                Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + fontRenderer.func_78256_a(line) + 2), (int)(y + fontRenderer.field_78288_b), (int)Configs.textBackgroundColor);
            }
            if (Configs.useFontShadow) {
                fontRenderer.func_175063_a(line, (float)x, (float)y, Configs.fontColor);
            } else {
                fontRenderer.func_78276_b(line, x, y, Configs.fontColor);
            }
            y += fontRenderer.field_78288_b + 2;
        }
        if (scale != 1.0) {
            GlStateManager.func_179121_F();
        }
    }

    private boolean canSlimeSpawnAt(double posX, double posZ, long worldSeed) {
        int chunkX = (int)Math.floor(posX / 16.0);
        int chunkZ = (int)Math.floor(posZ / 16.0);
        long slimeSeed = 987234911L;
        long rngSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ slimeSeed;
        this.rand.setSeed(rngSeed);
        return this.rand.nextInt(10) == 0;
    }

    private int getRenderedChunks() {
        try {
            return this.methodHandle_RenderGlobal_getRenderedChunks.invokeExact(this.mc.field_71438_f);
        }
        catch (Throwable t) {
            MiniHud.logger.error("Error while trying invoke RenderGlobal#getRenderedChunks()", t);
            return -1;
        }
    }

    public static enum HudAlignment {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER;


        public static HudAlignment fromString(String name) {
            for (HudAlignment al : HudAlignment.values()) {
                if (!al.name().equalsIgnoreCase(name)) continue;
                return al;
            }
            return TOP_LEFT;
        }
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final long type;

        private LinePos(int position, long type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

