/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.server.MinecraftServer;

public class DebugInfoUtils {
    public static void sendPacketDebugPath(MinecraftServer server, int entityId, Path path, float maxDistance) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeInt(entityId);
        buffer.writeFloat(maxDistance);
        DebugInfoUtils.writePathToBuffer(buffer, path);
        SPacketCustomPayload packet = new SPacketCustomPayload("MC|DebugPath", buffer);
        server.func_184103_al().func_148540_a((Packet)packet);
    }

    private static void writePathPointToBuffer(PacketBuffer buf, PathPoint point) {
        buf.writeInt(point.field_75839_a);
        buf.writeInt(point.field_75837_b);
        buf.writeInt(point.field_75838_c);
        buf.writeFloat(point.field_186284_j);
        buf.writeFloat(point.field_186285_k);
        buf.writeFloat(point.field_186286_l);
        buf.writeBoolean(point.field_75842_i);
        buf.writeInt(point.field_186287_m.ordinal());
        buf.writeFloat(point.field_75834_g);
    }

    public static PacketBuffer writePathTobuffer(Path path) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        DebugInfoUtils.writePathToBuffer(buffer, path);
        return buffer;
    }

    private static void writePathToBuffer(PacketBuffer buf, Path path) {
        PathPoint target = path.func_75870_c();
        if (target != null) {
            buf.writeInt(path.func_75873_e());
            DebugInfoUtils.writePathPointToBuffer(buf, target);
            int countTotal = path.func_75874_d();
            ArrayList<PathPoint> openSet = new ArrayList<PathPoint>();
            ArrayList<PathPoint> closedSet = new ArrayList<PathPoint>();
            ArrayList<PathPoint> allSet = new ArrayList<PathPoint>();
            for (int i = 0; i < countTotal; ++i) {
                PathPoint point = path.func_75877_a(i);
                if (point.field_186287_m.func_186289_a() < 0.0f) {
                    closedSet.add(point);
                } else if (point.field_186287_m.func_186289_a() > 0.0f) {
                    openSet.add(point);
                }
                allSet.add(point);
            }
            buf.writeInt(allSet.size());
            for (PathPoint point : allSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(openSet.size());
            for (PathPoint point : openSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(closedSet.size());
            for (PathPoint point : closedSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
        }
    }
}

