/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.ipp;

import com.google.common.collect.Maps;
import com.hexagram2021.ipp.common.IPPContent;
import com.hexagram2021.ipp.common.register.IPPBlockTags;
import com.hexagram2021.ipp.common.register.IPPInstruments;
import com.mojang.logging.LogUtils;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="ipp")
public class InstrumentPlusPlus {
    public static final String MODID = "ipp";
    public static final Logger LOGGER = LogUtils.getLogger();
    private final IdentityHashMap<Block, NoteBlockInstrument> backups = Maps.newIdentityHashMap();

    public InstrumentPlusPlus() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DeferredWorkQueue queue = (DeferredWorkQueue)DeferredWorkQueue.lookup(Optional.of(ModLoadingStage.CONSTRUCT)).orElseThrow();
        Consumer<Runnable> runLater = job -> queue.enqueueWork(ModLoadingContext.get().getActiveContainer(), job);
        IPPContent.modConstruction(modBus, runLater);
        MinecraftForge.EVENT_BUS.addListener(this::onTagsUpdated);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onTagsUpdated(TagsUpdatedEvent event) {
        ForgeRegistries.BLOCKS.forEach(block -> {
            if (block.m_204297_().m_203656_(IPPBlockTags.BASALTS)) {
                this.setInstrument((Block)block, IPPInstruments.BASSOON);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.BLACKSTONES)) {
                this.setInstrument((Block)block, IPPInstruments.CLARINET);
            } else if (block.equals(Blocks.f_50184_) || block.equals(Blocks.f_50183_)) {
                this.setInstrument((Block)block, IPPInstruments.CYMBAL);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.SNOWS)) {
                this.setInstrument((Block)block, IPPInstruments.ELECTRIC_CLEAN);
            } else if (block.equals(Blocks.f_50134_)) {
                this.setInstrument((Block)block, IPPInstruments.ELECTRIC_OVERDRIVEN);
            } else if (block.m_204297_().m_203656_(BlockTags.f_13051_) || block.m_204297_().m_203656_(IPPBlockTags.DEAD_CORAL_BLOCKS)) {
                this.setInstrument((Block)block, IPPInstruments.ERHU);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.COPPER_BLOCKS)) {
                this.setInstrument((Block)block, IPPInstruments.FRENCH_HORN);
            } else if (block.equals(Blocks.f_152544_)) {
                this.setInstrument((Block)block, IPPInstruments.GUQIN);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.END_STONES)) {
                this.setInstrument((Block)block, IPPInstruments.KONGHOU);
            } else if (block.equals(Blocks.f_50493_)) {
                this.setInstrument((Block)block, IPPInstruments.SUONA);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.NETHER_BRICKS)) {
                this.setInstrument((Block)block, IPPInstruments.TIMPANI);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.CUT_COPPER_BLOCKS)) {
                this.setInstrument((Block)block, IPPInstruments.TRUMPET);
            } else if (block.equals(Blocks.f_49994_)) {
                this.setInstrument((Block)block, IPPInstruments.TUBA);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.GLAZED_TERRACOTTA)) {
                this.setInstrument((Block)block, IPPInstruments.VIOLA);
            } else if (block.m_204297_().m_203656_(BlockTags.f_198156_)) {
                this.setInstrument((Block)block, IPPInstruments.VIOLIN);
            } else if (block.m_204297_().m_203656_(IPPBlockTags.AMETHYST_BLOCKS)) {
                this.setInstrument((Block)block, IPPInstruments.YANGQIN);
            } else if (this.backups.containsKey(block)) {
                this.setInstrument((Block)block, this.backups.get(block));
                this.backups.remove(block);
            }
        });
    }

    private void setInstrument(Block block, NoteBlockInstrument instrument) {
        if (!this.backups.containsKey(block)) {
            this.backups.put(block, block.m_49966_().m_280603_());
        }
        block.m_49965_().m_61056_().forEach(blockState -> {
            blockState.f_279617_ = instrument;
        });
    }
}

