/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.ipp.common.compat.jei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hexagram2021.ipp.InstrumentPlusPlus;
import com.hexagram2021.ipp.common.compat.jei.MusicalInstrumentCategory;
import com.hexagram2021.ipp.common.crafting.MusicalInstrumentShadowRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JeiHelper
implements IModPlugin {
    public static final RecipeType<MusicalInstrumentShadowRecipe> INSTRUMENTS = new RecipeType(MusicalInstrumentCategory.UID, MusicalInstrumentShadowRecipe.class);
    private static final ResourceLocation UID = new ResourceLocation("ipp", "main");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MusicalInstrumentCategory(guiHelper)});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        InstrumentPlusPlus.LOGGER.info("Adding EC recipes to JEI!!");
        registration.addRecipes(INSTRUMENTS, this.getRecipes());
    }

    private List<MusicalInstrumentShadowRecipe> getRecipes() {
        ArrayList shadows = Lists.newArrayList();
        HashMap bottoms = Maps.newHashMap();
        ForgeRegistries.BLOCKS.forEach(block -> {
            ItemStack itemStack = new ItemStack((ItemLike)block.m_5456_());
            if (!itemStack.m_41619_()) {
                NoteBlockInstrument instrument = block.m_49966_().m_280603_();
                bottoms.computeIfAbsent(instrument, ignored -> Lists.newArrayList()).add(itemStack);
            }
        });
        bottoms.forEach((instrument, blocks) -> {
            Ingredient bottom = Ingredient.m_43921_(blocks.stream());
            ResourceLocation id = new ResourceLocation("ipp", "instrument/" + instrument.m_7912_());
            shadows.add(new MusicalInstrumentShadowRecipe(id, bottom, (NoteBlockInstrument)instrument));
        });
        return shadows;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_41859_), new RecipeType[]{INSTRUMENTS});
    }
}

