/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.crop;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CropTier {
    public static final CropTier ELEMENTAL = new CropTier(new ResourceLocation("mysticalagriculture", "elemental"), 1, 7638528, ChatFormatting.YELLOW);
    public static final CropTier ONE = new CropTier(new ResourceLocation("mysticalagriculture", "1"), 1, 7638528, ChatFormatting.YELLOW);
    public static final CropTier TWO = new CropTier(new ResourceLocation("mysticalagriculture", "2"), 2, 35875, ChatFormatting.GREEN);
    public static final CropTier THREE = new CropTier(new ResourceLocation("mysticalagriculture", "3"), 3, 12011776, ChatFormatting.GOLD);
    public static final CropTier FOUR = new CropTier(new ResourceLocation("mysticalagriculture", "4"), 4, 32731, ChatFormatting.AQUA);
    public static final CropTier FIVE = new CropTier(new ResourceLocation("mysticalagriculture", "5"), 5, 0xC40000, ChatFormatting.RED);
    private final ResourceLocation id;
    private final int value;
    private final int color;
    private final ChatFormatting textColor;
    private Supplier<? extends Block> farmland;
    private Supplier<? extends Item> essence;
    private MutableComponent displayName;
    private boolean fertilizable;
    private boolean secondarySeedDrop;

    public CropTier(ResourceLocation id, int value, int color, ChatFormatting textColor) {
        this.id = id;
        this.value = value;
        this.color = color;
        this.textColor = textColor;
        this.fertilizable = true;
        this.secondarySeedDrop = true;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.id.m_135815_();
    }

    public String getModId() {
        return this.id.m_135827_();
    }

    public int getValue() {
        return this.value;
    }

    public int getColor() {
        return this.color;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    public Block getFarmland() {
        return this.farmland == null ? null : this.farmland.get();
    }

    public CropTier setFarmland(Supplier<? extends Block> farmland) {
        this.farmland = farmland;
        return this;
    }

    public Item getEssence() {
        return this.essence == null ? null : this.essence.get();
    }

    public CropTier setEssence(Supplier<? extends Item> essence) {
        this.essence = essence;
        return this;
    }

    public boolean isEffectiveFarmland(Block block) {
        return this.farmland.get() == block;
    }

    public MutableComponent getDisplayName() {
        if (this.displayName != null) {
            return this.displayName.m_130940_(this.getTextColor());
        }
        return new TranslatableComponent(String.format("cropTier.%s.%s", this.getModId(), this.getName())).m_130940_(this.getTextColor());
    }

    public CropTier setDisplayName(MutableComponent name) {
        this.displayName = name;
        return this;
    }

    public boolean isFertilizable() {
        return this.fertilizable;
    }

    public CropTier setFertilizable(boolean fertilizable) {
        this.fertilizable = fertilizable;
        return this;
    }

    public boolean hasSecondarySeedDrop() {
        return this.secondarySeedDrop;
    }

    public CropTier setSecondarySeedDrop(boolean secondarySeedDrop) {
        this.secondarySeedDrop = secondarySeedDrop;
        return this;
    }
}

