/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.cucumber.client.model.RetextureableBlockModelWrapper;
import com.blakebr0.cucumber.client.model.RetextureableItemModelWrapper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public final class ModelHandler {
    private static final ResourceLocation MISSING_NO = new ResourceLocation("minecraft", "missingno");
    private static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("minecraft", "textures/atlas/blocks.png");

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        if (!((Boolean)ModConfigs.ANIMATED_GROWTH_ACCELERATORS.get()).booleanValue()) {
            for (String type : new String[]{"block", "item"}) {
                for (String tier : new String[]{"inferium", "prudentium", "tertium", "imperium", "supremium"}) {
                    ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", String.format("%s/%s_growth_accelerator_static", type, tier)));
                }
            }
        }
        for (int i = 0; i < 8; ++i) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_" + i));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_" + i));
        }
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map registry = event.getModelRegistry();
        ForgeModelBakery bakery = event.getModelLoader();
        if (!((Boolean)ModConfigs.ANIMATED_GROWTH_ACCELERATORS.get()).booleanValue()) {
            for (String tier : new String[]{"inferium", "prudentium", "tertium", "imperium", "supremium"}) {
                String loc = String.format("%s_growth_accelerator", tier);
                BakedModel blockModel = (BakedModel)registry.get(new ResourceLocation("mysticalagriculture", "block/" + loc + "_static"));
                BakedModel itemModel = (BakedModel)registry.get(new ResourceLocation("mysticalagriculture", "item/" + loc + "_static"));
                registry.replace(new ModelResourceLocation("mysticalagriculture:" + loc), blockModel);
                registry.replace(new ModelResourceLocation("mysticalagriculture:" + loc, "inventory"), itemModel);
            }
        }
        HashMap cropModels = new HashMap();
        HashMap cropModelsGrown = new HashMap();
        CropRegistry.getInstance().getTypes().forEach(type -> {
            cropModels.put(type.getId(), (BakedModel[])IntStream.range(0, 7).mapToObj(i -> (BakedModel)registry.get(new ResourceLocation(type.getStemModel() + "_" + i))).toArray(BakedModel[]::new));
            UnbakedModel model = bakery.m_119341_(new ResourceLocation(type.getStemModel() + "_7"));
            RetextureableBlockModelWrapper modelWrapper = new RetextureableBlockModelWrapper((BlockModel)model);
            cropModelsGrown.put(type.getId(), modelWrapper);
        });
        Function<Material, TextureAtlasSprite> getSprite = arg_0 -> ((AtlasSet)bakery.getSpriteMap()).m_117971_(arg_0);
        ItemModelGenerator generator = new ItemModelGenerator();
        UnbakedModel essenceModel = bakery.m_119341_(new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        RetextureableItemModelWrapper essenceModelWrapper = new RetextureableItemModelWrapper((BlockModel)essenceModel);
        UnbakedModel seedsModel = bakery.m_119341_(new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
        RetextureableItemModelWrapper seedsModelWrapper = new RetextureableItemModelWrapper((BlockModel)seedsModel);
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            ModelResourceLocation location;
            BakedModel bakedModel;
            ItemNameBlockItem seeds;
            Item essence;
            BakedModel bakedModel2;
            ModelResourceLocation location2;
            CropTextures textures = crop.getTextures();
            CropBlock crops = crop.getCropBlock();
            if (crops.getRegistryName() != null) {
                for (int i = 0; i < 7; ++i) {
                    location2 = new ModelResourceLocation(crops.getRegistryName(), "age=" + i);
                    bakedModel2 = (BakedModel)registry.get(location2);
                    if (bakedModel2 != null && !bakedModel2.getParticleIcon((IModelData)EmptyModelData.INSTANCE).m_118413_().equals((Object)MISSING_NO)) continue;
                    ResourceLocation type = crop.getType().getId();
                    registry.replace(location2, ((BakedModel[])cropModels.get(type))[i]);
                }
                ModelResourceLocation location3 = new ModelResourceLocation(crops.getRegistryName(), "age=7");
                BakedModel bakedModel3 = (BakedModel)registry.get(location3);
                if (bakedModel3 == null || bakedModel3.getParticleIcon((IModelData)EmptyModelData.INSTANCE).m_118413_().equals((Object)MISSING_NO)) {
                    ResourceLocation texture = crop.getTextures().getFlowerTexture();
                    RetextureableBlockModelWrapper cropRetexturedModel = ((RetextureableBlockModelWrapper)cropModelsGrown.get(crop.getType().getId())).retexture(ImmutableMap.of((Object)"flower", (Object)texture.toString()));
                    BakedModel cropBakedModel = cropRetexturedModel.m_7611_((ModelBakery)bakery, getSprite, (ModelState)BlockModelRotation.X0_Y0, (ResourceLocation)location3);
                    registry.replace(location3, cropBakedModel);
                }
            }
            if ((essence = crop.getEssenceItem()).getRegistryName() != null && ((bakedModel2 = (BakedModel)registry.get(location2 = new ModelResourceLocation(essence.getRegistryName(), "inventory"))) == null || bakedModel2.getParticleIcon((IModelData)EmptyModelData.INSTANCE).m_118413_().equals((Object)MISSING_NO))) {
                ResourceLocation texture = textures.getEssenceTexture();
                RetextureableItemModelWrapper retexture = essenceModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
                BlockModel generated = generator.m_111670_(getSprite, (BlockModel)retexture);
                BakedModel model = generated.m_111449_((ModelBakery)bakery, generated, getSprite, (ModelState)BlockModelRotation.X0_Y0, (ResourceLocation)location2, false);
                registry.replace(location2, model);
            }
            if ((seeds = crop.getSeedsItem()).getRegistryName() != null && ((bakedModel = (BakedModel)registry.get(location = new ModelResourceLocation(seeds.getRegistryName(), "inventory"))) == null || bakedModel.getParticleIcon((IModelData)EmptyModelData.INSTANCE).m_118413_().equals((Object)MISSING_NO))) {
                ResourceLocation texture = textures.getSeedTexture();
                RetextureableItemModelWrapper retexture = seedsModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
                BlockModel generated = generator.m_111670_(getSprite, (BlockModel)retexture);
                BakedModel model = generated.m_111449_((ModelBakery)bakery, generated, getSprite, (ModelState)BlockModelRotation.X0_Y0, (ResourceLocation)location, false);
                registry.replace(location, model);
            }
        });
        stopwatch.stop();
        MysticalAgriculture.LOGGER.info("Model replacement took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)BLOCK_ATLAS)) {
            CropRegistry.getInstance().getCrops().forEach(crop -> {
                CropTextures textures = crop.getTextures();
                event.addSprite(textures.getFlowerTexture());
                event.addSprite(textures.getEssenceTexture());
                event.addSprite(textures.getSeedTexture());
            });
        }
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PROSPERITY_ORE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DEEPSLATE_PROSPERITY_ORE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.INFERIUM_ORE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DEEPSLATE_INFERIUM_ORE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SOULIUM_ORE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SOUL_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WITHERPROOF_GLASS.get()), (RenderType)RenderType.m_110466_());
        CropRegistry.getInstance().getCrops().forEach(crop -> ItemBlockRenderTypes.setRenderLayer((Block)crop.getCropBlock(), (RenderType)RenderType.m_110457_()));
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.EXPERIENCE_CAPSULE.get()), (ResourceLocation)new ResourceLocation("fill"), (ItemPropertyFunction)ExperienceCapsuleItem.getFillPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SOUL_JAR.get()), (ResourceLocation)new ResourceLocation("fill"), (ItemPropertyFunction)SoulJarItem.getFillPropertyGetter());
        });
    }
}

