/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.Set;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.InterModComms;

public class TOPCompat
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("mysticalagriculture", "crops");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level world, BlockState state, IProbeHitData data) {
                Block block = state.m_60734_();
                BlockPos pos = data.getPos();
                if (block instanceof ICropProvider) {
                    Biome biome;
                    Set<ResourceLocation> biomes;
                    Block crux;
                    ICropProvider provider = (ICropProvider)block;
                    Crop crop = provider.getCrop();
                    Block belowBlock = world.m_8055_(pos.m_7495_()).m_60734_();
                    info.text((Component)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
                    double secondaryChance = crop.getSecondaryChance(belowBlock);
                    if (secondaryChance > 0.0) {
                        MutableComponent chanceText = new TextComponent(String.valueOf((int)(secondaryChance * 100.0))).m_130946_("%").m_130940_(crop.getTier().getTextColor());
                        info.text((Component)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
                    }
                    if ((crux = crop.getCruxBlock()) != null) {
                        ItemStack stack = new ItemStack((ItemLike)crux);
                        info.text((Component)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack.m_41786_()}).build());
                    }
                    if (!(biomes = crop.getRequiredBiomes()).isEmpty() && !biomes.contains((biome = world.m_46857_(pos)).getRegistryName())) {
                        info.text((Component)ModTooltips.INVALID_BIOME.color(ChatFormatting.RED).build());
                    }
                    if (block instanceof InferiumCropBlock) {
                        int output = 100;
                        if (belowBlock instanceof IEssenceFarmland) {
                            IEssenceFarmland farmland = (IEssenceFarmland)belowBlock;
                            int tier = farmland.getTier().getValue();
                            output = tier * 50 + 50;
                        }
                        MutableComponent inferiumOutputText = new TextComponent(String.valueOf(output)).m_130946_("%").m_130940_(crop.getTier().getTextColor());
                        info.text((Component)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
                    }
                }
                if (block instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)block;
                    info.text((Component)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
                }
            }
        });
        return null;
    }

    public static void onInterModEnqueue() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPCompat::new);
    }
}

