/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.SidedItemStackHandlerWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.container.SoulExtractorContainer;
import com.blakebr0.mysticalagriculture.crafting.recipe.SoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SoulExtractorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 100;
    public static final int FUEL_USAGE = 40;
    public static final int FUEL_CAPACITY = 80000;
    private final BaseItemStackHandler inventory;
    private final EnergyStorage energy;
    private final LazyOptional<IItemHandlerModifiable>[] inventoryCapabilities;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private int oldEnergy;
    private SoulExtractionRecipe recipe;

    public SoulExtractorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.SOUL_EXTRACTOR.get(), pos, state);
        this.inventory = SoulExtractorTileEntity.createInventoryHandler(() -> ((SoulExtractorTileEntity)this).markDirtyAndDispatch());
        this.energy = new EnergyStorage(80000);
        this.inventoryCapabilities = SidedItemStackHandlerWrapper.create((BaseItemStackHandler)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH}, this::canInsertStackSided, null);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.fuelLeft = tag.m_128451_("FuelLeft");
        this.fuelItemValue = tag.m_128451_("FuelItemValue");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("FuelLeft", this.fuelLeft);
        tag.m_128405_("FuelItemValue", this.fuelItemValue);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.mysticalagriculture.soul_extractor").build();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return SoulExtractorContainer.create(id, playerInventory, arg_0 -> ((SoulExtractorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, this.m_58899_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_()) {
            if (cap == CapabilityEnergy.ENERGY) {
                return CapabilityEnergy.ENERGY.orEmpty(cap, this.energyCapability);
            }
            if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (side == Direction.UP) {
                    return this.inventoryCapabilities[0].cast();
                }
                if (side == Direction.DOWN) {
                    return this.inventoryCapabilities[1].cast();
                }
                return this.inventoryCapabilities[2].cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SoulExtractorTileEntity tile) {
        boolean mark = false;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            if (tile.fuelLeft <= 0 && !fuel.m_41619_()) {
                tile.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.extractItemSuper(1, 1, false);
                    mark = true;
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                mark = true;
            }
        }
        if (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.inventory)) {
            ISoulExtractionRecipe recipe = level.m_7465_().m_44015_(RecipeTypes.SOUL_EXTRACTION, tile.inventory.toIInventory(), level).orElse(null);
            SoulExtractionRecipe soulExtractionRecipe = tile.recipe = recipe instanceof SoulExtractionRecipe ? (SoulExtractionRecipe)recipe : null;
        }
        if (tile.recipe != null) {
            if (tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
                ++tile.progress;
                tile.energy.extractEnergy(tile.getFuelUsage(), false);
                if (tile.progress >= tile.getOperationTime()) {
                    tile.inventory.extractItemSuper(0, 1, false);
                    tile.inventory.setStackInSlot(2, tile.recipe.assemble((IItemHandler)tile.inventory));
                    tile.progress = 0;
                }
                mark = true;
            }
        } else if (tile.progress > 0) {
            tile.progress = 0;
            mark = true;
        }
        if (tile.oldEnergy != tile.energy.getEnergyStored()) {
            tile.oldEnergy = tile.energy.getEnergyStored();
            mark = true;
        }
        if (mark) {
            tile.markDirtyAndDispatch();
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        return new BaseItemStackHandler(3, onContentsChanged);
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        return 100;
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        return 40;
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return true;
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.m_58399_((ItemStack)stack);
        }
        return false;
    }
}

