/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting;

import com.blakebr0.mysticalagriculture.blocks.ModBlocks;
import com.blakebr0.mysticalagriculture.config.EssenceConfig;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.crafting.CharmRecipe;
import com.blakebr0.mysticalagriculture.crafting.TinkeringTableManager;
import com.blakebr0.mysticalagriculture.items.ItemArrowHead;
import com.blakebr0.mysticalagriculture.items.ItemCrafting;
import com.blakebr0.mysticalagriculture.items.ItemEssenceCoal;
import com.blakebr0.mysticalagriculture.items.ItemNugget;
import com.blakebr0.mysticalagriculture.items.ItemWateringCan;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.lib.CropType;
import com.blakebr0.mysticalagriculture.lib.Parts;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModRecipes {
    private static CropType.Type type;

    public static ItemStack getEssence(int tier) {
        ItemStack essence = null;
        switch (tier - 1) {
            case 0: {
                essence = new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0);
                break;
            }
            case 1: {
                essence = new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0);
                break;
            }
            case 2: {
                essence = new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0);
                break;
            }
            case 3: {
                essence = new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0);
                break;
            }
            case 4: {
                essence = new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0);
            }
        }
        return essence;
    }

    public static ItemStack getCraftingSeed(int tier) {
        ItemStack craftingSeed = null;
        switch (tier - 1) {
            case 0: {
                craftingSeed = new ItemStack((Item)ModItems.itemTier1CraftingSeed, 1, 0);
                break;
            }
            case 1: {
                craftingSeed = new ItemStack((Item)ModItems.itemTier2CraftingSeed, 1, 0);
                break;
            }
            case 2: {
                craftingSeed = new ItemStack((Item)ModItems.itemTier3CraftingSeed, 1, 0);
                break;
            }
            case 3: {
                craftingSeed = new ItemStack((Item)ModItems.itemTier4CraftingSeed, 1, 0);
                break;
            }
            case 4: {
                craftingSeed = new ItemStack((Item)ModItems.itemTier5CraftingSeed, 1, 0);
            }
        }
        return craftingSeed;
    }

    public static ItemStack getMobChunk(int tier) {
        ItemStack mobChunk = null;
        switch (tier - 1) {
            case 0: {
                mobChunk = new ItemStack((Item)ModItems.itemTier1MobChunk, 1, 0);
                break;
            }
            case 1: {
                mobChunk = new ItemStack((Item)ModItems.itemTier2MobChunk, 1, 0);
                break;
            }
            case 2: {
                mobChunk = new ItemStack((Item)ModItems.itemTier3MobChunk, 1, 0);
                break;
            }
            case 3: {
                mobChunk = new ItemStack((Item)ModItems.itemTier4MobChunk, 1, 0);
                break;
            }
            case 4: {
                mobChunk = new ItemStack((Item)ModItems.itemTier5MobChunk, 1, 0);
            }
        }
        return mobChunk;
    }

    public static void addShapedRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, input));
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, input));
    }

    public static void addSeedRecipe(CropType.Type type, Object input) {
        if (type.isEnabled()) {
            ModRecipes.addShapedRecipe(new ItemStack((Item)type.getSeed(), 1, 0), "MEM", "ESE", "MEM", Character.valueOf('E'), ModRecipes.getEssence(type.getTier()), Character.valueOf('S'), ModRecipes.getCraftingSeed(type.getTier()), Character.valueOf('M'), input);
        }
    }

    public static void addCharmRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new CharmRecipe(output, input));
    }

    public static void addSmeltingRecipe(ItemStack input, ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void addTinkeringRecipe(ItemStack output, ItemStack input, ItemStack input2) {
        TinkeringTableManager.getInstance().addRecipe(output, "ACE", "PEP", "EPE", Character.valueOf('A'), input, Character.valueOf('C'), input2, Character.valueOf('E'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('P'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0));
    }

    /*
     * Opcode count of 19207 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void initRecipes() {
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockInferium, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockPrudentium, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockIntermedium, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSuperium, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSupremium, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockProsperity, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockBaseEssenceIngot, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockInferiumIngot, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockPrudentiumIngot, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockIntermediumIngot, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSuperiumIngot, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSupremiumIngot, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSouliumIngot, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSouliumIngot, 1, 0));
        if (ModConfig.confEssenceFurnaces) {
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockInferiumFurnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('D'), new ItemStack(Blocks.field_150460_al, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.blockInferium, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockPrudentiumFurnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.blockInferiumFurnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.blockPrudentium, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockIntermediumFurnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.blockPrudentiumFurnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.blockIntermedium, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSuperiumFurnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.blockIntermediumFurnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.blockSuperium, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSupremiumFurnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.blockSuperiumFurnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.blockSupremium, 1, 0));
            if (ModConfig.confUltimateFurnace) {
                ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockUltimateFurnace, 1, 0), "SNS", "EDE", "SES", Character.valueOf('E'), new ItemStack((Block)ModBlocks.blockSupremium, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.blockSupremiumFurnace, 1, 0), Character.valueOf('N'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151144_bL, 1, 1));
            }
        }
        if (ModConfig.confEssenceCoal) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 1, 0), new ItemStack(Items.field_151044_h, 1, 0), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 1, 1), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 1, 2), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 1), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 1, 3), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 2), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 1, 4), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 3), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 0), "CCC", "CCC", "CCC", Character.valueOf('C'), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 1), "CCC", "CCC", "CCC", Character.valueOf('C'), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 2), "CCC", "CCC", "CCC", Character.valueOf('C'), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 2));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 3), "CCC", "CCC", "CCC", Character.valueOf('C'), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 3));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 4), "CCC", "CCC", "CCC", Character.valueOf('C'), new ItemStack((Item)ModItems.itemEssenceCoal, 1, 4));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 9, 0), new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 9, 1), new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 1));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 9, 2), new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 2));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 9, 3), new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 3));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEssenceCoal, 9, 4), new ItemStack((Block)ModBlocks.blockEssenceCoal, 1, 4));
        }
        if (ModConfig.confGrowthAccelerator) {
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockGrowthAccelerator, 1, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Block)ModBlocks.blockInferium, 1, 0), Character.valueOf('S'), "stone", Character.valueOf('D'), "gemDiamond");
        }
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockMysticalMachineFrame, 4, 0), "SIS", "IXI", "SIS", Character.valueOf('S'), "stone", Character.valueOf('I'), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0));
        if (ModConfig.confSeedReprocessor) {
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSeedReprocessor), "ISI", "IMI", "IBI", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), new ItemStack((Item)ModItems.itemTier2InferiumSeeds, 1, 0), Character.valueOf('M'), new ItemStack((Block)ModBlocks.blockMysticalMachineFrame, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.blockSouliumIngot, 1, 0));
        }
        if (ModConfig.confWitherproofBlocks) {
            Object[] objectArray = new Object[7];
            objectArray[0] = "SES";
            objectArray[1] = "EDE";
            objectArray[2] = "SES";
            objectArray[3] = Character.valueOf('E');
            objectArray[4] = new ItemStack((Item)CropType.Type.WITHER_SKELETON.getCrop(), 1, 0);
            objectArray[5] = Character.valueOf('D');
            objectArray[6] = new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockWitherproofBlock, 1, 0), objectArray);
            Object[] objectArray2 = new Object[7];
            objectArray2[0] = "SES";
            objectArray2[1] = "EDE";
            objectArray2[2] = "SES";
            objectArray2[3] = Character.valueOf('E');
            objectArray2[4] = new ItemStack((Item)CropType.Type.WITHER_SKELETON.getCrop(), 1, 0);
            objectArray2[5] = Character.valueOf('D');
            objectArray2[6] = new ItemStack((Block)ModBlocks.blockSoulGlass, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockWitherproofGlass, 1, 0), objectArray2);
        }
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockTinkeringTable, 1, 0), "SSS", "ICI", "IXI", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), "workbench");
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockTinkeringTable, 1, 1), "SSS", "ICI", "IXI", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), "workbench");
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockTinkeringTable, 1, 2), "SSS", "ICI", "IXI", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), "workbench");
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockTinkeringTable, 1, 3), "SSS", "ICI", "IXI", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), "workbench");
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockTinkeringTable, 1, 4), "SSS", "ICI", "IXI", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), "workbench");
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumEssence, 9, 0), new ItemStack((Block)ModBlocks.blockInferium, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumEssence, 9, 0), new ItemStack((Block)ModBlocks.blockPrudentium, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumEssence, 9, 0), new ItemStack((Block)ModBlocks.blockIntermedium, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumEssence, 9, 0), new ItemStack((Block)ModBlocks.blockSuperium, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumEssence, 9, 0), new ItemStack((Block)ModBlocks.blockSupremium, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemProsperityShard, 9, 0), new ItemStack((Block)ModBlocks.blockProsperity, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemBaseEssenceIngot, 9, 0), new ItemStack((Block)ModBlocks.blockBaseEssenceIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumIngot, 9, 0), new ItemStack((Block)ModBlocks.blockInferiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumIngot, 9, 0), new ItemStack((Block)ModBlocks.blockPrudentiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumIngot, 9, 0), new ItemStack((Block)ModBlocks.blockIntermediumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumIngot, 9, 0), new ItemStack((Block)ModBlocks.blockSuperiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumIngot, 9, 0), new ItemStack((Block)ModBlocks.blockSupremiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSouliumIngot, 9, 0), new ItemStack((Block)ModBlocks.blockSouliumIngot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockPrudentium, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Block)ModBlocks.blockInferium, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockIntermedium, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Block)ModBlocks.blockPrudentium, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSuperium, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Block)ModBlocks.blockIntermedium, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSupremium, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Block)ModBlocks.blockSuperium, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumEssence, 4, 0), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumEssence, 4, 0), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumEssence, 4, 0), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumEssence, 4, 0), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInfusionCrystal, 1, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInfusionCrystalMaster, 1, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0));
        if (ModConfig.confMysticalFertilizer) {
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemMysticalFertilizer, 3, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack(Items.field_151100_aR, 1, 15));
            if (ModConfig.confFertilizedEssence) {
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemMysticalFertilizer, 6, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack((Item)ModItems.itemFertilizedEssence, 1, 0));
            }
        }
        if (CropType.Type.NATURE.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNatureCluster, 1, 0), new ItemStack((Block)Blocks.field_150434_aF, 1, 0), new ItemStack(Blocks.field_150423_aK, 1, 0), new ItemStack(Items.field_151120_aE, 1, 0), new ItemStack(Items.field_151015_O, 1, 0));
        }
        if (CropType.Type.DYE.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemDyeCluster, 1, 0), new ItemStack(Items.field_151100_aR, 1, 0), new ItemStack(Items.field_151100_aR, 1, 14), new ItemStack(Items.field_151100_aR, 1, 6), new ItemStack(Items.field_151100_aR, 1, 13));
        }
        if (CropType.Type.NETHER.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNetherCluster, 1, 0), new ItemStack(Blocks.field_150425_aM, 1, 0), new ItemStack(Blocks.field_150424_aL, 1, 0), new ItemStack(Blocks.field_150424_aL, 1, 0), new ItemStack(Blocks.field_150425_aM, 1, 0));
        }
        if (CropType.Type.END.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemEndCluster, 1, 0), new ItemStack(Blocks.field_150377_bs, 1, 0), new ItemStack(Blocks.field_185767_cT, 1, 0), new ItemStack(Blocks.field_185767_cT, 1, 0), new ItemStack(Blocks.field_150377_bs, 1, 0));
        }
        if (CropType.Type.MYSTICAL_FLOWER.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemMysticalFlowerCluster, 1, 0), new ItemStack(Parts.itemBotaniaFlowers, 1, Short.MAX_VALUE), new ItemStack(Parts.itemBotaniaFlowers, 1, Short.MAX_VALUE), new ItemStack(Parts.itemBotaniaFlowers, 1, Short.MAX_VALUE), new ItemStack(Parts.itemBotaniaFlowers, 1, Short.MAX_VALUE));
        }
        if (CropType.Type.SKELETON.isEnabled()) {
            if (CropType.Type.CREEPER.isEnabled() && EssenceConfig.record) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "CSC";
                objectArray[1] = "SIS";
                objectArray[2] = "CSC";
                objectArray[3] = Character.valueOf('I');
                objectArray[4] = "ingotIron";
                objectArray[5] = Character.valueOf('C');
                objectArray[6] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                objectArray[7] = Character.valueOf('S');
                objectArray[8] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBlankRecord, 1, 0), objectArray);
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray3[1] = "dyeYellow";
                objectArray3[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray3[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151096_cd, 1, 0), objectArray3);
                Object[] objectArray4 = new Object[4];
                objectArray4[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray4[1] = "dyeLime";
                objectArray4[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray4[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151093_ce, 1, 0), objectArray4);
                Object[] objectArray5 = new Object[4];
                objectArray5[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray5[1] = "dyeOrange";
                objectArray5[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray5[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151094_cf, 1, 0), objectArray5);
                Object[] objectArray6 = new Object[4];
                objectArray6[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray6[1] = "dyeRed";
                objectArray6[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray6[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151091_cg, 1, 0), objectArray6);
                Object[] objectArray7 = new Object[4];
                objectArray7[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray7[1] = "dyeCyan";
                objectArray7[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray7[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151092_ch, 1, 0), objectArray7);
                Object[] objectArray8 = new Object[4];
                objectArray8[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray8[1] = "dyePurple";
                objectArray8[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray8[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151089_ci, 1, 0), objectArray8);
                Object[] objectArray9 = new Object[4];
                objectArray9[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray9[1] = "dyeMagenta";
                objectArray9[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray9[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151090_cj, 1, 0), objectArray9);
                Object[] objectArray10 = new Object[4];
                objectArray10[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray10[1] = "dyeBlack";
                objectArray10[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray10[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151087_ck, 1, 0), objectArray10);
                Object[] objectArray11 = new Object[4];
                objectArray11[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray11[1] = "dyeWhite";
                objectArray11[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray11[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151088_cl, 1, 0), objectArray11);
                Object[] objectArray12 = new Object[4];
                objectArray12[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray12[1] = "dyeGreen";
                objectArray12[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray12[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151085_cm, 1, 0), objectArray12);
                Object[] objectArray13 = new Object[4];
                objectArray13[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray13[1] = "dyeGray";
                objectArray13[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray13[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151086_cn, 1, 0), objectArray13);
                Object[] objectArray14 = new Object[4];
                objectArray14[0] = new ItemStack((Item)ModItems.itemBlankRecord, 1, 0);
                objectArray14[1] = "dyeLightBlue";
                objectArray14[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray14[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151084_co, 1, 0), objectArray14);
            }
        }
        if (ModConfig.confEssenceApples) {
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumApple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('W'), new ItemStack(Items.field_151034_e, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumApple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemInferiumApple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumApple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemPrudentiumApple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumApple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemIntermediumApple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumApple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemSuperiumApple, 1, 0));
        }
        if (ModConfig.confWateringCans) {
            Object[] objectArray = new Object[9];
            objectArray[0] = "ICX";
            objectArray[1] = "IWI";
            objectArray[2] = "XIX";
            objectArray[3] = Character.valueOf('I');
            objectArray[4] = ModItems.itemInferiumIngot;
            objectArray[5] = Character.valueOf('C');
            objectArray[6] = ItemCrafting.itemInferiumFertCore;
            objectArray[7] = Character.valueOf('W');
            objectArray[8] = ItemCrafting.itemTheoreticalWater;
            ModRecipes.addShapedRecipe(ItemWateringCan.inferium, objectArray);
            Object[] objectArray15 = new Object[9];
            objectArray15[0] = "ICX";
            objectArray15[1] = "IWI";
            objectArray15[2] = "XIX";
            objectArray15[3] = Character.valueOf('I');
            objectArray15[4] = ModItems.itemPrudentiumIngot;
            objectArray15[5] = Character.valueOf('C');
            objectArray15[6] = ItemCrafting.itemPrudentiumFertCore;
            objectArray15[7] = Character.valueOf('W');
            objectArray15[8] = ItemCrafting.itemTheoreticalWater;
            ModRecipes.addShapedRecipe(ItemWateringCan.prudentium, objectArray15);
            Object[] objectArray16 = new Object[9];
            objectArray16[0] = "ICX";
            objectArray16[1] = "IWI";
            objectArray16[2] = "XIX";
            objectArray16[3] = Character.valueOf('I');
            objectArray16[4] = ModItems.itemIntermediumIngot;
            objectArray16[5] = Character.valueOf('C');
            objectArray16[6] = ItemCrafting.itemIntermediumFertCore;
            objectArray16[7] = Character.valueOf('W');
            objectArray16[8] = ItemCrafting.itemTheoreticalWater;
            ModRecipes.addShapedRecipe(ItemWateringCan.intermedium, objectArray16);
            Object[] objectArray17 = new Object[9];
            objectArray17[0] = "ICX";
            objectArray17[1] = "IWI";
            objectArray17[2] = "XIX";
            objectArray17[3] = Character.valueOf('I');
            objectArray17[4] = ModItems.itemSuperiumIngot;
            objectArray17[5] = Character.valueOf('C');
            objectArray17[6] = ItemCrafting.itemSuperiumFertCore;
            objectArray17[7] = Character.valueOf('W');
            objectArray17[8] = ItemCrafting.itemTheoreticalWater;
            ModRecipes.addShapedRecipe(ItemWateringCan.superium, objectArray17);
            Object[] objectArray18 = new Object[9];
            objectArray18[0] = "ICX";
            objectArray18[1] = "IWI";
            objectArray18[2] = "XIX";
            objectArray18[3] = Character.valueOf('I');
            objectArray18[4] = ModItems.itemSupremiumIngot;
            objectArray18[5] = Character.valueOf('C');
            objectArray18[6] = ItemCrafting.itemSupremiumFertCore;
            objectArray18[7] = Character.valueOf('W');
            objectArray18[8] = ItemCrafting.itemTheoreticalWater;
            ModRecipes.addShapedRecipe(ItemWateringCan.supremium, objectArray18);
        }
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBaseCraftingSeed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0), Character.valueOf('W'), new ItemStack(Items.field_151014_N, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier1CraftingSeed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemBaseCraftingSeed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier2CraftingSeed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemTier1CraftingSeed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier3CraftingSeed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemTier2CraftingSeed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier4CraftingSeed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemTier3CraftingSeed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier5CraftingSeed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemTier4CraftingSeed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0), "XPX", "PSP", "XPX", Character.valueOf('P'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151055_y, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemMysticalBowstring, 1, 0), "XPX", "PSP", "XPX", Character.valueOf('P'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151007_F, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemMysticalFletching, 1, 0), "XPX", "PSP", "XPX", Character.valueOf('P'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151008_G, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0), "XPX", "PIP", "XPX", Character.valueOf('P'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0), Character.valueOf('I'), "ingotIron");
        if (ModConfig.confHarderIngots) {
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0));
        } else {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0));
        }
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0), "NNN", "NNN", "NNN", Character.valueOf('N'), new ItemStack((Item)ModItems.itemNugget, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), "NNN", "NNN", "NNN", Character.valueOf('N'), new ItemStack((Item)ModItems.itemNugget, 1, 1));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), "NNN", "NNN", "NNN", Character.valueOf('N'), new ItemStack((Item)ModItems.itemNugget, 1, 2));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), "NNN", "NNN", "NNN", Character.valueOf('N'), new ItemStack((Item)ModItems.itemNugget, 1, 3));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), "NNN", "NNN", "NNN", Character.valueOf('N'), new ItemStack((Item)ModItems.itemNugget, 1, 4));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), "NNN", "NNN", "NNN", Character.valueOf('N'), new ItemStack((Item)ModItems.itemNugget, 1, 5));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSouliumIngot, 1, 0), "NNN", "NNN", "NNN", Character.valueOf('N'), new ItemStack((Item)ModItems.itemNugget, 1, 6));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 8, 0), "XDX", "DXD", "XDX", Character.valueOf('X'), "stone", Character.valueOf('D'), new ItemStack(Blocks.field_150425_aM, 1, 0));
        ModRecipes.addSmeltingRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 1, 1), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0), 0.3f);
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 2, 2), "SXX", "SXX", "XXX", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 4, 3), "SSX", "SSX", "XXX", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0));
        ModRecipes.addSmeltingRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 1, 3), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 4), 0.3f);
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 1, 5), "SXX", "SXX", "XXX", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstoneBrickSlab, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 2, 6), "SSX", "SSX", "XXX", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstoneSlab, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstoneSlab, 6, 0), "SSS", "XXX", "XXX", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockCobbledSoulstoneSlab, 6, 0), "SSS", "XXX", "XXX", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 1));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstoneBrickSlab, 6, 0), "SSS", "XXX", "XXX", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 3));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockCobbledSoulstoneStairs, 4, 0), "SXX", "SSX", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 1));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstoneBrickStairs, 4, 0), "SXX", "SSX", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 3));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockCobbledSoulstoneWall, 6, 0), "XXX", "SSS", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 1));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulstoneBrickWall, 6, 0), "XXX", "SSS", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.blockSoulstone, 1, 3));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulGlass, 8, 0), "XDX", "DXD", "XDX", Character.valueOf('X'), "blockGlass", Character.valueOf('D'), new ItemStack(Blocks.field_150425_aM, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.blockSoulGlassPane, 16, 0), "DDD", "XXX", "XXX", Character.valueOf('X'), new ItemStack((Block)ModBlocks.blockSoulGlass, 1, 0));
        ModRecipes.addSmeltingRecipe(new ItemStack((Block)ModBlocks.blockSoulstone, 1, 0), new ItemStack((Item)ModItems.itemSoulDust), 0.3f);
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSouliumDust, 1, 0), "SXS", "XSX", "SXS", Character.valueOf('S'), new ItemStack((Item)ModItems.itemSoulDust, 1, 0), Character.valueOf('X'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0));
        ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemSouliumDust, 1, 0), new ItemStack((Item)ModItems.itemSouliumIngot), 0.4f);
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSouliumDagger, 1, 0), "SXX", "SXX", "WXX", Character.valueOf('S'), new ItemStack((Item)ModItems.itemSouliumIngot, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNugget, 9, 0), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNugget, 9, 1), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNugget, 9, 2), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNugget, 9, 3), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNugget, 9, 4), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNugget, 9, 5), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemNugget, 9, 6), new ItemStack((Item)ModItems.itemSouliumIngot, 1, 0));
        if (ModConfig.confWateringCans) {
            Object[] objectArray = new Object[7];
            objectArray[0] = "NEN";
            objectArray[1] = "EEE";
            objectArray[2] = "NEN";
            objectArray[3] = Character.valueOf('N');
            objectArray[4] = ItemNugget.baseEssence;
            objectArray[5] = Character.valueOf('E');
            objectArray[6] = new ItemStack((Item)CropType.Type.WATER.getCrop(), 1, 0);
            ModRecipes.addShapedRecipe(ItemCrafting.itemTheoreticalWater, objectArray);
            if (ModConfig.confFertilizedEssence && ModConfig.confFertilizedEssenceChance > 0) {
                ModRecipes.addShapedRecipe(ItemCrafting.itemInferiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('E'), new ItemStack((Item)ModItems.itemFertilizedEssence, 1, 0));
                ModRecipes.addShapedRecipe(ItemCrafting.itemPrudentiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemInferiumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150368_y, 1, 0), Character.valueOf('E'), new ItemStack((Item)ModItems.itemFertilizedEssence, 1, 0));
                ModRecipes.addShapedRecipe(ItemCrafting.itemIntermediumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemPrudentiumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150340_R, 1, 0), Character.valueOf('E'), new ItemStack((Item)ModItems.itemFertilizedEssence, 1, 0));
                ModRecipes.addShapedRecipe(ItemCrafting.itemSuperiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemIntermediumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150484_ah, 1, 0), Character.valueOf('E'), new ItemStack((Item)ModItems.itemFertilizedEssence, 1, 0));
                ModRecipes.addShapedRecipe(ItemCrafting.itemSupremiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemSuperiumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('E'), new ItemStack((Item)ModItems.itemFertilizedEssence, 1, 0));
            } else {
                ModRecipes.addShapedRecipe(ItemCrafting.itemInferiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151100_aR, 1, 15));
                ModRecipes.addShapedRecipe(ItemCrafting.itemPrudentiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemInferiumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150368_y, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151100_aR, 1, 15));
                ModRecipes.addShapedRecipe(ItemCrafting.itemIntermediumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemPrudentiumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150340_R, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151100_aR, 1, 15));
                ModRecipes.addShapedRecipe(ItemCrafting.itemSuperiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemIntermediumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150484_ah, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151100_aR, 1, 15));
                ModRecipes.addShapedRecipe(ItemCrafting.itemSupremiumFertCore, "MLM", "EIE", "MEM", Character.valueOf('I'), ItemCrafting.itemSuperiumFertCore, Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151100_aR, 1, 15));
            }
        }
        ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151062_by, 4, 0), new ItemStack((Item)ModItems.itemExperienceChunk, 1, 0), new ItemStack((Item)ModItems.itemExperienceChunk, 1, 0), new ItemStack((Item)ModItems.itemExperienceChunk, 1, 0), new ItemStack((Item)ModItems.itemExperienceChunk, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemTier2MobChunk, 1, 0), new ItemStack((Item)ModItems.itemTier1MobChunk, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemTier3MobChunk, 1, 0), new ItemStack((Item)ModItems.itemTier2MobChunk, 1, 0), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemTier4MobChunk, 1, 0), new ItemStack((Item)ModItems.itemTier3MobChunk, 1, 0), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemTier5MobChunk, 1, 0), new ItemStack((Item)ModItems.itemTier4MobChunk, 1, 0), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0));
        if (ModConfig.confCraftableChunks) {
            if (CropType.Type.ZOMBIE.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "MMM";
                objectArray[1] = "MXM";
                objectArray[2] = "MMM";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151078_bh, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.ZOMBIE.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemZombieChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemZombieChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.ZOMBIE.getTier()), 0.3f);
            }
            if (CropType.Type.PIG.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151147_al, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.PIG.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPigChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemPigChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.PIG.getTier()), 0.3f);
            }
            if (CropType.Type.CHICKEN.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151110_aK, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151008_G, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.CHICKEN.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemChickenChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemChickenChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.CHICKEN.getTier()), 0.3f);
            }
            if (CropType.Type.COW.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151116_aA, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151082_bd, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.COW.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCowChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemCowChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.COW.getTier()), 0.3f);
            }
            if (CropType.Type.SHEEP.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.SHEEP.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSheepChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemSheepChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SHEEP.getTier()), 0.3f);
            }
            if (CropType.Type.SLIME.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151123_aH, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.SLIME.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSlimeChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemSlimeChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SLIME.getTier()), 0.3f);
            }
            if (CropType.Type.SKELETON.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151103_aS, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151032_g, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.SKELETON.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSkeletonChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemSkeletonChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SKELETON.getTier()), 0.3f);
            }
            if (CropType.Type.CREEPER.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151016_H, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.CREEPER.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCreeperChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemCreeperChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.CREEPER.getTier()), 0.3f);
            }
            if (CropType.Type.SPIDER.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151007_F, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151070_bp, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.SPIDER.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSpiderChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemSpiderChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SPIDER.getTier()), 0.3f);
            }
            if (CropType.Type.RABBIT.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_179555_bs, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_179558_bo, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.RABBIT.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemRabbitChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemRabbitChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.RABBIT.getTier()), 0.3f);
            }
            if (CropType.Type.GUARDIAN.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151115_aP, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_179562_cC, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.GUARDIAN.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemGuardianChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemGuardianChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.GUARDIAN.getTier()), 0.3f);
            }
            if (CropType.Type.BLAZE.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151072_bj, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.BLAZE.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBlazeChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemBlazeChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.BLAZE.getTier()), 0.3f);
            }
            if (CropType.Type.GHAST.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151073_bk, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.GHAST.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemGhastChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemGhastChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.GHAST.getTier()), 0.3f);
            }
            if (CropType.Type.ENDERMAN.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151079_bi, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.ENDERMAN.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemEndermanChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemEndermanChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.ENDERMAN.getTier()), 0.3f);
            }
            if (CropType.Type.WITHER_SKELETON.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151144_bL, 1, 1);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.WITHER_SKELETON.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemWitherSkeletonChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemWitherSkeletonChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.WITHER_SKELETON.getTier()), 0.3f);
            }
            if (CropType.Type.BLIZZ.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = "rodBlizz";
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.BLIZZ.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBlizzChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemBlizzChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.BLIZZ.getTier()), 0.3f);
            }
            if (CropType.Type.BLITZ.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = "rodBlitz";
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.BLITZ.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBlitzChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemBlitzChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.BLITZ.getTier()), 0.3f);
            }
            if (CropType.Type.BASALZ.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = "rodBasalz";
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.BASALZ.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemBasalzChunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.itemBasalzChunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.BASALZ.getTier()), 0.3f);
            }
        }
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier1InferiumSeeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151014_N, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier2InferiumSeeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemTier1InferiumSeeds, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier3InferiumSeeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemTier2InferiumSeeds, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier4InferiumSeeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemTier3InferiumSeeds, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemTier5InferiumSeeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemTier4InferiumSeeds, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.STONE, new ItemStack(Blocks.field_150348_b, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.DIRT, new ItemStack(Blocks.field_150346_d, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.NATURE, new ItemStack((Item)ModItems.itemNatureCluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.WOOD, "logWood");
        ModRecipes.addSeedRecipe(CropType.Type.WATER, new ItemStack(Items.field_151131_as, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.ICE, new ItemStack(Blocks.field_150432_aD, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.FIRE, new ItemStack(Items.field_151129_at, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.DYE, new ItemStack((Item)ModItems.itemDyeCluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.NETHER, new ItemStack((Item)ModItems.itemNetherCluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.COAL, new ItemStack(Items.field_151044_h, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.IRON, "ingotIron");
        ModRecipes.addSeedRecipe(CropType.Type.NETHER_QUARTZ, new ItemStack(Items.field_151128_bU, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GLOWSTONE, new ItemStack(Blocks.field_150426_aN, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.REDSTONE, new ItemStack(Items.field_151137_ax, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.OBSIDIAN, new ItemStack(Blocks.field_150343_Z, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GOLD, "ingotGold");
        ModRecipes.addSeedRecipe(CropType.Type.LAPIS_LAZULI, new ItemStack(Items.field_151100_aR, 1, 4));
        ModRecipes.addSeedRecipe(CropType.Type.EXPERIENCE, new ItemStack((Item)ModItems.itemExperienceChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.END, new ItemStack((Item)ModItems.itemEndCluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.DIAMOND, new ItemStack(Items.field_151045_i, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.EMERALD, new ItemStack(Items.field_151166_bC, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.ZOMBIE, new ItemStack((Item)ModItems.itemZombieChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.PIG, new ItemStack((Item)ModItems.itemPigChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.CHICKEN, new ItemStack((Item)ModItems.itemChickenChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.COW, new ItemStack((Item)ModItems.itemCowChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SHEEP, new ItemStack((Item)ModItems.itemSheepChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SLIME, new ItemStack((Item)ModItems.itemSlimeChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SKELETON, new ItemStack((Item)ModItems.itemSkeletonChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.CREEPER, new ItemStack((Item)ModItems.itemCreeperChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SPIDER, new ItemStack((Item)ModItems.itemSpiderChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.RABBIT, new ItemStack((Item)ModItems.itemRabbitChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GUARDIAN, new ItemStack((Item)ModItems.itemGuardianChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.BLAZE, new ItemStack((Item)ModItems.itemBlazeChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GHAST, new ItemStack((Item)ModItems.itemGhastChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.ENDERMAN, new ItemStack((Item)ModItems.itemEndermanChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.WITHER_SKELETON, new ItemStack((Item)ModItems.itemWitherSkeletonChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.RUBBER, "itemRubber");
        ModRecipes.addSeedRecipe(CropType.Type.SILICON, "itemSilicon");
        ModRecipes.addSeedRecipe(CropType.Type.SULFUR, "dustSulfur");
        ModRecipes.addSeedRecipe(CropType.Type.ALUMINUM, "ingotAluminum");
        ModRecipes.addSeedRecipe(CropType.Type.COPPER, "ingotCopper");
        ModRecipes.addSeedRecipe(CropType.Type.SALTPETER, "dustSaltpeter");
        ModRecipes.addSeedRecipe(CropType.Type.TIN, "ingotTin");
        ModRecipes.addSeedRecipe(CropType.Type.BRONZE, "ingotBronze");
        ModRecipes.addSeedRecipe(CropType.Type.ZINC, "ingotZinc");
        ModRecipes.addSeedRecipe(CropType.Type.BRASS, "ingotBrass");
        ModRecipes.addSeedRecipe(CropType.Type.SILVER, "ingotSilver");
        ModRecipes.addSeedRecipe(CropType.Type.LEAD, "ingotLead");
        ModRecipes.addSeedRecipe(CropType.Type.STEEL, "ingotSteel");
        ModRecipes.addSeedRecipe(CropType.Type.NICKEL, "ingotNickel");
        ModRecipes.addSeedRecipe(CropType.Type.CONSTANTAN, "ingotConstantan");
        ModRecipes.addSeedRecipe(CropType.Type.ELECTRUM, "ingotElectrum");
        ModRecipes.addSeedRecipe(CropType.Type.INVAR, "ingotInvar");
        ModRecipes.addSeedRecipe(CropType.Type.MITHRIL, "ingotMithril");
        ModRecipes.addSeedRecipe(CropType.Type.TUNGSTEN, "ingotTungsten");
        ModRecipes.addSeedRecipe(CropType.Type.TITANIUM, "ingotTitanium");
        ModRecipes.addSeedRecipe(CropType.Type.URANIUM, "ingotUranium");
        ModRecipes.addSeedRecipe(CropType.Type.CHROME, "ingotChrome");
        ModRecipes.addSeedRecipe(CropType.Type.PLATINUM, "ingotPlatinum");
        ModRecipes.addSeedRecipe(CropType.Type.IRIDIUM, "ingotIridium");
        ModRecipes.addSeedRecipe(CropType.Type.RUBY, "gemRuby");
        ModRecipes.addSeedRecipe(CropType.Type.SAPPHIRE, "gemSapphire");
        ModRecipes.addSeedRecipe(CropType.Type.PERIDOT, "gemPeridot");
        ModRecipes.addSeedRecipe(CropType.Type.AMBER, "gemAmber");
        ModRecipes.addSeedRecipe(CropType.Type.TOPAZ, "gemTopaz");
        ModRecipes.addSeedRecipe(CropType.Type.MALACHITE, "gemMalachite");
        ModRecipes.addSeedRecipe(CropType.Type.TANZANITE, "gemTanzanite");
        ModRecipes.addSeedRecipe(CropType.Type.BLIZZ, new ItemStack((Item)ModItems.itemBlizzChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.BLITZ, new ItemStack((Item)ModItems.itemBlitzChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.BASALZ, new ItemStack((Item)ModItems.itemBasalzChunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SIGNALUM, "ingotSignalum");
        ModRecipes.addSeedRecipe(CropType.Type.LUMIUM, "ingotLumium");
        ModRecipes.addSeedRecipe(CropType.Type.ENDERIUM, "ingotEnderium");
        ModRecipes.addSeedRecipe(CropType.Type.ALUMINUM_BRASS, new ItemStack(Parts.itemTinkersIngots, 1, 5));
        ModRecipes.addSeedRecipe(CropType.Type.KNIGHTSLIME, new ItemStack(Parts.itemTinkersIngots, 1, 3));
        ModRecipes.addSeedRecipe(CropType.Type.ARDITE, new ItemStack(Parts.itemTinkersIngots, 1, 1));
        ModRecipes.addSeedRecipe(CropType.Type.COBALT, new ItemStack(Parts.itemTinkersIngots, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.MANYULLYN, new ItemStack(Parts.itemTinkersIngots, 1, 2));
        ModRecipes.addSeedRecipe(CropType.Type.ELECTRICAL_STEEL, new ItemStack(Parts.itemEnderIOAlloys, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.REDSTONE_ALLOY, new ItemStack(Parts.itemEnderIOAlloys, 1, 3));
        ModRecipes.addSeedRecipe(CropType.Type.CONDUCTIVE_IRON, new ItemStack(Parts.itemEnderIOAlloys, 1, 4));
        ModRecipes.addSeedRecipe(CropType.Type.SOULARIUM, new ItemStack(Parts.itemEnderIOAlloys, 1, 7));
        ModRecipes.addSeedRecipe(CropType.Type.DARK_STEEL, new ItemStack(Parts.itemEnderIOAlloys, 1, 6));
        ModRecipes.addSeedRecipe(CropType.Type.PULSATING_IRON, new ItemStack(Parts.itemEnderIOAlloys, 1, 5));
        ModRecipes.addSeedRecipe(CropType.Type.ENERGETIC_ALLOY, new ItemStack(Parts.itemEnderIOAlloys, 1, 1));
        ModRecipes.addSeedRecipe(CropType.Type.VIBRANT_ALLOY, new ItemStack(Parts.itemEnderIOAlloys, 1, 2));
        ModRecipes.addSeedRecipe(CropType.Type.MYSTICAL_FLOWER, new ItemStack((Item)ModItems.itemMysticalFlowerCluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.MANASTEEL, new ItemStack(Parts.itemBotaniaResources, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.TERRASTEEL, new ItemStack(Parts.itemBotaniaResources, 1, 4));
        ModRecipes.addSeedRecipe(CropType.Type.QUICKSILVER, "quicksilver");
        ModRecipes.addSeedRecipe(CropType.Type.THAUMIUM, "ingotThaumium");
        ModRecipes.addSeedRecipe(CropType.Type.VOID_METAL, "ingotVoid");
        ModRecipes.addSeedRecipe(CropType.Type.URANIUM_238, new ItemStack(Parts.itemIC2Nuclear, 1, 2));
        ModRecipes.addSeedRecipe(CropType.Type.IRIDIUM_ORE, new ItemStack(Parts.itemIC2MiscResource, 1, 1));
        ModRecipes.addSeedRecipe(CropType.Type.OSMIUM, "ingotOsmium");
        ModRecipes.addSeedRecipe(CropType.Type.GLOWSTONE_INGOT, "ingotRefinedGlowstone");
        ModRecipes.addSeedRecipe(CropType.Type.REFINED_OBSIDIAN, "ingotRefinedObsidian");
        ModRecipes.addSeedRecipe(CropType.Type.AQUARIUM, "ingotAquarium");
        ModRecipes.addSeedRecipe(CropType.Type.COLD_IRON, "ingotColdiron");
        ModRecipes.addSeedRecipe(CropType.Type.STAR_STEEL, "ingotStarsteel");
        ModRecipes.addSeedRecipe(CropType.Type.ADAMANTINE, "ingotAdamantine");
        ModRecipes.addSeedRecipe(CropType.Type.MARBLE, new ItemStack(Parts.itemChiselMarble, 1, 7));
        ModRecipes.addSeedRecipe(CropType.Type.LIMESTONE, new ItemStack(Parts.itemChiselLimestone, 1, 7));
        ModRecipes.addSeedRecipe(CropType.Type.BASALT, new ItemStack(Parts.itemChiselBasalt, 1, 7));
        ModRecipes.addSeedRecipe(CropType.Type.APATITE, "gemApatite");
        ModRecipes.addSeedRecipe(CropType.Type.METEORIC_IRON, "ingotMeteoricIron");
        ModRecipes.addSeedRecipe(CropType.Type.DESH, "ingotDesh");
        ModRecipes.addSeedRecipe(CropType.Type.BLACK_QUARTZ, "gemQuartzBlack");
        ModRecipes.addSeedRecipe(CropType.Type.VINTEUM, "dustVinteum");
        ModRecipes.addSeedRecipe(CropType.Type.CHIMERITE, "gemChimerite");
        ModRecipes.addSeedRecipe(CropType.Type.BLUE_TOPAZ, "gemBlueTopaz");
        ModRecipes.addSeedRecipe(CropType.Type.MOONSTONE, "gemMoonstone");
        ModRecipes.addSeedRecipe(CropType.Type.SUNSTONE, "gemSunstone");
        ModRecipes.addSeedRecipe(CropType.Type.AQUAMARINE, new ItemStack(Parts.itemAstralCrafting, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.STARMETAL, new ItemStack(Parts.itemAstralCrafting, 1, 1));
        ModRecipes.addSeedRecipe(CropType.Type.ROCK_CRYSTAL, new ItemStack(Parts.itemAstralRockCrystal, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.ENDER_BIOTITE, "gemEnderBiotite");
        ModRecipes.addSeedRecipe(CropType.Type.ENDER_AMETHYST, new ItemStack(Parts.itemBOPGems, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.DRACONIUM, "ingotDraconium");
        ModRecipes.addSeedRecipe(CropType.Type.YELLORIUM, "ingotYellorium");
        ModRecipes.addSeedRecipe(CropType.Type.CERTUS_QUARTZ, "crystalCertusQuartz");
        ModRecipes.addSeedRecipe(CropType.Type.FLUIX, "crystalFluix");
        ModRecipes.addSeedRecipe(CropType.Type.QUARTZ_ENRICHED_IRON, new ItemStack(Parts.itemRSIngot, 1, 0));
        if (ModConfig.confGearModuleOverride) {
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCoreRemover, 1, 0), "IOI", "ODO", "IOI", Character.valueOf('I'), "ingotIron", Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z, 1, 0), Character.valueOf('D'), new ItemStack(Items.field_151045_i, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151145_ak, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150368_y, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151043_k, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150340_R, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151045_i, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150484_ah, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151166_bC, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151144_bL, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemBaseEssenceIngot, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151116_aA, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemPrudentiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150368_y, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151043_k, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemIntermediumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150340_R, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151045_i, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150484_ah, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151166_bC, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumEssence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151144_bL, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumSword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumPickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumShovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumAxe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumHoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumShears, 1, 0), "IXX", "XCX", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumBow, 1, 0), "XIS", "CXS", "XIS", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalBowstring, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumSickle, 1, 0), "XIX", "XXC", "SIX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumScythe, 1, 0), "ICS", "XSX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumSword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumPickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumShovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumAxe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumHoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumShears, 1, 0), "IXX", "XCX", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumBow, 1, 0), "XIS", "CXS", "XIS", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalBowstring, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumSickle, 1, 0), "XIX", "XXC", "SIX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumScythe, 1, 0), "ICS", "XSX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumSword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumPickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumShovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumAxe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumHoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumShears, 1, 0), "IXX", "XCX", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumBow, 1, 0), "XIS", "CXS", "XIS", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalBowstring, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumSickle, 1, 0), "XIX", "XXC", "SIX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumScythe, 1, 0), "ICS", "XSX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumSword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumPickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumShovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumAxe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumHoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumShears, 1, 0), "IXX", "XCX", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumBow, 1, 0), "XIS", "CXS", "XIS", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalBowstring, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumSickle, 1, 0), "XIX", "XXC", "SIX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumScythe, 1, 0), "ICS", "XSX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumSword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumPickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumShovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumAxe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumHoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumShears, 1, 0), "IXX", "XCX", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumBow, 1, 0), "XIS", "CXS", "XIS", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalBowstring, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumSickle, 1, 0), "XIX", "XXC", "SIX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumScythe, 1, 0), "ICS", "XSX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0));
            if (ModConfig.confWateringCans) {
                ModRecipes.addShapelessRecipe(ItemCrafting.itemInferiumFertCore, ItemWateringCan.inferium, new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
                ModRecipes.addShapelessRecipe(ItemCrafting.itemPrudentiumFertCore, ItemWateringCan.prudentium, new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
                ModRecipes.addShapelessRecipe(ItemCrafting.itemIntermediumFertCore, ItemWateringCan.intermedium, new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
                ModRecipes.addShapelessRecipe(ItemCrafting.itemSuperiumFertCore, ItemWateringCan.superium, new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
                ModRecipes.addShapelessRecipe(ItemCrafting.itemSupremiumFertCore, ItemWateringCan.supremium, new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            }
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumPickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumShovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumAxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumHoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumShears, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumBow, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumSickle, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumScythe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumPickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumShovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumAxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumHoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumShears, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumBow, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumSickle, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumScythe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumPickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumShovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumAxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumHoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumShears, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumBow, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumSickle, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumToolCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumScythe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumPickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumShovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumAxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumHoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumShears, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumBow, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumSickle, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumScythe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumPickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumShovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumAxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumHoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumShears, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumBow, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumSickle, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumToolCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumScythe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), "PPP", "PBP", "PPP", Character.valueOf('P'), new ItemStack((Item)ModItems.itemProsperityShard, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.blockSuperium, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmNightvision, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151150_bK, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmAbsorption, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151153_ao, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmWither, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151156_bN, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmAntivenom, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151117_aB, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmFire, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151064_bs, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmResistance, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSuperiumApple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmStrength, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumApple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmStrength2, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmStrength, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumApple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmSpeed, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151102_aT, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmJump, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_179556_br, 1, 0));
            Object[] objectArray = new Object[9];
            objectArray[0] = "MEM";
            objectArray[1] = "EBE";
            objectArray[2] = "MEM";
            objectArray[3] = Character.valueOf('E');
            objectArray[4] = new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0);
            objectArray[5] = Character.valueOf('B');
            objectArray[6] = new ItemStack((Item)ModItems.itemCharmBlank, 1, 0);
            objectArray[7] = Character.valueOf('M');
            objectArray[8] = ItemEssenceCoal.supremium;
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmMinersVision, 1, 0), objectArray);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmRainbow, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemDyeCluster, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmQuickDraw, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemIntermediumApple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmTripleShot, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumBow, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
            if (ModConfig.confAOECharms) {
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmMiningAOE, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumPickaxe, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmAttackAOE, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumSword, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmTillingAOE, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumHoe, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmShearingAOE, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumShears, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmReapingAOE, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumSickle, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemCharmScythingAOE, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.itemSuperiumEssence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.itemCharmBlank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.itemSupremiumScythe, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0));
            }
            Object[] objectArray19 = new Object[7];
            objectArray19[0] = "XNX";
            objectArray19[1] = "NMN";
            objectArray19[2] = "XNX";
            objectArray19[3] = Character.valueOf('N');
            objectArray19[4] = ItemNugget.inferium;
            objectArray19[5] = Character.valueOf('M');
            objectArray19[6] = new ItemStack(Items.field_151145_ak, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemArrowHead, 1, 0), objectArray19);
            Object[] objectArray20 = new Object[7];
            objectArray20[0] = "XNX";
            objectArray20[1] = "NMN";
            objectArray20[2] = "XNX";
            objectArray20[3] = Character.valueOf('N');
            objectArray20[4] = ItemNugget.prudentium;
            objectArray20[5] = Character.valueOf('M');
            objectArray20[6] = ItemArrowHead.inferium;
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemArrowHead, 1, 1), objectArray20);
            Object[] objectArray21 = new Object[7];
            objectArray21[0] = "XNX";
            objectArray21[1] = "NMN";
            objectArray21[2] = "XNX";
            objectArray21[3] = Character.valueOf('N');
            objectArray21[4] = ItemNugget.intermedium;
            objectArray21[5] = Character.valueOf('M');
            objectArray21[6] = ItemArrowHead.prudentium;
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemArrowHead, 1, 2), objectArray21);
            Object[] objectArray22 = new Object[7];
            objectArray22[0] = "XNX";
            objectArray22[1] = "NMN";
            objectArray22[2] = "XNX";
            objectArray22[3] = Character.valueOf('N');
            objectArray22[4] = ItemNugget.superium;
            objectArray22[5] = Character.valueOf('M');
            objectArray22[6] = ItemArrowHead.intermedium;
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemArrowHead, 1, 3), objectArray22);
            Object[] objectArray23 = new Object[7];
            objectArray23[0] = "XNX";
            objectArray23[1] = "NMN";
            objectArray23[2] = "XNX";
            objectArray23[3] = Character.valueOf('N');
            objectArray23[4] = ItemNugget.supremium;
            objectArray23[5] = Character.valueOf('M');
            objectArray23[6] = ItemArrowHead.superium;
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemArrowHead, 1, 4), objectArray23);
            Object[] objectArray24 = new Object[9];
            objectArray24[0] = "XAX";
            objectArray24[1] = "XSX";
            objectArray24[2] = "XFX";
            objectArray24[3] = Character.valueOf('A');
            objectArray24[4] = ItemArrowHead.inferium;
            objectArray24[5] = Character.valueOf('S');
            objectArray24[6] = new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0);
            objectArray24[7] = Character.valueOf('F');
            objectArray24[8] = new ItemStack((Item)ModItems.itemMysticalFletching, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumArrow, 12, 0), objectArray24);
            Object[] objectArray25 = new Object[9];
            objectArray25[0] = "XAX";
            objectArray25[1] = "XSX";
            objectArray25[2] = "XFX";
            objectArray25[3] = Character.valueOf('A');
            objectArray25[4] = ItemArrowHead.prudentium;
            objectArray25[5] = Character.valueOf('S');
            objectArray25[6] = new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0);
            objectArray25[7] = Character.valueOf('F');
            objectArray25[8] = new ItemStack((Item)ModItems.itemMysticalFletching, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumArrow, 12, 0), objectArray25);
            Object[] objectArray26 = new Object[9];
            objectArray26[0] = "XAX";
            objectArray26[1] = "XSX";
            objectArray26[2] = "XFX";
            objectArray26[3] = Character.valueOf('A');
            objectArray26[4] = ItemArrowHead.intermedium;
            objectArray26[5] = Character.valueOf('S');
            objectArray26[6] = new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0);
            objectArray26[7] = Character.valueOf('F');
            objectArray26[8] = new ItemStack((Item)ModItems.itemMysticalFletching, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumArrow, 12, 0), objectArray26);
            Object[] objectArray27 = new Object[9];
            objectArray27[0] = "XAX";
            objectArray27[1] = "XSX";
            objectArray27[2] = "XFX";
            objectArray27[3] = Character.valueOf('A');
            objectArray27[4] = ItemArrowHead.superium;
            objectArray27[5] = Character.valueOf('S');
            objectArray27[6] = new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0);
            objectArray27[7] = Character.valueOf('F');
            objectArray27[8] = new ItemStack((Item)ModItems.itemMysticalFletching, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumArrow, 12, 0), objectArray27);
            Object[] objectArray28 = new Object[9];
            objectArray28[0] = "XAX";
            objectArray28[1] = "XSX";
            objectArray28[2] = "XFX";
            objectArray28[3] = Character.valueOf('A');
            objectArray28[4] = ItemArrowHead.supremium;
            objectArray28[5] = Character.valueOf('S');
            objectArray28[6] = new ItemStack((Item)ModItems.itemMysticalToolRod, 1, 0);
            objectArray28[7] = Character.valueOf('F');
            objectArray28[8] = new ItemStack((Item)ModItems.itemMysticalFletching, 1, 0);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumArrow, 12, 0), objectArray28);
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumHelmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumChestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumLeggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemInferiumBoots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemInferiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumHelmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumChestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumLeggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemPrudentiumBoots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemPrudentiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumHelmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumChestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumLeggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemIntermediumBoots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemIntermediumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumHelmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumChestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumLeggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSuperiumBoots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSuperiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.itemSupremiumBoots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.itemSupremiumIngot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemInferiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemInferiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemPrudentiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemPrudentiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemIntermediumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemIntermediumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSuperiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSuperiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.itemSupremiumArmorCore, 1, 0), new ItemStack((Item)ModItems.itemSupremiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCoreRemover, 1, Short.MAX_VALUE));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumSwordStrength), new ItemStack((Item)ModItems.itemSupremiumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmStrength, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumSwordStrength2), new ItemStack((Item)ModItems.itemSupremiumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmStrength2, 1, 0));
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumSwordAOE), new ItemStack((Item)ModItems.itemSupremiumSword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAttackAOE, 1, 0));
            }
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumPickaxeMinersVision), new ItemStack((Item)ModItems.itemSupremiumPickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmMinersVision, 1, 0));
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumPickaxeAOE), new ItemStack((Item)ModItems.itemSupremiumPickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmMiningAOE, 1, 0));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumShovelAOE), new ItemStack((Item)ModItems.itemSupremiumShovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmMiningAOE, 1, 0));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumAxeAOE), new ItemStack((Item)ModItems.itemSupremiumAxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmMiningAOE, 1, 0));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumHoeAOE), new ItemStack((Item)ModItems.itemSupremiumHoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmTillingAOE, 1, 0));
            }
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumShearsRainbow), new ItemStack((Item)ModItems.itemSupremiumShears, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmRainbow, 1, 0));
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumShearsAOE), new ItemStack((Item)ModItems.itemSupremiumShears, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmShearingAOE, 1, 0));
            }
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBowQuickDraw), new ItemStack((Item)ModItems.itemSupremiumBow, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmQuickDraw, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBowTripleShot), new ItemStack((Item)ModItems.itemSupremiumBow, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmTripleShot, 1, 0));
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumSickleAOE), new ItemStack((Item)ModItems.itemSupremiumSickle, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmReapingAOE, 1, 0));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumScytheAOE), new ItemStack((Item)ModItems.itemSupremiumScythe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmScythingAOE, 1, 0));
            }
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmetNightvision), new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmNightvision, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmetAbsorption), new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAbsorption, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmetWither), new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmWither, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmetAntivenom), new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAntivenom, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmetFire), new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmFire, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmetResistance), new ItemStack((Item)ModItems.itemSupremiumHelmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmResistance, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplateStrength), new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmStrength, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplateAbsorption), new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAbsorption, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplateWither), new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmWither, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplateAntivenom), new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAntivenom, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplateFire), new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmFire, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplateResistance), new ItemStack((Item)ModItems.itemSupremiumChestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmResistance, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggingsSpeed), new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmSpeed, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggingsAbsorption), new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAbsorption, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggingsWither), new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmWither, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggingsAntivenom), new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAntivenom, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggingsFire), new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmFire, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggingsResistance), new ItemStack((Item)ModItems.itemSupremiumLeggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmResistance, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBootsJump), new ItemStack((Item)ModItems.itemSupremiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmJump, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBootsAbsorption), new ItemStack((Item)ModItems.itemSupremiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAbsorption, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBootsWither), new ItemStack((Item)ModItems.itemSupremiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmWither, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBootsAntivenom), new ItemStack((Item)ModItems.itemSupremiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmAntivenom, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBootsFire), new ItemStack((Item)ModItems.itemSupremiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmFire, 1, 0));
            ModRecipes.addTinkeringRecipe(new ItemStack((Item)ModItems.itemSupremiumBootsResistance), new ItemStack((Item)ModItems.itemSupremiumBoots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.itemCharmResistance, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumSword), new ItemStack((Item)ModItems.itemSupremiumSwordStrength, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumSword), new ItemStack((Item)ModItems.itemSupremiumSwordStrength2, 1, Short.MAX_VALUE));
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumSword), new ItemStack((Item)ModItems.itemSupremiumSwordAOE, 1, Short.MAX_VALUE));
            }
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumPickaxe), new ItemStack((Item)ModItems.itemSupremiumPickaxeMinersVision, 1, Short.MAX_VALUE));
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumPickaxe), new ItemStack((Item)ModItems.itemSupremiumPickaxeAOE, 1, Short.MAX_VALUE));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumShovel), new ItemStack((Item)ModItems.itemSupremiumShovelAOE, 1, Short.MAX_VALUE));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumAxe), new ItemStack((Item)ModItems.itemSupremiumAxeAOE, 1, Short.MAX_VALUE));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumHoe), new ItemStack((Item)ModItems.itemSupremiumHoeAOE, 1, Short.MAX_VALUE));
            }
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumShears), new ItemStack((Item)ModItems.itemSupremiumShearsRainbow, 1, Short.MAX_VALUE));
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumShears), new ItemStack((Item)ModItems.itemSupremiumShearsAOE, 1, Short.MAX_VALUE));
            }
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBow), new ItemStack((Item)ModItems.itemSupremiumBowQuickDraw, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBow), new ItemStack((Item)ModItems.itemSupremiumBowTripleShot, 1, Short.MAX_VALUE));
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumSickle), new ItemStack((Item)ModItems.itemSupremiumSickleAOE, 1, Short.MAX_VALUE));
            }
            if (ModConfig.confAOECharms) {
                ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumScythe), new ItemStack((Item)ModItems.itemSupremiumScytheAOE, 1, Short.MAX_VALUE));
            }
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmet), new ItemStack((Item)ModItems.itemSupremiumHelmetNightvision, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmet), new ItemStack((Item)ModItems.itemSupremiumHelmetAbsorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmet), new ItemStack((Item)ModItems.itemSupremiumHelmetWither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmet), new ItemStack((Item)ModItems.itemSupremiumHelmetAntivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmet), new ItemStack((Item)ModItems.itemSupremiumHelmetFire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumHelmet), new ItemStack((Item)ModItems.itemSupremiumHelmetResistance, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplate), new ItemStack((Item)ModItems.itemSupremiumChestplateStrength, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplate), new ItemStack((Item)ModItems.itemSupremiumChestplateAbsorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplate), new ItemStack((Item)ModItems.itemSupremiumChestplateWither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplate), new ItemStack((Item)ModItems.itemSupremiumChestplateAntivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplate), new ItemStack((Item)ModItems.itemSupremiumChestplateFire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumChestplate), new ItemStack((Item)ModItems.itemSupremiumChestplateResistance, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggings), new ItemStack((Item)ModItems.itemSupremiumLeggingsSpeed, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggings), new ItemStack((Item)ModItems.itemSupremiumLeggingsAbsorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggings), new ItemStack((Item)ModItems.itemSupremiumLeggingsWither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggings), new ItemStack((Item)ModItems.itemSupremiumLeggingsAntivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggings), new ItemStack((Item)ModItems.itemSupremiumLeggingsFire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumLeggings), new ItemStack((Item)ModItems.itemSupremiumLeggingsResistance, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBoots), new ItemStack((Item)ModItems.itemSupremiumBootsJump, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBoots), new ItemStack((Item)ModItems.itemSupremiumBootsAbsorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBoots), new ItemStack((Item)ModItems.itemSupremiumBootsWither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBoots), new ItemStack((Item)ModItems.itemSupremiumBootsAntivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBoots), new ItemStack((Item)ModItems.itemSupremiumBootsFire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.itemSupremiumBoots), new ItemStack((Item)ModItems.itemSupremiumBootsResistance, 1, Short.MAX_VALUE));
        }
    }
}

