/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.lib.CropType;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobDrops {
    public static Random rand = new Random();
    private static CropType.Type type;
    private static final String BLIZZ_CLASS = "cofh.thermalfoundation.entity.monster.EntityBlizz";
    private static final String BLITZ_CLASS = "cofh.thermalfoundation.entity.monster.EntityBlitz";
    private static final String BASALZ_CLASS = "cofh.thermalfoundation.entity.monster.EntityBasalz";

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack held;
        EntityLivingBase attacked = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        List drops = event.getDrops();
        if (entity != null && entity instanceof EntityPlayer && (held = (player = (EntityPlayer)entity).func_184614_ca()) != null && held.func_77973_b() == ModItems.itemSouliumDagger) {
            if (attacked instanceof EntityZombie) {
                if (CropType.Type.ZOMBIE.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemZombieChunk, 1, MobDrops.getChanceFromTier(CropType.Type.ZOMBIE.getTier()), drops);
                }
            }
            if (attacked instanceof EntityPig) {
                if (CropType.Type.PIG.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemPigChunk, 1, MobDrops.getChanceFromTier(CropType.Type.PIG.getTier()), drops);
                }
            }
            if (attacked instanceof EntityChicken) {
                if (CropType.Type.CHICKEN.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemChickenChunk, 1, MobDrops.getChanceFromTier(CropType.Type.CHICKEN.getTier()), drops);
                }
            }
            if (attacked instanceof EntityCow) {
                if (CropType.Type.COW.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemCowChunk, 1, MobDrops.getChanceFromTier(CropType.Type.COW.getTier()), drops);
                }
            }
            if (attacked instanceof EntitySheep) {
                if (CropType.Type.SHEEP.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemSheepChunk, 1, MobDrops.getChanceFromTier(CropType.Type.SHEEP.getTier()), drops);
                }
            }
            if (attacked instanceof EntitySlime) {
                if (CropType.Type.SLIME.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemSlimeChunk, 1, MobDrops.getChanceFromTier(CropType.Type.SLIME.getTier()), drops);
                }
            }
            if (attacked instanceof EntitySkeleton) {
                if (CropType.Type.SKELETON.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemSkeletonChunk, 1, MobDrops.getChanceFromTier(CropType.Type.SKELETON.getTier()), drops);
                }
            }
            if (attacked instanceof EntityCreeper) {
                if (CropType.Type.CREEPER.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemCreeperChunk, 1, MobDrops.getChanceFromTier(CropType.Type.CREEPER.getTier()), drops);
                }
            }
            if (attacked instanceof EntitySpider) {
                if (CropType.Type.SPIDER.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemSpiderChunk, 1, MobDrops.getChanceFromTier(CropType.Type.SPIDER.getTier()), drops);
                }
            }
            if (attacked instanceof EntityRabbit) {
                if (CropType.Type.RABBIT.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemRabbitChunk, 1, MobDrops.getChanceFromTier(CropType.Type.RABBIT.getTier()), drops);
                }
            }
            if (attacked instanceof EntityGuardian) {
                if (CropType.Type.GUARDIAN.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemGuardianChunk, 1, MobDrops.getChanceFromTier(CropType.Type.GUARDIAN.getTier()), drops);
                }
            }
            if (attacked instanceof EntityBlaze) {
                if (CropType.Type.BLAZE.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemBlazeChunk, 1, MobDrops.getChanceFromTier(CropType.Type.BLAZE.getTier()), drops);
                }
            }
            if (attacked instanceof EntityGhast) {
                if (CropType.Type.GHAST.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemGhastChunk, 1, MobDrops.getChanceFromTier(CropType.Type.GHAST.getTier()), drops);
                }
            }
            if (attacked instanceof EntityEnderman) {
                if (CropType.Type.ENDERMAN.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemEndermanChunk, 1, MobDrops.getChanceFromTier(CropType.Type.ENDERMAN.getTier()), drops);
                }
            }
            if (attacked instanceof EntitySkeleton && ((EntitySkeleton)attacked).func_189771_df() == SkeletonType.WITHER) {
                if (CropType.Type.WITHER_SKELETON.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemWitherSkeletonChunk, 1, MobDrops.getChanceFromTier(CropType.Type.WITHER_SKELETON.getTier()), drops);
                }
            }
            if (attacked instanceof EntityMob) {
                this.drop((Entity)attacked, ModItems.itemExperienceChunk, 1, MobDrops.getChance(10), drops);
            }
            if (attacked.getClass().getName() == BLIZZ_CLASS) {
                if (CropType.Type.BLIZZ.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemBlizzChunk, 1, MobDrops.getChanceFromTier(CropType.Type.BLIZZ.getTier()), drops);
                }
            }
            if (attacked.getClass().getName() == BLITZ_CLASS) {
                if (CropType.Type.BLITZ.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemBlitzChunk, 1, MobDrops.getChanceFromTier(CropType.Type.BLITZ.getTier()), drops);
                }
            }
            if (attacked.getClass().getName() == BASALZ_CLASS) {
                if (CropType.Type.BASALZ.isEnabled()) {
                    this.drop((Entity)attacked, ModItems.itemBasalzChunk, 1, MobDrops.getChanceFromTier(CropType.Type.BASALZ.getTier()), drops);
                }
            }
        }
        if (event.getEntity() instanceof EntityMob) {
            this.drop((Entity)attacked, ModItems.itemInferiumEssence, 1, MobDrops.getChance(ModConfig.confHostileDropChance), drops);
        }
        if (event.getEntity() instanceof EntityAnimal) {
            this.drop((Entity)attacked, ModItems.itemInferiumEssence, 1, MobDrops.getChance(ModConfig.confPassiveDropChance), drops);
        }
        if (event.getEntity() instanceof EntityWither) {
            this.drop((Entity)attacked, ModItems.itemSupremiumEssence, ModConfig.confWitherSupremium, ModConfig.confWitherSupremium, drops);
        }
        if (event.getEntity() instanceof EntityDragon) {
            this.drop((Entity)attacked, ModItems.itemSupremiumEssence, ModConfig.confDragonSupremium, ModConfig.confDragonSupremium, drops);
        }
    }

    public static int getChance(int chance) {
        int dropChance = 0;
        if (chance == 0) {
            return 0;
        }
        if (rand.nextInt(100 / chance) == 1) {
            ++dropChance;
        }
        return dropChance;
    }

    public static int getChanceFromTier(int tier) {
        int chance = 35 - tier * 5;
        return MobDrops.getChance(chance);
    }

    public EntityItem drop(Entity entity, Item item, int amount, int chance, List<EntityItem> drops) {
        return this.drop(entity, item, amount, 0, chance, drops);
    }

    public EntityItem drop(Entity entity, Item item, int amount, int meta, int chance, List<EntityItem> drops) {
        EntityItem drop;
        ItemStack stack = new ItemStack(item, chance, meta);
        if (stack.field_77994_a > amount) {
            stack.field_77994_a = amount;
        }
        if ((drop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack)) != null && stack.field_77994_a >= 1) {
            drops.add(drop);
        }
        return drop;
    }
}

