/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.armor;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSupremiumArmor
extends ItemArmor {
    public ItemSupremiumArmor(String name, ItemArmor.ArmorMaterial material, int index, EntityEquipmentSlot slot) {
        super(material, index, slot);
        this.func_77655_b("ma." + name);
        this.setRegistryName(name);
        this.func_77637_a(MysticalAgriculture.tabMysticalAgriculture);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.DURABILITY + "\u00a7c" + damage);
        if (ModConfig.confSupremiumFlight) {
            tooltip.add(Tooltips.SET_BONUS + "\u00a7c" + Tooltips.FLIGHT);
        }
        tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.EMPTY);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (ModConfig.confSetBonuses && ItemSupremiumArmor.isFullSet(player)) {
            if (player.func_70090_H()) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 5, 0, true, false));
            }
            player.field_70143_R = 0.0f;
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ModItems.itemSupremiumIngot;
    }

    public static boolean isFullSet(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
        return head != null && head.func_77973_b() instanceof ItemSupremiumArmor && chest != null && chest.func_77973_b() instanceof ItemSupremiumArmor && legs != null && legs.func_77973_b() instanceof ItemSupremiumArmor && feet != null && feet.func_77973_b() instanceof ItemSupremiumArmor;
    }

    public static class AbilityHandler {
        public static List<String> playersWithSet = new ArrayList<String>();

        public static String playerKey(EntityPlayer player) {
            return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
        }

        @SubscribeEvent
        public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                String key = AbilityHandler.playerKey(player);
                Boolean hasSet = ItemSupremiumArmor.isFullSet(player);
                if (playersWithSet.contains(key)) {
                    if (hasSet.booleanValue()) {
                        if (ModConfig.confSupremiumFlight) {
                            player.field_71075_bZ.field_75101_c = true;
                        }
                        if (ModConfig.confSetBonuses) {
                            player.field_70138_W = 1.0625f;
                            boolean flying = player.field_71075_bZ.field_75100_b;
                            if (flying) {
                                boolean sneaking = player.func_70093_af();
                                float speed = 0.08f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                                if (player.field_70701_bs > 0.0f) {
                                    player.func_70060_a(0.0f, 1.0f, speed);
                                } else if (player.field_70701_bs < 0.0f) {
                                    player.func_70060_a(0.0f, 1.0f, -speed * 0.3f);
                                }
                                if (player.field_70702_br != 0.0f) {
                                    player.func_70060_a(1.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                                }
                            }
                        }
                    } else {
                        player.field_70138_W = 0.6f;
                        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                            player.field_71075_bZ.field_75101_c = false;
                            player.field_71075_bZ.field_75100_b = false;
                        }
                        playersWithSet.remove(key);
                    }
                } else if (hasSet.booleanValue()) {
                    playersWithSet.add(key);
                }
            }
        }
    }
}

