/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.tools;

import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.tools.ItemEssenceHoe;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSupremiumHoe
extends ItemEssenceHoe {
    public int range;

    public ItemSupremiumHoe(String name, Item.ToolMaterial material, int range, Item repairMaterial, TextFormatting color) {
        super(name, material, repairMaterial, color);
        this.range = range;
    }

    public boolean isSneakAbilityEnabled() {
        return ModConfig.confSneakHoeAOE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        int range = this.range + 2;
        if (this.isSneakAbilityEnabled()) {
            tooltip.add(Tooltips.HOE_TOOLTIP[0] + " " + "\u00a77" + Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName() + " " + Tooltips.HOE_TOOLTIP[1] + " " + "\u00a7c" + range + "x" + range + "\u00a77" + ".");
        }
        tooltip.add(Tooltips.DURABILITY + "\u00a7c" + Tooltips.UNLIMITED);
        tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.EMPTY);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.hoe(stack, player, world, pos, facing) && !player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-this.range, 0, -this.range), (BlockPos)pos.func_177982_a(this.range, 0, this.range));
        if (player.func_70093_af() && this.isSneakAbilityEnabled()) {
            for (BlockPos aoePos : blocks) {
                this.hoe(stack, player, world, aoePos, facing);
            }
        } else {
            this.hoe(stack, player, world, pos, facing);
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean hoe(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face) {
        if (!player.func_175151_a(pos.func_177972_a(face), face, stack)) {
            return false;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (face != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.func_185071_a(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                return true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.func_185071_a(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        return true;
                    }
                    case COARSE_DIRT: {
                        this.func_185071_a(stack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

