/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.tools.upgraded;

import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.tools.ItemEssenceShovel;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.blakebr0.mysticalagriculture.util.ToolTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShovelAOE
extends ItemEssenceShovel {
    public static List<Material> acceptedMaterials = new ArrayList<Material>();

    public ItemShovelAOE(String name, Item.ToolMaterial material, Item repairMaterial, TextFormatting color) {
        super(name, material, repairMaterial, color);
        this.initAcceptedMaterials();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        tooltip.add(Tooltips.DURABILITY + "\u00a7c" + Tooltips.UNLIMITED);
        tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.MINING_AOE);
    }

    public ItemStack getContainerItem(ItemStack itemstack) {
        return new ItemStack((Item)ModItems.itemCharmMiningAOE, 1, 0);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ModConfig.confCharmReturn;
    }

    public static void initAcceptedMaterials() {
        acceptedMaterials.add(Material.field_151571_B);
        acceptedMaterials.add(Material.field_151596_z);
        acceptedMaterials.add(Material.field_151577_b);
        acceptedMaterials.add(Material.field_151578_c);
        acceptedMaterials.add(Material.field_151595_p);
        acceptedMaterials.add(Material.field_151597_y);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean blocks = false;
        RayTraceResult ray = ToolTools.getBlockWithinReach(player.func_130014_f_(), player);
        if (ray != null) {
            int side = ray.field_178784_b.ordinal();
            blocks = this.harvest(stack, 1, player.func_130014_f_(), pos, side, player);
        }
        return blocks;
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (!this.canHarvest(world, pos, false, stack, player)) {
            return false;
        }
        if (radius > 0 && hardness >= 0.2f) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange));
            for (BlockPos aoePos : blocks) {
                if (aoePos == pos) continue;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                    if (!acceptedMaterials.contains(aoeState.func_185904_a())) continue;
                    this.canHarvest(world, aoePos, true, stack, player);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE(stack, world, player, pos);
        }
        return false;
    }
}

