/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.proxy;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.blocks.ModBlocks;
import com.blakebr0.mysticalagriculture.config.EssenceConfig;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.crafting.CharmRecipe;
import com.blakebr0.mysticalagriculture.crafting.EssenceRecipes;
import com.blakebr0.mysticalagriculture.crafting.ModRecipes;
import com.blakebr0.mysticalagriculture.crafting.ReprocessorManager;
import com.blakebr0.mysticalagriculture.entity.ModEntities;
import com.blakebr0.mysticalagriculture.handler.BowZoomHandler;
import com.blakebr0.mysticalagriculture.handler.GuiHandler;
import com.blakebr0.mysticalagriculture.handler.MobDrops;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.armor.ItemIntermediumArmor;
import com.blakebr0.mysticalagriculture.items.armor.ItemSuperiumArmor;
import com.blakebr0.mysticalagriculture.items.armor.ItemSupremiumArmor;
import com.blakebr0.mysticalagriculture.items.armor.upgraded.ItemUpgradedSpeed;
import com.blakebr0.mysticalagriculture.lib.CropType;
import com.blakebr0.mysticalagriculture.lib.Parts;
import com.blakebr0.mysticalagriculture.tileentity.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.ModChecker;
import com.blakebr0.mysticalagriculture.world.OreGeneration;
import java.io.File;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        ModConfig.init(new File(e.getModConfigurationDirectory(), "mysticalagriculture.cfg"));
        EssenceConfig.init(new File(e.getModConfigurationDirectory(), "mysticalagriculture_recipes.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig());
        MinecraftForge.EVENT_BUS.register((Object)new EssenceConfig());
        ModBlocks.initBlocks();
        ModItems.initItems();
        CropType.init();
        ModEntities.init();
        MinecraftForge.EVENT_BUS.register((Object)new BowZoomHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemIntermediumArmor.AbilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemSuperiumArmor.AbilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemSupremiumArmor.AbilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemUpgradedSpeed.AbilityHandler());
    }

    public void init(FMLInitializationEvent e) {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.blakebr0.mysticalagriculture.util.WailaDataProvider.callbackRegister");
        ModTileEntities.initTileEntities();
        if (ModConfig.confSeedReprocessor) {
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.itemInferiumEssence, 1, 0), new ItemStack((Item)ModItems.itemTier1InferiumSeeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.itemInferiumEssence, 2, 0), new ItemStack((Item)ModItems.itemTier2InferiumSeeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.itemInferiumEssence, 3, 0), new ItemStack((Item)ModItems.itemTier3InferiumSeeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.itemInferiumEssence, 4, 0), new ItemStack((Item)ModItems.itemTier4InferiumSeeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.itemInferiumEssence, 5, 0), new ItemStack((Item)ModItems.itemTier5InferiumSeeds, 1, 0));
        }
        for (CropType.Type type : CropType.Type.values()) {
            if (!type.isEnabled()) continue;
            ReprocessorManager.addRecipe(new ItemStack((Item)type.getCrop(), 2, 0), new ItemStack((Item)type.getSeed(), 1, 0));
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MysticalAgriculture.INSTANCE, (IGuiHandler)new GuiHandler());
        if (ModChecker.JEI) {
            ModBlocks.initJEIDescriptions();
        }
        ModBlocks.initOreDict();
        ModItems.initOreDict();
        Parts.getParts();
        RecipeSorter.register((String)"mysticalagriculture:charm_recipe", CharmRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        ModRecipes.initRecipes();
        EssenceRecipes.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGeneration(), (int)0);
        MinecraftForge.EVENT_BUS.register((Object)new MobDrops());
    }

    public void postInit(FMLPostInitializationEvent e) {
    }
}

