/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.world;

import com.blakebr0.mysticalagriculture.blocks.BlockBase;
import com.blakebr0.mysticalagriculture.blocks.ModBlocks;
import com.blakebr0.mysticalagriculture.blocks.soulstone.BlockSoulstone;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.util.Utils;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (!ModConfig.confGenerateRegular) break;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                if (ModConfig.confGenerateNether) {
                    this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                }
                if (!ModConfig.confGenerateSoulstone) break;
                this.generateSoulstone(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                if (!ModConfig.confGenerateEnd) break;
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                if (!ModConfig.confGenerateRegular) break;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int posX, int posZ) {
        IBlockState state;
        BlockPos pos;
        int z;
        int y;
        int x;
        ModConfig config = ModConfig.instance;
        BlockBase block = ModBlocks.blockInferiumOre;
        int veinCount = ModConfig.confInferiumVeinCount;
        int veinSize = ModConfig.confInferiumVeinSize;
        int i = 0;
        while (true) {
            if (i >= ModConfig.confInferiumVeinCount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.confInferiumMaxY - ModConfig.confInferiumMinY) + ModConfig.confInferiumMinY;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize).func_180709_b(world, random, pos);
            ++i;
        }
        block = ModBlocks.blockProsperityOre;
        veinCount = ModConfig.confProsperityVeinCount;
        veinSize = ModConfig.confProsperityVeinSize;
        i = 0;
        while (true) {
            if (i >= ModConfig.confProsperityVeinCount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.confProsperityMaxY - ModConfig.confProsperityMinY) + ModConfig.confProsperityMinY;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize).func_180709_b(world, random, pos);
            ++i;
        }
    }

    private void generateNether(World world, Random random, int posX, int posZ) {
        IBlockState state;
        BlockPos pos;
        int z;
        int y;
        int x;
        ModConfig config = ModConfig.instance;
        BlockMatcher predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
        BlockBase block = ModBlocks.blockInferiumOreNether;
        int veinCount = ModConfig.confNetherInferiumVeinCount;
        int veinSize = ModConfig.confNetherInferiumVeinSize;
        int i = 0;
        while (true) {
            if (i >= ModConfig.confNetherInferiumVeinCount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.confNetherInferiumMaxY - ModConfig.confNetherInferiumMinY) + ModConfig.confNetherInferiumMinY;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
        block = ModBlocks.blockProsperityOreNether;
        veinCount = ModConfig.confNetherProsperityVeinCount;
        veinSize = ModConfig.confNetherProsperityVeinSize;
        i = 0;
        while (true) {
            if (i >= ModConfig.confNetherProsperityVeinCount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.confNetherProsperityMaxY - ModConfig.confNetherProsperityMinY) + ModConfig.confNetherProsperityMinY;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
    }

    private void generateEnd(World world, Random random, int posX, int posZ) {
        IBlockState state;
        BlockPos pos;
        int z;
        int y;
        int x;
        ModConfig config = ModConfig.instance;
        BlockMatcher predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs);
        BlockBase block = ModBlocks.blockInferiumOreEnd;
        int veinCount = ModConfig.confEndInferiumVeinCount;
        int veinSize = ModConfig.confEndInferiumVeinSize;
        int i = 0;
        while (true) {
            if (i >= ModConfig.confEndInferiumVeinCount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.confEndInferiumMaxY - ModConfig.confEndInferiumMinY) + ModConfig.confEndInferiumMinY;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
        block = ModBlocks.blockProsperityOreEnd;
        veinCount = ModConfig.confEndProsperityVeinCount;
        veinSize = ModConfig.confEndProsperityVeinSize;
        i = 0;
        while (true) {
            if (i >= ModConfig.confEndProsperityVeinCount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.confEndProsperityMaxY - ModConfig.confEndProsperityMinY) + ModConfig.confEndProsperityMinY;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
    }

    private void generateSoulstone(World world, Random random, int posX, int posZ) {
        ModConfig config = ModConfig.instance;
        BlockMatcher predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
        BlockSoulstone block = ModBlocks.blockSoulstone;
        int veinCount = ModConfig.confSoulstoneVeinCount;
        int veinSize = MathHelper.func_76125_a((int)ModConfig.confSoulstoneVeinSize, (int)0, (int)40);
        for (int i = 0; i < veinCount; ++i) {
            int x = posX + random.nextInt(16);
            int y = Utils.randInt(ModConfig.confSoulstoneMinY, ModConfig.confSoulstoneMaxY);
            int z = posZ + random.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
        }
    }
}

