/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.soul.ISoulSiphoningItem;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class MobSoulHandler {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        block3: {
            PlayerEntity player;
            ItemStack held;
            Entity source = event.getSource().func_76346_g();
            if (!(source instanceof PlayerEntity) || !((held = (player = (PlayerEntity)source).func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof ISoulSiphoningItem)) break block3;
            LivingEntity entity = event.getEntityLiving();
            ISoulSiphoningItem siphoner = (ISoulSiphoningItem)held.func_77973_b();
            IMobSoulType type = MobSoulTypeRegistry.getInstance().getMobSoulTypeByEntity(entity);
            if (type == null || !type.isEnabled()) {
                return;
            }
            List<ItemStack> jars = MobSoulHandler.getValidSoulJars(player, type);
            if (!jars.isEmpty()) {
                ItemStack jar;
                double remaining = siphoner.getSiphonAmount(held, entity);
                Iterator<ItemStack> iterator = jars.iterator();
                while (iterator.hasNext() && !((remaining = MobSoulUtils.addSoulsToJar(jar = iterator.next(), type, remaining)) <= 0.0)) {
                }
            }
        }
    }

    private static List<ItemStack> getValidSoulJars(PlayerEntity player, IMobSoulType type) {
        return player.field_71071_by.field_70462_a.stream().filter(s -> s.func_77973_b() instanceof SoulJarItem).filter(s -> MobSoulUtils.canAddTypeToJar(s, type)).sorted((a, b) -> MobSoulUtils.getType(a) != null ? -1 : (MobSoulUtils.getType(b) != null ? 0 : 1)).collect(Collectors.toList());
    }
}

