/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.util.ExperienceCapsuleUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExperienceCapsuleItem
extends BaseItem {
    public ExperienceCapsuleItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_200917_a(1)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int experience = ExperienceCapsuleUtils.getExperience(stack);
        tooltip.add((ITextComponent)ModTooltips.EXPERIENCE_CAPSULE.args(new Object[]{experience, 1200}).build());
    }

    public static IItemPropertyGetter getFillPropertyGetter() {
        return (stack, world, entity) -> {
            int experience = ExperienceCapsuleUtils.getExperience(stack);
            if (experience > 0) {
                double level = (double)experience / 1200.0;
                return (int)(level * 10.0);
            }
            return 0.0f;
        };
    }
}

