/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.registry;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.registry.IAugmentRegistry;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.item.AugmentItem;
import com.blakebr0.mysticalagriculture.registry.PluginRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AugmentRegistry
implements IAugmentRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AugmentRegistry INSTANCE = new AugmentRegistry();
    private final Map<ResourceLocation, IAugment> augments = new LinkedHashMap<ResourceLocation, IAugment>();

    @Override
    public void register(IAugment augment) {
        if (this.augments.values().stream().noneMatch(c -> c.getId().equals((Object)augment.getId()))) {
            this.augments.put(augment.getId(), augment);
        } else {
            LOGGER.info("{} tried to register a duplicate augment with id {}, skipping", (Object)augment.getModId(), (Object)augment.getId());
        }
    }

    @Override
    public List<IAugment> getAugments() {
        return Collections.unmodifiableList(new ArrayList<IAugment>(this.augments.values()));
    }

    @Override
    public IAugment getAugmentById(ResourceLocation id) {
        return this.augments.get(id);
    }

    public static AugmentRegistry getInstance() {
        return INSTANCE;
    }

    public void onRegisterItems(IForgeRegistry<Item> registry) {
        PluginRegistry.getInstance().forEach((plugin, config) -> plugin.onRegisterAugments(this));
        this.augments.forEach((id, a) -> {
            AugmentItem item = new AugmentItem((IAugment)a, p -> p.func_200916_a(MysticalAgriculture.ITEM_GROUP));
            item.setRegistryName(a.getNameWithSuffix("augment"));
            registry.register((IForgeRegistryEntry)item);
        });
        PluginRegistry.getInstance().forEach((plugin, config) -> plugin.onPostRegisterAugments(this));
    }
}

