/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib;

import epicsquid.mysticallib.MysticalLib;
import epicsquid.mysticallib.block.BlockSlabBase;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.block.INoCullBlock;
import epicsquid.mysticallib.event.RegisterContentEvent;
import epicsquid.mysticallib.event.RegisterCustomModelsEvent;
import epicsquid.mysticallib.event.RegisterParticleEvent;
import epicsquid.mysticallib.model.BakedModelColorWrapper;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.model.block.BakedModelBlockUnlitWrapper;
import epicsquid.mysticallib.particle.ParticleBase;
import epicsquid.mysticallib.particle.ParticleRegistry;
import epicsquid.mysticallib.particle.particles.ParticleCloud;
import epicsquid.mysticallib.particle.particles.ParticleFlame;
import epicsquid.mysticallib.particle.particles.ParticleGlitter;
import epicsquid.mysticallib.particle.particles.ParticleGlow;
import epicsquid.mysticallib.particle.particles.ParticleLeaf;
import epicsquid.mysticallib.particle.particles.ParticleLeafArc;
import epicsquid.mysticallib.particle.particles.ParticleRain;
import epicsquid.mysticallib.particle.particles.ParticleSmoke;
import epicsquid.mysticallib.particle.particles.ParticleSpark;
import epicsquid.mysticallib.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LibRegistry {
    private static ArrayList<Item> items = new ArrayList();
    private static ArrayList<Block> blocks = new ArrayList();
    private static ArrayList<SoundEvent> sounds = new ArrayList();
    private static Map<Class<? extends Entity>, IRenderFactory> entityRenderMap = new HashMap<Class<? extends Entity>, IRenderFactory>();
    private static Map<Class<? extends TileEntity>, TileEntitySpecialRenderer> tileEntityRenderMap = new HashMap<Class<? extends TileEntity>, TileEntitySpecialRenderer>();
    private static int entityId = 0;
    private static String activeModid = "";
    private static Set<ModelResourceLocation> noCullMRLs = new HashSet<ModelResourceLocation>();
    private static Set<ModelResourceLocation> colorMRLs = new HashSet<ModelResourceLocation>();
    public static Class<? extends ParticleBase> PARTICLE_GLOW;
    public static Class<? extends ParticleBase> PARTICLE_SMOKE;
    public static Class<? extends ParticleBase> PARTICLE_CLOUD;
    public static Class<? extends ParticleBase> PARTICLE_SPARK;
    public static Class<? extends ParticleBase> PARTICLE_GLITTER;
    public static Class<? extends ParticleBase> PARTICLE_FLAME;
    public static Class<? extends ParticleBase> PARTICLE_LEAF_ARC;
    public static Class<? extends ParticleBase> PARTICLE_RAIN;
    public static Class<? extends ParticleBase> PARTICLE_LEAF;
    public static ResourceLocation[] LEAF_TEXTURES;

    public static String getActiveModid() {
        return activeModid;
    }

    public static void initAll() {
        ModContainer container = Loader.instance().activeModContainer();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterContentEvent(items, blocks, sounds));
        LibRegistry.setActiveMod("mysticallib", container);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerEntityRenderer(@Nonnull Class<? extends Entity> entity, @Nonnull IRenderFactory render) {
        entityRenderMap.put(entity, render);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerTileRenderer(@Nonnull Class<? extends TileEntity> entity, @Nonnull TileEntitySpecialRenderer render) {
        tileEntityRenderMap.put(entity, render);
    }

    public static void addSlabPair(Material material, SoundType type, float hardness, String name, IBlockState parent, Block[] refs, CreativeTabs tab) {
        BlockSlabBase double_slab = new BlockSlabBase(material, type, hardness, name + "_double_slab", parent, true, null).setModelCustom(false);
        BlockSlabBase slab = new BlockSlabBase(material, type, hardness, name + "_slab", parent, false, (Block)double_slab).setModelCustom(false);
        double_slab.slab = slab;
        slab.func_149647_a(tab);
        refs[0] = slab;
        refs[1] = double_slab;
        blocks.add((Block)slab);
        blocks.add((Block)double_slab);
    }

    public static void registerEntity(Class<? extends Entity> entity, int eggColor1, int eggColor2) {
        String[] nameParts = entity.getTypeName().split("\\.");
        String className = nameParts[nameParts.length - 1];
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(activeModid + ":" + Util.lowercase(className)), entity, (String)Util.lowercase(className), (int)entityId++, (Object)MysticalLib.INSTANCE, (int)64, (int)1, (boolean)true, (int)eggColor1, (int)eggColor2);
    }

    public static void registerEntity(Class<? extends Entity> entity) {
        String[] nameParts = entity.getTypeName().split("\\.");
        String className = nameParts[nameParts.length - 1];
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(activeModid + ":" + Util.lowercase(className)), entity, (String)Util.lowercase(className), (int)entityId++, (Object)MysticalLib.INSTANCE, (int)64, (int)1, (boolean)true);
    }

    public static void setActiveMod(@Nonnull String modid, @Nonnull ModContainer container) {
        activeModid = modid;
        Loader.instance().setActiveModContainer(container);
    }

    @SubscribeEvent
    public void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        for (Item i : items) {
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
        for (Block b : blocks) {
            Item i;
            if (!(b instanceof IBlock) || (i = ((IBlock)b).getItemBlock()) == null || i == Items.field_190931_a) continue;
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
    }

    @SubscribeEvent
    public void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        for (Block b : blocks) {
            event.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    @SubscribeEvent
    public void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent s : sounds) {
            event.getRegistry().register((IForgeRegistryEntry)s);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerRendering(@Nonnull ModelRegistryEvent event) {
        for (Item i : items) {
            if (!(i instanceof IModeledObject)) continue;
            ((IModeledObject)i).initModel();
        }
        for (Block b : blocks) {
            if (!(b instanceof IModeledObject)) continue;
            ((IModeledObject)b).initModel();
        }
    }

    public static void registerEntityRenders() {
        for (Map.Entry<Class<? extends Entity>, IRenderFactory> entry : entityRenderMap.entrySet()) {
            RenderingRegistry.registerEntityRenderingHandler(entry.getKey(), (IRenderFactory)entry.getValue());
        }
        for (Map.Entry<Class<? extends Entity>, IRenderFactory> entry : tileEntityRenderMap.entrySet()) {
            ClientRegistry.bindTileEntitySpecialRenderer(entry.getKey(), (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)entry.getValue()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterCustomModels(@Nonnull RegisterCustomModelsEvent event) {
        for (Block b : blocks) {
            if (!(b instanceof ICustomModeledObject)) continue;
            ((ICustomModeledObject)b).initCustomModel();
        }
        for (Item i : items) {
            if (!(i instanceof ICustomModeledObject)) continue;
            ((ICustomModeledObject)i).initCustomModel();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(@Nonnull TextureStitchEvent event) {
        for (Map.Entry<Class<? extends ParticleBase>, List<ResourceLocation>> entry : ParticleRegistry.particleMultiTextures.entrySet()) {
            entry.getValue().forEach(arg_0 -> ((TextureMap)event.getMap()).func_174942_a(arg_0));
        }
        for (Map.Entry<Class<? extends ParticleBase>, List<ResourceLocation>> entry : CustomModelLoader.itemmodels.entrySet()) {
            for (ResourceLocation r : ((IModel)entry.getValue()).getTextures()) {
                event.getMap().func_174942_a(r);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBake(@Nonnull ModelBakeEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterTintedModelsEvent());
        noCullMRLs.clear();
        for (Block b : blocks) {
            if (!(b instanceof IModeledObject) || !(b instanceof INoCullBlock) || !((INoCullBlock)b).noCull()) continue;
            noCullMRLs.addAll(event.getModelManager().func_174954_c().func_178120_a().func_188181_b(b).values());
        }
        for (ResourceLocation r : CustomModelLoader.itemmodels.keySet()) {
            ModelResourceLocation mrl = new ModelResourceLocation(r.toString().replace("#handlers", ""), "handlers");
            IBakedModel bakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl);
            if (bakedModel == null) continue;
            IModel m = CustomModelLoader.itemmodels.get(r);
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)m.bake(m.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
        }
        for (ModelResourceLocation mrl : event.getModelRegistry().func_148742_b()) {
            if (noCullMRLs.contains(mrl)) {
                event.getModelRegistry().func_82595_a((Object)mrl, (Object)new BakedModelBlockUnlitWrapper(event.getModelManager().func_174953_a(mrl)));
            }
            if (!colorMRLs.contains(mrl)) continue;
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)new BakedModelColorWrapper(event.getModelManager().func_174953_a(mrl)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterCustomModels(@Nonnull RegisterParticleEvent event) {
        PARTICLE_GLOW = ParticleRegistry.registerParticle("mysticallib", ParticleGlow.class, new ResourceLocation("mysticallib:particle/particle_glow"));
        PARTICLE_SMOKE = ParticleRegistry.registerParticle("mysticallib", ParticleSmoke.class, new ResourceLocation("mysticallib:particle/particle_smoke"));
        PARTICLE_CLOUD = ParticleRegistry.registerParticle("mysticallib", ParticleCloud.class, new ResourceLocation("mysticallib:particle/particle_cloud"));
        PARTICLE_SPARK = ParticleRegistry.registerParticle("mysticallib", ParticleSpark.class, new ResourceLocation("mysticallib:particle/particle_sparkle"));
        PARTICLE_GLITTER = ParticleRegistry.registerParticle("mysticallib", ParticleGlitter.class, new ResourceLocation("mysticallib:particle/particle_sparkle"));
        PARTICLE_FLAME = ParticleRegistry.registerParticle("mysticallib", ParticleFlame.class, new ResourceLocation("mysticallib:particle/particle_fire"));
        PARTICLE_LEAF_ARC = ParticleRegistry.registerParticle("mysticallib", ParticleLeafArc.class, LEAF_TEXTURES);
        PARTICLE_LEAF = ParticleRegistry.registerParticle("mysticallib", ParticleLeaf.class, LEAF_TEXTURES);
        PARTICLE_RAIN = ParticleRegistry.registerParticle("mysticallib", ParticleRain.class, new ResourceLocation("mysticallib:particle/particle_rain1"), new ResourceLocation("mysticallib:particle/particle_rain2"), new ResourceLocation("mysticallib:particle/particle_rain3"), new ResourceLocation("mysticallib:particle/particle_rain4"), new ResourceLocation("mysticallib:particle/particle_rain5"), new ResourceLocation("mysticallib:particle/particle_rain6"), new ResourceLocation("mysticallib:particle/particle_rain7"), new ResourceLocation("mysticallib:particle/particle_rain8"), new ResourceLocation("mysticallib:particle/particle_rain9"), new ResourceLocation("mysticallib:particle/particle_rain10"), new ResourceLocation("mysticallib:particle/particle_rain11"), new ResourceLocation("mysticallib:particle/particle_rain12"), new ResourceLocation("mysticallib:particle/particle_rain13"), new ResourceLocation("mysticallib:particle/particle_rain14"));
    }

    static {
        LEAF_TEXTURES = new ResourceLocation[]{new ResourceLocation("mysticallib:particle/particle_leaf1"), new ResourceLocation("mysticallib:particle/particle_leaf2"), new ResourceLocation("mysticallib:particle/particle_leaf3"), new ResourceLocation("mysticallib:particle/particle_leaf4")};
    }

    public class RegisterTintedModelsEvent
    extends Event {
        public void addModel(ModelResourceLocation mrl) {
            colorMRLs.add(mrl);
        }
    }
}

