/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import epicsquid.mysticalworld.init.ModEntities;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class LavaCatEntity
extends TameableEntity {
    public static ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/lava_cat");
    private static final DataParameter<Boolean> IS_LAVA = EntityDataManager.func_187226_a(LavaCatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final UUID OBSIDIAN_SPEED_DEBUFF_ID = UUID.fromString("f58f95e9-fb51-4604-a66d-89433c9dd8a5");
    private static final AttributeModifier OBSIDIAN_SPEED_DEBUFF = new AttributeModifier(OBSIDIAN_SPEED_DEBUFF_ID, "Speed debuff for being obsidian", -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);

    public LavaCatEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 0.6, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151072_bj}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
        this.field_70714_bg.func_75776_a(8, (Goal)new OcelotAttackGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8, 1));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static boolean placement(EntityType<? extends AnimalEntity> p_223316_0_, IWorld worldIn, SpawnReason reason, BlockPos blockpos, Random p_223316_4_) {
        Block block = worldIn.func_180495_p(blockpos.func_177977_b()).func_177230_c();
        return block == Blocks.field_150424_aL || block == Blocks.field_150343_Z || block == Blocks.field_196814_hQ || block == Blocks.field_150425_aM || block == Blocks.field_196653_dH || block == Blocks.field_189880_di;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LAVA, (Object)true);
    }

    public void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 0.6) {
                this.func_226284_e_(true);
                this.func_70031_b(false);
            } else if (d0 == 1.33) {
                this.func_226284_e_(false);
                this.func_70031_b(true);
            } else {
                this.func_226284_e_(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_226284_e_(false);
            this.func_70031_b(false);
        }
    }

    public boolean func_213397_c(double distance) {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70909_n()) {
            if (this.func_70880_s()) {
                return SoundEvents.field_187645_R;
            }
            return this.field_70146_Z.nextInt(4) == 0 ? SoundEvents.field_187648_S : SoundEvents.field_187636_O;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187642_Q;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187639_P;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70652_k(Entity entityIn) {
        EntityDamageSource damage = new EntityDamageSource("mob", (Entity)this);
        damage.func_76351_m();
        float amount = 3.0f;
        if (this.getIsLava()) {
            damage.func_76361_j().func_76348_h();
        } else {
            amount = 6.0f;
        }
        return entityIn.func_70097_a((DamageSource)damage, amount);
    }

    public void func_70015_d(int seconds) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (source.func_76347_k()) {
            return false;
        }
        if (source == DamageSource.field_82727_n || source == DamageSource.field_82728_o) {
            return false;
        }
        boolean lava = this.getIsLava();
        if (!lava && !source.func_82725_o()) {
            amount /= 2.0f;
        }
        if (lava && source.func_82725_o()) {
            amount /= 2.0f;
        }
        if (this.func_70909_n() && source.func_76346_g() != null && source.func_76346_g() == this.func_70902_q() && !source.func_76346_g().func_225608_bj_()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_195064_c(EffectInstance potioneffectIn) {
        Effect type = potioneffectIn.func_188419_a();
        if (type == Effects.field_76436_u || type == Effects.field_82731_v) {
            return false;
        }
        return super.func_195064_c(potioneffectIn);
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (this.func_152114_e((LivingEntity)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
            }
        } else if (itemstack.func_77973_b() == Items.field_151072_bj && player.func_70068_e((Entity)this) < 9.0) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.func_193101_c(player);
                    this.field_70911_d.func_75270_a(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public LavaCatEntity createChild(AgeableEntity ageable) {
        LavaCatEntity lavacat = (LavaCatEntity)ModEntities.LAVA_CAT.get().func_200721_a(ageable.field_70170_p);
        if (this.func_70909_n()) {
            lavacat.func_184754_b(this.func_184753_b());
            lavacat.func_70903_f(true);
            lavacat.setIsLava(this.getIsLava());
        }
        return lavacat;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151065_br;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof LavaCatEntity)) {
            return false;
        }
        LavaCatEntity lavacat = (LavaCatEntity)otherAnimal;
        if (!lavacat.func_70909_n()) {
            return false;
        }
        return this.func_70880_s() && lavacat.func_70880_s();
    }

    public boolean getIsLava() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LAVA);
    }

    public void setIsLava(boolean val) {
        this.field_70180_af.func_187227_b(IS_LAVA, (Object)val);
        IAttributeInstance attr = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (val) {
            attr.func_111124_b(OBSIDIAN_SPEED_DEBUFF);
        } else {
            attr.func_111121_a(OBSIDIAN_SPEED_DEBUFF);
        }
    }

    protected void func_175544_ck() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsLava() && this.field_70170_p.func_175727_C(this.func_180425_c()) && this.field_70170_p.func_175710_j(this.func_180425_c()) && this.field_70146_Z.nextInt(30) == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187659_cY, SoundCategory.NEUTRAL, 0.2f, 1.3f);
        }
        if (this.getIsLava() && this.field_70171_ac) {
            this.setIsLava(false);
        } else if (!this.getIsLava() && this.func_180799_ab()) {
            this.setIsLava(true);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsLava", this.getIsLava());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setIsLava(compound.func_74767_n("IsLava"));
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        if (itextcomponent != null) {
            return super.func_200200_C_();
        }
        if (this.getIsLava()) {
            return new TranslationTextComponent("mysticalworld.entity.lava_cat", new Object[0]);
        }
        return new TranslationTextComponent("mysticalworld.entity.obsidian_cat", new Object[0]);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return spawnDataIn;
    }
}

