/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import epicsquid.mysticalworld.entity.EnderminiEntity;
import epicsquid.mysticalworld.entity.model.EnderminiModel;
import epicsquid.mysticalworld.entity.model.ModelHolder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.AbstractEyesLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EnderminiRenderer
extends MobRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
    private static final ResourceLocation ENDERMINI_TEXTURES = new ResourceLocation("mysticalworld", "textures/entity/endermini.png");
    private final Random rnd = new Random();

    public EnderminiRenderer(EntityRendererManager renderManagerIn, EnderminiModel<EnderminiEntity> model, float size) {
        super(renderManagerIn, model, size);
        this.func_177094_a((LayerRenderer)new EnderminiEyesLayer(this));
        this.func_177094_a(new HeldBlockLayer((IEntityRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>>)this));
    }

    @Nonnull
    public Vec3d getRenderOffset(EnderminiEntity p_225627_1_, float p_225627_2_) {
        if (p_225627_1_.isScreaming()) {
            double d0 = 0.02;
            return new Vec3d(this.rnd.nextGaussian() * 0.02, 0.0, this.rnd.nextGaussian() * 0.02);
        }
        return super.func_225627_b_((Entity)p_225627_1_, p_225627_2_);
    }

    public void render(EnderminiEntity p_225623_1_, float p_225623_2_, float p_225623_3_, MatrixStack stack, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
        BlockState blockstate = p_225623_1_.getHeldBlockState();
        EnderminiModel<EnderminiEntity> endermanmodel = this.getEntityModel();
        endermanmodel.field_78126_a = blockstate != null;
        endermanmodel.field_78125_b = p_225623_1_.isScreaming();
        stack.func_227860_a_();
        stack.func_227862_a_(0.4f, 0.4f, 0.4f);
        super.func_225623_a_((MobEntity)p_225623_1_, p_225623_2_, p_225623_3_, stack, p_225623_5_, p_225623_6_);
        stack.func_227865_b_();
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull EnderminiEntity entity) {
        return ENDERMINI_TEXTURES;
    }

    @Nonnull
    public EnderminiModel<EnderminiEntity> getEntityModel() {
        return ModelHolder.enderminiModel;
    }

    public static class EnderminiEyesLayer<T extends LivingEntity>
    extends AbstractEyesLayer<T, EnderminiModel<T>> {
        private static final RenderType SKIN = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("textures/entity/enderman/enderman_eyes.png"));

        public EnderminiEyesLayer(IEntityRenderer<T, EnderminiModel<T>> p_i50939_1_) {
            super(p_i50939_1_);
        }

        public RenderType func_225636_a_() {
            return SKIN;
        }
    }

    public static class HeldBlockLayer
    extends LayerRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
        public HeldBlockLayer(IEntityRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> p_i50949_1_) {
            super(p_i50949_1_);
        }

        public void render(@Nonnull MatrixStack p_225628_1_, @Nonnull IRenderTypeBuffer p_225628_2_, int p_225628_3_, EnderminiEntity p_225628_4_, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
            BlockState blockstate = p_225628_4_.getHeldBlockState();
            if (blockstate != null) {
                p_225628_1_.func_227860_a_();
                p_225628_1_.func_227861_a_(0.0, 0.6875, -0.75);
                p_225628_1_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
                p_225628_1_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                p_225628_1_.func_227861_a_(0.25, 0.1875, 0.25);
                p_225628_1_.func_227862_a_(-0.5f, -0.5f, 0.5f);
                p_225628_1_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175602_ab().renderBlock(blockstate, p_225628_1_, p_225628_2_, p_225628_3_, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                p_225628_1_.func_227865_b_();
            }
        }
    }

    public static class Factory
    implements IRenderFactory<EnderminiEntity> {
        public EntityRenderer<? super EnderminiEntity> createRenderFor(EntityRendererManager manager) {
            return new EnderminiRenderer(manager, ModelHolder.enderminiModel, 0.35f);
        }
    }
}

