/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.events;

import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.api.Capabilities;
import epicsquid.mysticalworld.api.IPlayerShoulderCapability;
import epicsquid.mysticalworld.capability.AnimalCooldownCapabilityProvider;
import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapabilityProvider;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.network.Networking;
import epicsquid.mysticalworld.network.ShoulderRide;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.GlassBottleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CapabilityHandler {
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        player.getCapability(Capabilities.SHOULDER_CAPABILITY).ifPresent(cap -> {
            if (cap.isShouldered()) {
                ShoulderRide message = new ShoulderRide(event.getPlayer(), (IPlayerShoulderCapability)cap);
                Networking.send(PacketDistributor.ALL.noArg(), message);
                try {
                    PlayerShoulderCapability.setRightShoulder.invokeExact(player, cap.generateShoulderNBT());
                }
                catch (Throwable throwable) {
                    MysticalWorld.LOG.error("Unable to fake player having a shoulder entity", throwable);
                }
            }
        });
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerPlayerEntity other : server.func_184103_al().func_181057_v()) {
            other.getCapability(Capabilities.SHOULDER_CAPABILITY).ifPresent(cap -> {
                if (cap.isShouldered()) {
                    ShoulderRide message = new ShoulderRide(event.getPlayer(), (IPlayerShoulderCapability)cap);
                    Networking.sendTo(message, player);
                    try {
                        PlayerShoulderCapability.setRightShoulder.invokeExact(other, cap.generateShoulderNBT());
                    }
                    catch (Throwable throwable) {
                        MysticalWorld.LOG.error("Unable to fake player having a shoulder entity", throwable);
                    }
                }
            });
        }
    }

    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof SquidEntity) {
            event.addCapability(AnimalCooldownCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new AnimalCooldownCapabilityProvider());
        } else if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(PlayerShoulderCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new PlayerShoulderCapabilityProvider());
        }
    }

    public static void onSquidMilked(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = (PlayerEntity)event.getEntity();
        ItemStack heldItem = player.func_184586_b(event.getHand());
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GlassBottleItem && event.getTarget() instanceof SquidEntity) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            if (!event.getWorld().field_72995_K) {
                event.getTarget().getCapability(AnimalCooldownCapabilityProvider.ANIMAL_COOLDOWN_CAPABILITY).ifPresent(cap -> {
                    if (cap.canHarvest()) {
                        cap.setCooldown(300L);
                        event.getWorld().func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187564_an, SoundCategory.PLAYERS, 0.5f, event.getWorld().field_73012_v.nextFloat() * 0.25f + 0.6f, true);
                        if (!player.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.INK_BOTTLE.get()));
                    } else {
                        player.func_146105_b(new TranslationTextComponent("message.squid.cooldown", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
                    }
                });
            }
        }
    }
}

